/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.provider.hook;

import org.apache.nifi.registry.hook.Event;
import org.apache.nifi.registry.hook.EventField;
import org.apache.nifi.registry.hook.EventHookException;
import org.apache.nifi.registry.hook.EventHookProvider;
import org.apache.nifi.registry.provider.ProviderConfigurationContext;
import org.apache.nifi.registry.provider.ProviderCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingEventHookProvider
implements EventHookProvider {
    static final Logger LOGGER = LoggerFactory.getLogger(LoggingEventHookProvider.class);

    public void onConfigured(ProviderConfigurationContext configurationContext) throws ProviderCreationException {
    }

    public void handle(Event event) throws EventHookException {
        StringBuilder builder = new StringBuilder().append(event.getEventType()).append(" [");
        int count = 0;
        for (EventField argument : event.getFields()) {
            if (count > 0) {
                builder.append(", ");
            }
            builder.append(argument.getName()).append("=").append(argument.getValue());
            ++count;
        }
        builder.append("] ");
        LOGGER.info(builder.toString());
    }
}

