/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.lang.ref.WeakReference;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.ConcurrentObjectCache;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.entitystore.EntityIterableCacheAdapter;
import jetbrains.exodus.entitystore.EntityIterableCacheStatistics;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityStoreSharedAsyncProcessor;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.QueryCancellingPolicy;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.env.ReadonlyTransactionException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 52\u00020\u0001:\u0006345678B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0001J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u0001J\u0015\u0010*\u001a\u0004\u0018\u00010\u00122\u0006\u0010+\u001a\u00020,\u00a2\u0006\u0002\u0010-J\u000e\u0010*\u001a\u00020\u00122\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020(J\u000e\u00101\u001a\u00020/2\u0006\u0010.\u001a\u00020/J\u0016\u00102\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0006\u0010%\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR&\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00170\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCache;", "", "store", "Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "(Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;)V", "cacheAdapter", "Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter;", "cachingDisabled", "", "getCachingDisabled", "()Z", "setCachingDisabled", "(Z)V", "config", "Ljetbrains/exodus/entitystore/PersistentEntityStoreConfig;", "Lorg/jetbrains/annotations/NotNull;", "deferredIterablesCache", "Ljetbrains/exodus/core/dataStructures/ConcurrentObjectCache;", "", "Ljetbrains/exodus/entitystore/ConcurrentCache;", "heavyIterablesCache", "isDispatcherThread", "iterableCountsCache", "Lkotlin/Pair;", "processor", "Ljetbrains/exodus/entitystore/EntityStoreSharedAsyncProcessor;", "getProcessor", "()Ljetbrains/exodus/entitystore/EntityStoreSharedAsyncProcessor;", "stats", "Ljetbrains/exodus/entitystore/EntityIterableCacheStatistics;", "getStats", "()Ljetbrains/exodus/entitystore/EntityIterableCacheStatistics;", "clear", "", "compareAndSetCacheAdapter", "old", "new", "count", "", "countsCacheHitRate", "", "getCacheAdapter", "getCachedCount", "handle", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "(Ljetbrains/exodus/entitystore/EntityIterableHandle;)Ljava/lang/Long;", "it", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "hitRate", "putIfNotCached", "setCachedCount", "CacheHitRateAdjuster", "CachingCancellingPolicy", "Companion", "EntityIterableAsyncInstantiation", "TooLongEntityIterableInstantiationException", "TooLongEntityIterableInstantiationReason", "xodus-entity-store"})
public final class EntityIterableCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PersistentEntityStoreImpl store;
    @NotNull
    private final PersistentEntityStoreConfig config;
    @NotNull
    private EntityIterableCacheAdapter cacheAdapter;
    @NotNull
    private final EntityIterableCacheStatistics stats;
    @NotNull
    private ConcurrentObjectCache<Object, Long> deferredIterablesCache;
    @NotNull
    private ConcurrentObjectCache<Object, Pair<Long, Long>> iterableCountsCache;
    @NotNull
    private final ConcurrentObjectCache<Object, Long> heavyIterablesCache;
    @NotNull
    private final EntityStoreSharedAsyncProcessor processor;
    private boolean cachingDisabled;

    /*
     * WARNING - void declaration
     */
    public EntityIterableCache(@NotNull PersistentEntityStoreImpl store) {
        void $this$processor_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
        Object object = this.store.getConfig();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"store.config");
        this.config = object;
        this.cacheAdapter = new EntityIterableCacheAdapter(this.config, null, null, 6, null);
        this.stats = new EntityIterableCacheStatistics();
        this.deferredIterablesCache = new ConcurrentObjectCache(this.config.getEntityIterableCacheSize());
        this.iterableCountsCache = new ConcurrentObjectCache(this.config.getEntityIterableCacheCountsCacheSize());
        this.heavyIterablesCache = new ConcurrentObjectCache(this.config.getEntityIterableCacheHeavyIterablesCacheSize());
        Object object2 = object = new EntityStoreSharedAsyncProcessor(this.config.getEntityIterableCacheThreadCount());
        EntityIterableCache entityIterableCache = this;
        boolean bl = false;
        $this$processor_u24lambda_u2d0.start();
        entityIterableCache.processor = object;
        this.cachingDisabled = this.config.isCachingDisabled();
        SharedTimer.registerPeriodicTask((SharedTimer.ExpirablePeriodicTask)new CacheHitRateAdjuster(this));
    }

    @NotNull
    public final EntityIterableCacheStatistics getStats() {
        return this.stats;
    }

    @NotNull
    public final EntityStoreSharedAsyncProcessor getProcessor() {
        return this.processor;
    }

    public final boolean getCachingDisabled() {
        return this.cachingDisabled;
    }

    public final void setCachingDisabled(boolean bl) {
        this.cachingDisabled = bl;
    }

    @NotNull
    public final Object getCacheAdapter() {
        return this.cacheAdapter;
    }

    public final float hitRate() {
        return this.cacheAdapter.hitRate();
    }

    public final float countsCacheHitRate() {
        return this.iterableCountsCache.hitRate();
    }

    public final int count() {
        return this.cacheAdapter.count();
    }

    public final void clear() {
        this.cacheAdapter.clear();
        this.deferredIterablesCache = new ConcurrentObjectCache(this.config.getEntityIterableCacheSize());
        this.iterableCountsCache = new ConcurrentObjectCache(this.config.getEntityIterableCacheCountsCacheSize());
    }

    @NotNull
    public final EntityIterableBase putIfNotCached(@NotNull EntityIterableBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this.cachingDisabled || !it.canBeCached()) {
            return it;
        }
        EntityIterableHandle entityIterableHandle = it.getHandle();
        Intrinsics.checkNotNullExpressionValue((Object)entityIterableHandle, (String)"it.handle");
        EntityIterableHandle handle = entityIterableHandle;
        PersistentStoreTransaction persistentStoreTransaction = it.getTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)persistentStoreTransaction, (String)"it.transaction");
        PersistentStoreTransaction txn = persistentStoreTransaction;
        EntityIterableCacheAdapter entityIterableCacheAdapter = txn.getLocalCache();
        Intrinsics.checkNotNullExpressionValue((Object)entityIterableCacheAdapter, (String)"txn.localCache");
        EntityIterableCacheAdapter localCache = entityIterableCacheAdapter;
        txn.localCacheAttempt();
        EntityIterableBase cached = localCache.tryKey(handle);
        if (cached != null) {
            if (!cached.getHandle().isExpired()) {
                txn.localCacheHit();
                this.stats.incTotalHits();
                return cached;
            }
            localCache.remove(handle);
        }
        this.stats.incTotalMisses();
        if (txn.isMutable() || !txn.isCurrent() || !txn.isCachingRelevant()) {
            return it;
        }
        if (!localCache.isSparse()) {
            long currentMillis = System.currentTimeMillis();
            Object handleIdentity = handle.getIdentity();
            Long whenCached = (Long)this.deferredIterablesCache.tryKey(handleIdentity);
            if (whenCached == null) {
                this.deferredIterablesCache.cacheObject(handleIdentity, (Object)currentMillis);
                return it;
            }
            if (whenCached + (long)this.config.getEntityIterableCacheDeferredDelay() > currentMillis) {
                return it;
            }
        }
        if (this.isDispatcherThread()) {
            CachedInstanceIterable cachedInstanceIterable = it.getOrCreateCachedInstance(txn);
            Intrinsics.checkNotNullExpressionValue((Object)cachedInstanceIterable, (String)"it.getOrCreateCachedInstance(txn)");
            return cachedInstanceIterable;
        }
        new EntityIterableAsyncInstantiation(handle, it, true);
        return it;
    }

    @Nullable
    public final Long getCachedCount(@NotNull EntityIterableHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        Object identity = handle.getIdentity();
        Pair pair = (Pair)this.iterableCountsCache.tryKey(identity);
        if (pair != null) {
            Pair $dstr$count$time = pair;
            boolean bl = false;
            long count = ((Number)$dstr$count$time.component1()).longValue();
            long time = ((Number)$dstr$count$time.component2()).longValue();
            if (System.currentTimeMillis() - time <= Long.max(this.config.getEntityIterableCacheCountsLifeTime(), count)) {
                this.getStats().incTotalCountHits();
                return count;
            }
            Pair cfr_ignored_0 = (Pair)this.iterableCountsCache.remove(identity);
        }
        this.stats.incTotalCountMisses();
        return null;
    }

    public final long getCachedCount(@NotNull EntityIterableBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EntityIterableHandle entityIterableHandle = it.getHandle();
        Intrinsics.checkNotNullExpressionValue((Object)entityIterableHandle, (String)"it.handle");
        EntityIterableHandle handle = entityIterableHandle;
        Long result = this.getCachedCount(handle);
        if (result == null && this.isDispatcherThread()) {
            return it.getOrCreateCachedInstance(it.getTransaction()).size();
        }
        if (it.isThreadSafe()) {
            new EntityIterableAsyncInstantiation(handle, it, false);
        }
        Long l = result;
        return l == null ? -1L : l;
    }

    public final void setCachedCount(@NotNull EntityIterableHandle handle, long count) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        this.iterableCountsCache.cacheObject(handle.getIdentity(), (Object)TuplesKt.to((Object)count, (Object)System.currentTimeMillis()));
    }

    public final boolean isDispatcherThread() {
        return this.processor.isDispatcherThread();
    }

    public final boolean compareAndSetCacheAdapter(@NotNull Object old, @NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)object, (String)"new");
        if (this.cacheAdapter == old) {
            this.cacheAdapter = (EntityIterableCacheAdapter)object;
            return true;
        }
        return false;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0014J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0001H\u0016R\u0012\u0010\t\u001a\u00060\nR\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCache$EntityIterableAsyncInstantiation;", "Ljetbrains/exodus/core/execution/Job;", "handle", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "it", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "isConsistent", "", "(Ljetbrains/exodus/entitystore/EntityIterableCache;Ljetbrains/exodus/entitystore/EntityIterableHandle;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;Z)V", "cancellingPolicy", "Ljetbrains/exodus/entitystore/EntityIterableCache$CachingCancellingPolicy;", "Ljetbrains/exodus/entitystore/EntityIterableCache;", "execute", "", "getGroup", "", "Lorg/jetbrains/annotations/NotNull;", "getName", "hashCode", "", "isEqualTo", "job", "xodus-entity-store"})
    private final class EntityIterableAsyncInstantiation
    extends Job {
        @NotNull
        private final EntityIterableHandle handle;
        @NotNull
        private final EntityIterableBase it;
        private final boolean isConsistent;
        @NotNull
        private final CachingCancellingPolicy cancellingPolicy;

        public EntityIterableAsyncInstantiation(@NotNull EntityIterableHandle handle, EntityIterableBase it, boolean isConsistent) {
            Intrinsics.checkNotNullParameter((Object)EntityIterableCache.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this.handle = handle;
            this.it = it;
            this.isConsistent = isConsistent;
            this.cancellingPolicy = new CachingCancellingPolicy(this.isConsistent && this.handle.isConsistent());
            this.setProcessor((JobProcessor)EntityIterableCache.this.getProcessor());
            if (this.queue(Priority.normal)) {
                EntityIterableCache.this.getStats().incTotalJobsEnqueued();
                if (!this.isConsistent) {
                    EntityIterableCache.this.getStats().incTotalCountJobsEnqueued();
                }
            } else {
                EntityIterableCache.this.getStats().incTotalJobsNonQueued();
            }
        }

        @NotNull
        public String getName() {
            return Intrinsics.stringPlus((String)"Caching job for handle ", (Object)this.it.getHandle());
        }

        @NotNull
        public String getGroup() {
            String string = EntityIterableCache.this.store.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"store.location");
            return string;
        }

        public boolean isEqualTo(@NotNull Job job) {
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            return Intrinsics.areEqual((Object)this.handle, (Object)((EntityIterableAsyncInstantiation)job).handle);
        }

        public int hashCode() {
            int hc = this.handle.hashCode() & 0xFFFEFFFE;
            return this.isConsistent ? hc : hc | 1;
        }

        protected void execute() {
            Long lastCancelled;
            long started = System.currentTimeMillis();
            if (!this.cancellingPolicy.canStartAt(started)) {
                EntityIterableCache.this.getStats().incTotalJobsNotStarted();
                return;
            }
            boolean isConsistent = this.cancellingPolicy.isConsistent();
            Object iterableIdentity = this.handle.getIdentity();
            if (isConsistent && (lastCancelled = (Long)EntityIterableCache.this.heavyIterablesCache.tryKey(iterableIdentity)) != null) {
                if (lastCancelled + EntityIterableCache.this.config.getEntityIterableCacheHeavyIterablesLifeSpan() > started) {
                    EntityIterableCache.this.getStats().incTotalJobsNotStarted();
                    Companion.getLogger().info((Function0)new Function0<Object>(EntityIterableCache.this, this){
                        final /* synthetic */ EntityIterableCache this$0;
                        final /* synthetic */ EntityIterableAsyncInstantiation this$1;
                        {
                            this.this$0 = $receiver;
                            this.this$1 = $receiver2;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return Intrinsics.stringPlus((String)"Heavy iterable not started, handle=", (Object)EntityIterableCache.Companion.toString(EntityIterableCache.access$getConfig$p(this.this$0), EntityIterableAsyncInstantiation.access$getHandle$p(this.this$1)));
                        }
                    });
                    return;
                }
                EntityIterableCache.this.heavyIterablesCache.remove(iterableIdentity);
            }
            EntityIterableCache.this.getStats().incTotalJobsStarted();
            EntityIterableCache.this.store.executeInReadonlyTransaction(arg_0 -> EntityIterableAsyncInstantiation.execute$lambda-0(this, isConsistent, started, EntityIterableCache.this, iterableIdentity, arg_0));
        }

        private static final void execute$lambda-0(EntityIterableAsyncInstantiation this$0, boolean $isConsistent, long $started, EntityIterableCache this$1, Object $iterableIdentity, StoreTransaction txn) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
            if (!this$0.handle.isConsistent()) {
                this$0.handle.resetBirthTime();
            }
            PersistentStoreTransaction cfr_ignored_0 = (PersistentStoreTransaction)txn;
            CachingCancellingPolicy cachingCancellingPolicy = this$0.cancellingPolicy;
            EntityIterableCacheAdapter entityIterableCacheAdapter = ((PersistentStoreTransaction)txn).getLocalCache();
            Intrinsics.checkNotNullExpressionValue((Object)entityIterableCacheAdapter, (String)"txn.localCache");
            cachingCancellingPolicy.setLocalCache(entityIterableCacheAdapter);
            ((PersistentStoreTransaction)txn).setQueryCancellingPolicy(this$0.cancellingPolicy);
            try {
                long cachedIn;
                this$0.it.getOrCreateCachedInstance((PersistentStoreTransaction)txn, !$isConsistent);
                if (Companion.getLogger().isInfoEnabled() && (cachedIn = System.currentTimeMillis() - $started) > 1000L) {
                    Companion.getLogger().info((Function0)new Function0<Object>($isConsistent, cachedIn, this$1, this$0){
                        final /* synthetic */ boolean $isConsistent;
                        final /* synthetic */ long $cachedIn;
                        final /* synthetic */ EntityIterableCache this$0;
                        final /* synthetic */ EntityIterableAsyncInstantiation this$1;
                        {
                            this.$isConsistent = $isConsistent;
                            this.$cachedIn = $cachedIn;
                            this.this$0 = $receiver;
                            this.this$1 = $receiver2;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            String action = this.$isConsistent ? "Cached" : "Cached (inconsistent)";
                            return action + " in " + this.$cachedIn + " ms, handle=" + EntityIterableCache.Companion.toString(EntityIterableCache.access$getConfig$p(this.this$0), EntityIterableAsyncInstantiation.access$getHandle$p(this.this$1));
                        }
                    });
                }
            }
            catch (ReadonlyTransactionException rte) {
                String action = $isConsistent ? "Caching" : "Caching (inconsistent)";
                Companion.getLogger().error(Intrinsics.stringPlus((String)action, (Object)" failed with ReadonlyTransactionException. Re-queueing..."));
                this$0.queue(Priority.below_normal);
            }
            catch (TooLongEntityIterableInstantiationException e) {
                this$1.getStats().incTotalJobsInterrupted();
                if ($isConsistent) {
                    this$1.heavyIterablesCache.cacheObject($iterableIdentity, (Object)System.currentTimeMillis());
                }
                Companion.getLogger().info((Function0)new Function0<Object>($isConsistent, e, this$1, this$0){
                    final /* synthetic */ boolean $isConsistent;
                    final /* synthetic */ TooLongEntityIterableInstantiationException $e;
                    final /* synthetic */ EntityIterableCache this$0;
                    final /* synthetic */ EntityIterableAsyncInstantiation this$1;
                    {
                        this.$isConsistent = $isConsistent;
                        this.$e = $e;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        String action = this.$isConsistent ? "Caching" : "Caching (inconsistent)";
                        return action + " forcibly stopped, " + this.$e.getReason().getMessage() + ": " + EntityIterableCache.Companion.toString(EntityIterableCache.access$getConfig$p(this.this$0), EntityIterableAsyncInstantiation.access$getHandle$p(this.this$1));
                    }
                });
            }
        }

        public static final /* synthetic */ EntityIterableHandle access$getHandle$p(EntityIterableAsyncInstantiation $this) {
            return $this.handle;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCache$TooLongEntityIterableInstantiationException;", "Ljetbrains/exodus/ExodusException;", "reason", "Ljetbrains/exodus/entitystore/EntityIterableCache$TooLongEntityIterableInstantiationReason;", "(Ljetbrains/exodus/entitystore/EntityIterableCache$TooLongEntityIterableInstantiationReason;)V", "getReason", "()Ljetbrains/exodus/entitystore/EntityIterableCache$TooLongEntityIterableInstantiationReason;", "xodus-entity-store"})
    private static final class TooLongEntityIterableInstantiationException
    extends ExodusException {
        @NotNull
        private final TooLongEntityIterableInstantiationReason reason;

        public TooLongEntityIterableInstantiationException(@NotNull TooLongEntityIterableInstantiationReason reason) {
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            super(reason.getMessage());
            this.reason = reason;
        }

        @NotNull
        public final TooLongEntityIterableInstantiationReason getReason() {
            return this.reason;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCache$TooLongEntityIterableInstantiationReason;", "", "message", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "CACHE_ADAPTER_OBSOLETE", "JOB_OVERDUE", "xodus-entity-store"})
    private static final class TooLongEntityIterableInstantiationReason
    extends Enum<TooLongEntityIterableInstantiationReason> {
        @NotNull
        private final String message;
        public static final /* enum */ TooLongEntityIterableInstantiationReason CACHE_ADAPTER_OBSOLETE = new TooLongEntityIterableInstantiationReason("cache adapter is obsolete");
        public static final /* enum */ TooLongEntityIterableInstantiationReason JOB_OVERDUE = new TooLongEntityIterableInstantiationReason("caching job is overdue");
        private static final /* synthetic */ TooLongEntityIterableInstantiationReason[] $VALUES;

        private TooLongEntityIterableInstantiationReason(String message) {
            this.message = message;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public static TooLongEntityIterableInstantiationReason[] values() {
            return (TooLongEntityIterableInstantiationReason[])$VALUES.clone();
        }

        public static TooLongEntityIterableInstantiationReason valueOf(String value) {
            return Enum.valueOf(TooLongEntityIterableInstantiationReason.class, value);
        }

        static {
            $VALUES = tooLongEntityIterableInstantiationReasonArray = new TooLongEntityIterableInstantiationReason[]{TooLongEntityIterableInstantiationReason.CACHE_ADAPTER_OBSOLETE, TooLongEntityIterableInstantiationReason.JOB_OVERDUE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0016R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\r"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCache$CacheHitRateAdjuster;", "Ljetbrains/exodus/core/execution/SharedTimer$ExpirablePeriodicTask;", "cache", "Ljetbrains/exodus/entitystore/EntityIterableCache;", "(Ljetbrains/exodus/entitystore/EntityIterableCache;)V", "cacheRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "isExpired", "", "()Z", "run", "", "xodus-entity-store"})
    private static final class CacheHitRateAdjuster
    implements SharedTimer.ExpirablePeriodicTask {
        @NotNull
        private final WeakReference<EntityIterableCache> cacheRef;

        public CacheHitRateAdjuster(@NotNull EntityIterableCache cache) {
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            this.cacheRef = new WeakReference<EntityIterableCache>(cache);
        }

        public boolean isExpired() {
            return this.cacheRef.get() == null;
        }

        public void run() {
            EntityIterableCache cache;
            EntityIterableCache entityIterableCache = cache = (EntityIterableCache)this.cacheRef.get();
            if (entityIterableCache != null) {
                EntityIterableCacheAdapter entityIterableCacheAdapter = entityIterableCache.cacheAdapter;
                if (entityIterableCacheAdapter != null) {
                    entityIterableCacheAdapter.adjustHitRate();
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCache$CachingCancellingPolicy;", "Ljetbrains/exodus/entitystore/QueryCancellingPolicy;", "isConsistent", "", "(Ljetbrains/exodus/entitystore/EntityIterableCache;Z)V", "cachingTimeout", "", "()Z", "localCache", "Ljetbrains/exodus/entitystore/EntityIterableCacheAdapter;", "startCachingTimeout", "startTime", "canStartAt", "currentMillis", "doCancel", "", "needToCancel", "setLocalCache", "xodus-entity-store"})
    private final class CachingCancellingPolicy
    implements QueryCancellingPolicy {
        private final boolean isConsistent;
        private final long startTime;
        private final long cachingTimeout;
        private final long startCachingTimeout;
        @Nullable
        private EntityIterableCacheAdapter localCache;

        public CachingCancellingPolicy(boolean isConsistent) {
            Intrinsics.checkNotNullParameter((Object)EntityIterableCache.this, (String)"this$0");
            this.isConsistent = isConsistent;
            this.startTime = System.currentTimeMillis();
            this.cachingTimeout = this.isConsistent ? EntityIterableCache.this.config.getEntityIterableCacheCachingTimeout() : EntityIterableCache.this.config.getEntityIterableCacheCountsCachingTimeout();
            this.startCachingTimeout = EntityIterableCache.this.config.getEntityIterableCacheStartCachingTimeout();
        }

        public final boolean isConsistent() {
            return this.isConsistent;
        }

        public final boolean canStartAt(long currentMillis) {
            return currentMillis - this.startTime < this.startCachingTimeout;
        }

        public final void setLocalCache(@NotNull EntityIterableCacheAdapter localCache) {
            Intrinsics.checkNotNullParameter((Object)localCache, (String)"localCache");
            this.localCache = localCache;
        }

        public boolean needToCancel() {
            return this.isConsistent && EntityIterableCache.this.cacheAdapter != this.localCache || System.currentTimeMillis() - this.startTime > this.cachingTimeout;
        }

        public void doCancel() {
            TooLongEntityIterableInstantiationReason reason = this.isConsistent && EntityIterableCache.this.cacheAdapter != this.localCache ? TooLongEntityIterableInstantiationReason.CACHE_ADAPTER_OBSOLETE : TooLongEntityIterableInstantiationReason.JOB_OVERDUE;
            throw new TooLongEntityIterableInstantiationException(reason);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Ljetbrains/exodus/entitystore/EntityIterableCache$Companion;", "Lmu/KLogging;", "()V", "toString", "", "config", "Ljetbrains/exodus/entitystore/PersistentEntityStoreConfig;", "handle", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "xodus-entity-store"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @NotNull
        public final String toString(@NotNull PersistentEntityStoreConfig config, @NotNull EntityIterableHandle handle) {
            String string;
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
            if (config.getEntityIterableCacheUseHumanReadable()) {
                String string2 = EntityIterableBase.getHumanReadablePresentation(handle);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHumanReadablePresentation(handle)");
                string = string2;
            } else {
                string = handle.toString();
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

