/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.Timestamps;

public class YearFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "year(N)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function arg = args.getQuick(0);
        return new YearFunction(arg);
    }

    public static final class YearFunction
    extends IntFunction
    implements UnaryFunction {
        private final Function arg;

        public YearFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public int getInt(Record rec) {
            long value = this.arg.getTimestamp(rec);
            if (value != Long.MIN_VALUE) {
                return Timestamps.getYear(value);
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public String getName() {
            return "year";
        }
    }
}

