/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.CommitFailedException;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableWriterAPI;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.wal.MetadataService;
import io.questdb.cutlass.line.tcp.DefaultColumnTypes;
import io.questdb.cutlass.line.tcp.DirectByteSymbolLookup;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.tcp.NetworkIOJob;
import io.questdb.cutlass.line.tcp.SymbolCache;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.BoolList;
import io.questdb.std.ByteCharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceHashSet;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.ByteCharSequence;
import io.questdb.std.str.DirectByteCharSequence;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;

public class TableUpdateDetails
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TableUpdateDetails.class);
    private static final DirectByteSymbolLookup NOT_FOUND_LOOKUP = value -> -2;
    private final DefaultColumnTypes defaultColumnTypes;
    private final long defaultCommitInterval;
    private final long defaultMaxUncommittedRows;
    private final CairoEngine engine;
    private final ThreadLocalDetails[] localDetailsArray;
    private final MillisecondClock millisecondClock;
    private final TableToken tableToken;
    private final int timestampIndex;
    private final long writerTickRowsCountMod;
    private boolean assignedToJob = false;
    private long eventsProcessedSinceReshuffle = 0L;
    private long lastMeasurementMillis = Long.MAX_VALUE;
    private MetadataService metadataService;
    private int networkIOOwnerCount = 0;
    private long nextCommitTime;
    private TableWriterAPI writerAPI;
    private volatile boolean writerInError;
    private int writerThreadId;

    TableUpdateDetails(LineTcpReceiverConfiguration configuration, CairoEngine engine, TableWriterAPI writer, int writerThreadId, NetworkIOJob[] netIoJobs, DefaultColumnTypes defaultColumnTypes) {
        this.writerThreadId = writerThreadId;
        this.engine = engine;
        this.defaultColumnTypes = defaultColumnTypes;
        int n = netIoJobs.length;
        CairoConfiguration cairoConfiguration = engine.getConfiguration();
        this.millisecondClock = cairoConfiguration.getMillisecondClock();
        this.writerTickRowsCountMod = cairoConfiguration.getWriterTickRowsCountMod();
        this.defaultCommitInterval = configuration.getCommitIntervalDefault();
        this.defaultMaxUncommittedRows = cairoConfiguration.getMaxUncommittedRows();
        this.writerAPI = writer;
        TableRecordMetadata tableMetadata = writer.getMetadata();
        this.timestampIndex = tableMetadata.getTimestampIndex();
        this.tableToken = writer.getTableToken();
        if (writer.supportsMultipleWriters()) {
            this.metadataService = null;
            this.nextCommitTime = this.millisecondClock.getTicks() + this.defaultCommitInterval;
        } else {
            this.metadataService = (MetadataService)((Object)writer);
            this.metadataService.updateCommitInterval(configuration.getCommitIntervalFraction(), configuration.getCommitIntervalDefault());
            this.nextCommitTime = this.millisecondClock.getTicks() + this.metadataService.getCommitInterval();
        }
        this.localDetailsArray = new ThreadLocalDetails[n];
        for (int i = 0; i < n; ++i) {
            this.localDetailsArray[i] = new ThreadLocalDetails(configuration, netIoJobs[i].getUnusedSymbolCaches(), writer.getMetadata().getColumnCount());
        }
    }

    public void addReference(int workerId) {
        if (this.writerThreadId != -1) {
            ++this.networkIOOwnerCount;
        }
        LOG.info().$("network IO thread using table [workerId=").$(workerId).$(", tableName=").$(this.tableToken).$(", nNetworkIoWorkers=").$(this.networkIOOwnerCount).$(']').$();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        TableUpdateDetails tableUpdateDetails = this;
        synchronized (tableUpdateDetails) {
            this.closeNoLock();
        }
    }

    public void closeLocals() {
        for (int n = 0; n < this.localDetailsArray.length; ++n) {
            LOG.info().$("closing table parsers [tableName=").$(this.tableToken).$(']').$();
            this.localDetailsArray[n] = Misc.free(this.localDetailsArray[n]);
        }
    }

    public void closeNoLock() {
        if (this.writerThreadId != Integer.MIN_VALUE) {
            LOG.info().$("closing table writer [tableName=").$(this.tableToken).$(']').$();
            this.closeLocals();
            if (null != this.writerAPI) {
                try {
                    if (!this.writerInError) {
                        this.writerAPI.commit();
                    }
                }
                catch (Throwable ex) {
                    LOG.error().$("cannot commit writer transaction, rolling back before releasing it [table=").$(this.tableToken).$(",ex=").$(ex).I$();
                }
                finally {
                    this.writerAPI = Misc.free(this.writerAPI);
                    this.metadataService = null;
                }
            }
            this.writerThreadId = Integer.MIN_VALUE;
        }
    }

    public long getEventsProcessedSinceReshuffle() {
        return this.eventsProcessedSinceReshuffle;
    }

    public long getLastMeasurementMillis() {
        return this.lastMeasurementMillis;
    }

    public MillisecondClock getMillisecondClock() {
        return this.millisecondClock;
    }

    public int getNetworkIOOwnerCount() {
        return this.networkIOOwnerCount;
    }

    public String getTableNameUtf16() {
        return this.tableToken.getTableName();
    }

    public TableToken getTableToken() {
        return this.tableToken;
    }

    public int getWriterThreadId() {
        return this.writerThreadId;
    }

    public void incrementEventsProcessedSinceReshuffle() {
        ++this.eventsProcessedSinceReshuffle;
    }

    public boolean isAssignedToJob() {
        return this.assignedToJob;
    }

    public boolean isWriterInError() {
        return this.writerInError;
    }

    public void removeReference(int workerId) {
        if (this.writerThreadId != -1) {
            --this.networkIOOwnerCount;
        }
        this.localDetailsArray[workerId].clear();
        LOG.info().$("network IO thread released table [workerId=").$(workerId).$(", tableName=").$(this.tableToken).$(", nNetworkIoWorkers=").$(this.networkIOOwnerCount).I$();
    }

    public void setAssignedToJob(boolean assignedToJob) {
        this.assignedToJob = assignedToJob;
    }

    public void setWriterInError() {
        this.writerInError = true;
    }

    public void tick() {
        if (this.metadataService != null) {
            this.metadataService.tick();
        }
    }

    private void commit(boolean withLag) throws CommitFailedException {
        if (this.writerAPI.getUncommittedRowCount() > 0L) {
            try {
                LOG.debug().$("time-based commit " + (withLag ? "with lag " : "") + "[rows=").$(this.writerAPI.getUncommittedRowCount()).$(", table=").$(this.tableToken).I$();
                if (withLag) {
                    this.writerAPI.ic();
                } else {
                    this.writerAPI.commit();
                }
            }
            catch (Throwable ex) {
                this.setWriterInError();
                LOG.error().$("could not commit [table=").$(this.tableToken).$(", e=").$(ex).I$();
                try {
                    this.writerAPI.rollback();
                }
                catch (Throwable th) {
                    LOG.error().$("could not perform emergency rollback [table=").$(this.tableToken).$(", e=").$(th).I$();
                }
                throw CommitFailedException.instance(ex);
            }
        }
    }

    private long getCommitInterval() {
        if (this.metadataService != null) {
            return this.metadataService.getCommitInterval();
        }
        return this.defaultCommitInterval;
    }

    private long getMetaMaxUncommittedRows() {
        if (this.metadataService != null) {
            return this.metadataService.getMetaMaxUncommittedRows();
        }
        return this.defaultMaxUncommittedRows;
    }

    long commitIfIntervalElapsed(long wallClockMillis) throws CommitFailedException {
        if (wallClockMillis < this.nextCommitTime) {
            return this.nextCommitTime;
        }
        if (this.writerAPI != null) {
            long commitInterval = this.getCommitInterval();
            long start = this.millisecondClock.getTicks();
            this.commit(wallClockMillis - this.lastMeasurementMillis < commitInterval);
            this.nextCommitTime += commitInterval + this.millisecondClock.getTicks() - start;
        }
        return this.nextCommitTime;
    }

    void commitIfMaxUncommittedRowsCountReached() throws CommitFailedException {
        long rowsSinceCommit = this.writerAPI.getUncommittedRowCount();
        if (rowsSinceCommit < this.getMetaMaxUncommittedRows()) {
            if ((rowsSinceCommit & this.writerTickRowsCountMod) == 0L) {
                this.tick();
            }
            return;
        }
        LOG.debug().$("max-uncommitted-rows commit with lag [").$(this.tableToken).I$();
        this.nextCommitTime = this.millisecondClock.getTicks() + this.getCommitInterval();
        try {
            this.writerAPI.ic();
        }
        catch (Throwable th) {
            LOG.error().$("could not commit line protocol measurement [tableName=").$(this.writerAPI.getTableToken()).$(", message=").$(th.getMessage()).$(th).I$();
            this.writerAPI.rollback();
            throw CommitFailedException.instance(th);
        }
        this.tick();
    }

    ThreadLocalDetails getThreadLocalDetails(int workerId) {
        this.lastMeasurementMillis = this.millisecondClock.getTicks();
        return this.localDetailsArray[workerId];
    }

    int getTimestampIndex() {
        return this.timestampIndex;
    }

    TableWriterAPI getWriter() {
        return this.writerAPI;
    }

    void releaseWriter(boolean commit) {
        if (this.writerAPI != null) {
            try {
                if (commit) {
                    LOG.debug().$("release commit [table=").$(this.tableToken).I$();
                    this.writerAPI.commit();
                }
            }
            catch (Throwable ex) {
                LOG.error().$("writer commit fails, force closing it [table=").$(this.tableToken).$(",ex=").$(ex).I$();
            }
            finally {
                this.writerAPI = Misc.free(this.writerAPI);
                this.metadataService = null;
            }
        }
    }

    public class ThreadLocalDetails
    implements Closeable {
        static final int COLUMN_NOT_FOUND = -1;
        static final int DUPLICATED_COLUMN = -2;
        private final LowerCaseCharSequenceHashSet addedColsUtf16 = new LowerCaseCharSequenceHashSet();
        private final ByteCharSequenceIntHashMap columnIndexByNameUtf8 = new ByteCharSequenceIntHashMap();
        private final ByteCharSequenceIntHashMap columnTypeByNameUtf8 = new ByteCharSequenceIntHashMap();
        private final IntList columnTypeMeta = new IntList();
        private final IntList columnTypes = new IntList();
        private final LineTcpReceiverConfiguration configuration;
        private final Path path = new Path();
        private final BoolList processedCols = new BoolList();
        private final ObjList<SymbolCache> symbolCacheByColumnIndex = new ObjList();
        private final StringSink tempSink = new StringSink();
        private final ObjList<SymbolCache> unusedSymbolCaches;
        private boolean clean = true;
        private String colNameUtf16;
        private ByteCharSequence colNameUtf8;
        private int columnCount;
        private TableRecordMetadata latestKnownMetadata;
        private String symbolNameTemp;
        private TxReader txReader;

        ThreadLocalDetails(LineTcpReceiverConfiguration lineTcpReceiverConfiguration, ObjList<SymbolCache> unusedSymbolCaches, int columnCount) {
            this.configuration = lineTcpReceiverConfiguration;
            this.unusedSymbolCaches = unusedSymbolCaches;
            this.columnCount = columnCount;
            this.columnTypeMeta.add(0);
        }

        @Override
        public void close() {
            Misc.freeObjList(this.symbolCacheByColumnIndex);
            Misc.free(this.path);
            this.txReader = Misc.free(this.txReader);
            this.latestKnownMetadata = Misc.free(this.latestKnownMetadata);
        }

        private DirectByteSymbolLookup addSymbolCache(int colWriterIndex) {
            try (TableReader reader = TableUpdateDetails.this.engine.getReader(AllowAllCairoSecurityContext.INSTANCE, TableUpdateDetails.this.tableToken);){
                SymbolCache symCache;
                int symIndex = this.resolveSymbolIndexAndName(reader.getMetadata(), colWriterIndex);
                if (this.symbolNameTemp == null || symIndex < 0) {
                    DirectByteSymbolLookup directByteSymbolLookup = NOT_FOUND_LOOKUP;
                    return directByteSymbolLookup;
                }
                CairoConfiguration cairoConfiguration = TableUpdateDetails.this.engine.getConfiguration();
                this.path.of(cairoConfiguration.getRoot()).concat(TableUpdateDetails.this.tableToken);
                int lastUnusedSymbolCacheIndex = this.unusedSymbolCaches.size() - 1;
                if (lastUnusedSymbolCacheIndex > -1) {
                    symCache = this.unusedSymbolCaches.get(lastUnusedSymbolCacheIndex);
                    this.unusedSymbolCaches.remove(lastUnusedSymbolCacheIndex);
                } else {
                    symCache = new SymbolCache(this.configuration);
                }
                if (this.clean) {
                    if (this.txReader == null) {
                        this.txReader = new TxReader(cairoConfiguration.getFilesFacade());
                    }
                    int pathLen = this.path.length();
                    this.txReader.ofRO(this.path.concat("_txn").$(), reader.getPartitionedBy());
                    this.path.trimTo(pathLen);
                    this.clean = false;
                }
                long columnNameTxn = reader.getColumnVersionReader().getDefaultColumnNameTxn(colWriterIndex);
                assert (symIndex <= colWriterIndex);
                symCache.of(cairoConfiguration, TableUpdateDetails.this.writerAPI, colWriterIndex, this.path, this.symbolNameTemp, symIndex, this.txReader, columnNameTxn);
                this.symbolCacheByColumnIndex.extendAndSet(colWriterIndex, symCache);
                SymbolCache symbolCache = symCache;
                return symbolCache;
            }
        }

        private int getColumnIndex0(DirectByteCharSequence colNameUtf8, boolean hasNonAsciiChars, @NotNull TableRecordMetadata metadata) {
            CharSequence colNameUtf16 = Chars.utf8ToUtf16(colNameUtf8, this.tempSink, hasNonAsciiChars);
            int index = this.addedColsUtf16.keyIndex(colNameUtf16);
            if (index > -1) {
                int colIndex = metadata.getColumnIndexQuiet(colNameUtf16);
                int colWriterIndex = colIndex < 0 ? colIndex : metadata.getWriterIndex(colIndex);
                ByteCharSequence onHeapColNameUtf8 = ByteCharSequence.newInstance(colNameUtf8);
                if (colWriterIndex > -1) {
                    this.columnIndexByNameUtf8.put(onHeapColNameUtf8, colWriterIndex);
                    this.processedCols.extendAndReplace(colWriterIndex, true);
                    return colWriterIndex;
                }
                this.colNameUtf16 = colNameUtf16.toString();
                this.colNameUtf8 = onHeapColNameUtf8;
                this.addedColsUtf16.addAt(index, this.colNameUtf16);
                return -1;
            }
            return -2;
        }

        private int getColumnWriterIndex(CharSequence colNameUtf16) {
            assert (this.latestKnownMetadata != null);
            int colIndex = this.latestKnownMetadata.getColumnIndexQuiet(colNameUtf16);
            if (colIndex < 0) {
                return colIndex;
            }
            int writerColIndex = this.latestKnownMetadata.getWriterIndex(colIndex);
            this.updateColumnTypeCache(colIndex, writerColIndex, this.latestKnownMetadata);
            return writerColIndex;
        }

        private int resolveSymbolIndexAndName(TableRecordMetadata metadata, int colWriterIndex) {
            this.symbolNameTemp = null;
            int symIndex = -1;
            int n = metadata.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (metadata.getWriterIndex(i) == colWriterIndex) {
                    if (!ColumnType.isSymbol(metadata.getColumnType(i))) {
                        return -1;
                    }
                    ++symIndex;
                    this.symbolNameTemp = metadata.getColumnName(i);
                    break;
                }
                if (!ColumnType.isSymbol(metadata.getColumnType(i))) continue;
                ++symIndex;
            }
            return symIndex;
        }

        private void updateColumnTypeCache(int colIndex, int writerColIndex, TableRecordMetadata metadata) {
            this.columnCount = metadata.getColumnCount();
            int colType = metadata.getColumnType(colIndex);
            int geoHashBits = ColumnType.getGeoHashBits(colType);
            this.columnTypes.extendAndSet(writerColIndex, colType);
            this.columnTypeMeta.extendAndSet(writerColIndex + 1, geoHashBits == 0 ? 0 : Numbers.encodeLowHighShorts((short)geoHashBits, ColumnType.tagOf(colType)));
        }

        void addColumnType(int colIndex, int colType) {
            this.columnTypes.add(Numbers.encodeLowHighShorts((short)colType, (short)colIndex));
        }

        void clear() {
            this.columnIndexByNameUtf8.clear();
            this.columnTypeByNameUtf8.clear();
            int sz = this.symbolCacheByColumnIndex.size();
            for (int n = 0; n < sz; ++n) {
                SymbolCache symCache = this.symbolCacheByColumnIndex.getQuick(n);
                if (null == symCache) continue;
                symCache.close();
                this.unusedSymbolCaches.add(symCache);
            }
            this.symbolCacheByColumnIndex.clear();
            this.columnTypes.clear();
            this.columnTypeMeta.clear();
            this.columnTypeMeta.add(0);
            if (this.txReader != null) {
                this.txReader.clear();
            }
            this.clean = true;
            this.latestKnownMetadata = Misc.free(this.latestKnownMetadata);
        }

        void clearColumnTypes() {
            this.columnTypes.clear();
        }

        String getColNameUtf16() {
            assert (this.colNameUtf16 != null);
            return this.colNameUtf16;
        }

        ByteCharSequence getColNameUtf8() {
            assert (this.colNameUtf8 != null);
            return this.colNameUtf8;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        int getColumnIndex(DirectByteCharSequence colNameUtf8, boolean hasNonAsciiChars) {
            int colWriterIndex = this.columnIndexByNameUtf8.get(colNameUtf8);
            if (colWriterIndex < 0) {
                CharSequence colNameUtf16 = Chars.utf8ToUtf16(colNameUtf8, this.tempSink, hasNonAsciiChars);
                int index = this.addedColsUtf16.keyIndex(colNameUtf16);
                if (index <= -1) return -2;
                colWriterIndex = this.getColumnWriterIndex(colNameUtf16);
                ByteCharSequence onHeapColNameUtf8 = ByteCharSequence.newInstance(colNameUtf8);
                if (colWriterIndex > -1) {
                    this.columnIndexByNameUtf8.put(onHeapColNameUtf8, colWriterIndex);
                } else {
                    this.colNameUtf16 = colNameUtf16.toString();
                    this.colNameUtf8 = onHeapColNameUtf8;
                    this.addedColsUtf16.addAt(index, this.colNameUtf16);
                    return -1;
                }
            }
            if (!this.processedCols.extendAndReplace(colWriterIndex, true)) return colWriterIndex;
            return -2;
        }

        int getColumnIndex(DirectByteCharSequence colNameUtf8, boolean hasNonAsciiChars, @NotNull TableRecordMetadata metadata) {
            int colWriterIndex = this.columnIndexByNameUtf8.get(colNameUtf8);
            if (colWriterIndex < 0) {
                return this.getColumnIndex0(colNameUtf8, hasNonAsciiChars, metadata);
            }
            if (this.processedCols.extendAndReplace(colWriterIndex, true)) {
                return -2;
            }
            return colWriterIndex;
        }

        int getColumnType(int colIndex) {
            return this.columnTypes.getQuick(colIndex);
        }

        int getColumnType(ByteCharSequence colName, byte entityType) {
            int colType = this.columnTypeByNameUtf8.get(colName);
            if (colType < 0) {
                colType = ((TableUpdateDetails)TableUpdateDetails.this).defaultColumnTypes.DEFAULT_COLUMN_TYPES[entityType];
                this.columnTypeByNameUtf8.put(colName, colType);
            }
            return colType;
        }

        int getColumnTypeMeta(int colIndex) {
            return this.columnTypeMeta.getQuick(colIndex + 1);
        }

        long getStructureVersion() {
            if (this.latestKnownMetadata != null) {
                return this.latestKnownMetadata.getStructureVersion();
            }
            return -1L;
        }

        DirectByteSymbolLookup getSymbolLookup(int columnIndex) {
            if (columnIndex > -1) {
                SymbolCache symCache = this.symbolCacheByColumnIndex.getQuiet(columnIndex);
                if (symCache != null) {
                    return symCache;
                }
                return this.addSymbolCache(columnIndex);
            }
            return NOT_FOUND_LOOKUP;
        }

        void resetStateIfNecessary() {
            this.processedCols.setAll(this.columnCount, false);
            this.addedColsUtf16.clear();
            if (this.latestKnownMetadata != null) {
                long structureVersion = TableUpdateDetails.this.writerAPI.getStructureVersion();
                if (this.latestKnownMetadata.getStructureVersion() != structureVersion) {
                    this.clear();
                }
            }
            if (this.latestKnownMetadata == null) {
                this.latestKnownMetadata = TableUpdateDetails.this.engine.getMetadata(AllowAllCairoSecurityContext.INSTANCE, TableUpdateDetails.this.tableToken);
            }
        }
    }
}

