/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.DynamicTableReaderMetadata;
import io.questdb.cairo.GenericTableRecordMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.pool.AbstractMultiTenantPool;
import io.questdb.cairo.pool.PoolTenant;
import io.questdb.cairo.sql.TableRecordMetadata;
import io.questdb.cairo.wal.seq.TableSequencerAPI;

public class MetadataPool
extends AbstractMultiTenantPool<MetadataTenant> {
    private final CairoEngine engine;

    public MetadataPool(CairoConfiguration configuration, CairoEngine engine) {
        super(configuration);
        this.engine = engine;
    }

    @Override
    protected byte getListenerSrc() {
        return 3;
    }

    @Override
    protected MetadataTenant newTenant(TableToken tableToken, AbstractMultiTenantPool.Entry<MetadataTenant> entry, int index) {
        if (this.engine.isWalTable(tableToken)) {
            return new SequencerMetadataTenant(this, entry, index, tableToken, this.engine.getTableSequencerAPI());
        }
        return new TableReaderMetadataTenant(this, entry, index, tableToken);
    }

    private static class TableReaderMetadataTenant
    extends DynamicTableReaderMetadata
    implements MetadataTenant {
        private final int index;
        private AbstractMultiTenantPool.Entry<MetadataTenant> entry;
        private AbstractMultiTenantPool<MetadataTenant> pool;

        public TableReaderMetadataTenant(AbstractMultiTenantPool<MetadataTenant> pool, AbstractMultiTenantPool.Entry<MetadataTenant> entry, int index, TableToken tableToken) {
            super(pool.getConfiguration(), tableToken);
            this.pool = pool;
            this.entry = entry;
            this.index = index;
        }

        @Override
        public void close() {
            if (this.pool != null && this.getEntry() != null && this.pool.returnToPool(this)) {
                return;
            }
            super.close();
        }

        public AbstractMultiTenantPool.Entry<MetadataTenant> getEntry() {
            return this.entry;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void goodbye() {
            this.entry = null;
            this.pool = null;
        }

        @Override
        public void refresh() {
            this.reload();
        }
    }

    private static class SequencerMetadataTenant
    extends GenericTableRecordMetadata
    implements MetadataTenant {
        private final int index;
        private final TableSequencerAPI tableSequencerAPI;
        private final TableToken tableToken;
        private AbstractMultiTenantPool.Entry<MetadataTenant> entry;
        private AbstractMultiTenantPool<MetadataTenant> pool;

        public SequencerMetadataTenant(AbstractMultiTenantPool<MetadataTenant> pool, AbstractMultiTenantPool.Entry<MetadataTenant> entry, int index, TableToken tableToken, TableSequencerAPI tableSequencerAPI) {
            this.pool = pool;
            this.entry = entry;
            this.index = index;
            this.tableSequencerAPI = tableSequencerAPI;
            this.tableToken = tableToken;
            tableSequencerAPI.getTableMetadata(tableToken, this);
        }

        @Override
        public void close() {
            if (this.pool != null && this.getEntry() != null && this.pool.returnToPool(this)) {
                return;
            }
            super.close();
        }

        public AbstractMultiTenantPool.Entry<MetadataTenant> getEntry() {
            return this.entry;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public void goodbye() {
            this.entry = null;
            this.pool = null;
        }

        @Override
        public void refresh() {
            this.tableSequencerAPI.reloadMetadataConditionally(this.tableToken, this.getStructureVersion(), this);
        }
    }

    public static interface MetadataTenant
    extends TableRecordMetadata,
    PoolTenant {
    }
}

