/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnVersionReader;
import io.questdb.cairo.RebuildColumnBase;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.vm.MemoryCMARWImpl;
import io.questdb.cairo.vm.MemoryCMRImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;

public class RecoverVarIndex
extends RebuildColumnBase {
    private static final Log LOG = LogFactory.getLog(RecoverVarIndex.class);

    @Override
    protected void doReindex(ColumnVersionReader columnVersionReader, int columnWriterIndex, CharSequence columnName, CharSequence partitionName, long partitionNameTxn, long partitionSize, long partitionTimestamp, int indexValueBlockCapacity) {
        long columnNameTxn = columnVersionReader.getColumnNameTxn(partitionTimestamp, columnWriterIndex);
        long columnTop = columnVersionReader.getColumnTop(partitionTimestamp, columnWriterIndex);
        if (columnTop == -1L) {
            LOG.info().$("not rebuilding column ").$(columnName).$(" in partition ").$ts(partitionTimestamp).$(", column not added to partition").$();
            return;
        }
        this.path.trimTo(this.rootLen).concat(partitionName);
        TableUtils.txnPartitionConditionally(this.path, partitionNameTxn);
        this.path.concat(columnName);
        int colNameLen = this.path.length();
        this.path.put(".d");
        if (columnNameTxn != -1L) {
            this.path.put('.').put(columnNameTxn);
        }
        LOG.info().$("reading: ").$(this.path).$();
        long maxOffset = this.ff.length(this.path.$());
        try (MemoryCMRImpl roMem = new MemoryCMRImpl(this.ff, this.path.$(), maxOffset, 0);){
            this.path.trimTo(colNameLen).put(".i");
            if (columnNameTxn != -1L) {
                this.path.put('.').put(columnNameTxn);
            }
            LOG.info().$("writing: ").$(this.path).$();
            try (MemoryCMARWImpl rwMem = new MemoryCMARWImpl(this.ff, this.path.$(), 0x800000L, 0L, 0, 0L);){
                long expectedRowCount = partitionSize - columnTop;
                LOG.info().$("data file length: ").$(maxOffset).$(", expected record count: ").$(expectedRowCount).$();
                long offset = 0L;
                int rows = 0;
                while ((long)rows < expectedRowCount && offset + 3L < maxOffset) {
                    int len = roMem.getInt(offset);
                    rwMem.putLong(offset);
                    offset = len > -1 ? (offset += 4L + (long)len * 2L) : (offset += 4L);
                    ++rows;
                }
                if ((long)rows != expectedRowCount) {
                    throw CairoException.critical(0).put(" rebuild var index file failed [path=").put(this.path).put(", expectedRows=").put(expectedRowCount).put(", actualRows=").put(rows).put(']');
                }
                rwMem.putLong(offset);
                LOG.info().$("write complete. Index file length: ").$(rwMem.getAppendOffset()).$();
            }
        }
    }

    @Override
    protected boolean isSupportedColumn(RecordMetadata metadata, int columnIndex) {
        return metadata.getColumnType(columnIndex) == 11;
    }
}

