/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.dto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.minifi.commons.schema.common.CollectionUtil;
import org.apache.nifi.minifi.commons.schema.common.StringUtil;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;

public class FlowSnippetDTOEnricher {
    public void enrich(FlowSnippetDTO flowSnippetDTO, String encodingVersion) {
        List<FlowSnippetDTO> allFlowSnippets = FlowSnippetDTOEnricher.getAllFlowSnippets(flowSnippetDTO);
        Set remoteProcessGroups = FlowSnippetDTOEnricher.getAll(allFlowSnippets, FlowSnippetDTO::getRemoteProcessGroups).collect(Collectors.toSet());
        Map<String, String> connectableNameMap = FlowSnippetDTOEnricher.getAll(allFlowSnippets, FlowSnippetDTO::getProcessors).collect(Collectors.toMap(ComponentDTO::getId, ProcessorDTO::getName));
        HashMap<String, String> rpgIdToTargetIdMap = new HashMap<String, String>();
        for (RemoteProcessGroupDTO remoteProcessGroupDTO : remoteProcessGroups) {
            RemoteProcessGroupContentsDTO contents = remoteProcessGroupDTO.getContents();
            Set rpgInputPortDtos = CollectionUtil.nullToEmpty((Set)contents.getInputPorts());
            Set rpgOutputPortDtos = CollectionUtil.nullToEmpty((Set)contents.getOutputPorts());
            if (encodingVersion != null) {
                switch (encodingVersion) {
                    case "1.0": 
                    case "1.1": {
                        break;
                    }
                    default: {
                        rpgIdToTargetIdMap.putAll(Stream.concat(rpgInputPortDtos.stream(), rpgOutputPortDtos.stream()).collect(Collectors.toMap(RemoteProcessGroupPortDTO::getId, RemoteProcessGroupPortDTO::getTargetId)));
                    }
                }
            }
            FlowSnippetDTOEnricher.addConnectables(connectableNameMap, rpgInputPortDtos, RemoteProcessGroupPortDTO::getId, RemoteProcessGroupPortDTO::getId);
            FlowSnippetDTOEnricher.addConnectables(connectableNameMap, rpgOutputPortDtos, RemoteProcessGroupPortDTO::getId, RemoteProcessGroupPortDTO::getId);
        }
        FlowSnippetDTOEnricher.addConnectables(connectableNameMap, FlowSnippetDTOEnricher.getAll(allFlowSnippets, FlowSnippetDTO::getInputPorts).collect(Collectors.toList()), ComponentDTO::getId, PortDTO::getName);
        FlowSnippetDTOEnricher.addConnectables(connectableNameMap, FlowSnippetDTOEnricher.getAll(allFlowSnippets, FlowSnippetDTO::getOutputPorts).collect(Collectors.toList()), ComponentDTO::getId, PortDTO::getName);
        Set connections = FlowSnippetDTOEnricher.getAll(allFlowSnippets, FlowSnippetDTO::getConnections).collect(Collectors.toSet());
        for (ConnectionDTO connection : connections) {
            FlowSnippetDTOEnricher.setName(connectableNameMap, connection.getSource(), rpgIdToTargetIdMap);
            FlowSnippetDTOEnricher.setName(connectableNameMap, connection.getDestination(), rpgIdToTargetIdMap);
        }
        connections.stream().flatMap(connectionDTO -> Stream.of(connectionDTO.getSource(), connectionDTO.getDestination())).filter(connectable -> connectable.getType().equals(ConnectableType.REMOTE_OUTPUT_PORT.toString()) || connectable.getType().equals(ConnectableType.REMOTE_INPUT_PORT.toString())).forEach(connectable -> connectable.setId(Optional.ofNullable(rpgIdToTargetIdMap.get(connectable.getId())).orElse(connectable.getId())));
        for (ConnectionDTO connection : connections) {
            if (!StringUtil.isNullOrEmpty((String)connection.getName())) continue;
            StringBuilder name = new StringBuilder();
            ConnectableDTO connectionSource = connection.getSource();
            name.append(FlowSnippetDTOEnricher.determineValueForConnectable(connectionSource, rpgIdToTargetIdMap));
            name.append("/");
            if (connection.getSelectedRelationships() != null && connection.getSelectedRelationships().size() > 0) {
                name.append((String)connection.getSelectedRelationships().iterator().next());
            }
            name.append("/");
            ConnectableDTO connectionDestination = connection.getDestination();
            name.append(FlowSnippetDTOEnricher.determineValueForConnectable(connectionDestination, rpgIdToTargetIdMap));
            connection.setName(name.toString());
        }
        CollectionUtil.nullToEmpty((Set)flowSnippetDTO.getProcessGroups()).stream().map(ProcessGroupDTO::getContents).forEach(snippetDTO -> this.enrich((FlowSnippetDTO)snippetDTO, encodingVersion));
    }

    private static String determineValueForConnectable(ConnectableDTO connectable, Map<String, String> idOverrideMap) {
        String connectionName = "";
        if (connectable != null && StringUtils.isBlank((CharSequence)(connectionName = connectable.getName()))) {
            connectionName = idOverrideMap.containsKey(connectable.getId()) ? idOverrideMap.get(connectable.getId()) : connectable.getId();
        }
        return connectionName;
    }

    private static <T> Stream<T> getAll(List<FlowSnippetDTO> allFlowSnippets, Function<FlowSnippetDTO, Collection<T>> accessor) {
        return allFlowSnippets.stream().flatMap(f -> ((Collection)accessor.apply((FlowSnippetDTO)f)).stream()).filter(Objects::nonNull);
    }

    private static List<FlowSnippetDTO> getAllFlowSnippets(FlowSnippetDTO flowSnippetDTO) {
        ArrayList<FlowSnippetDTO> result = new ArrayList<FlowSnippetDTO>();
        FlowSnippetDTOEnricher.getAllFlowSnippets(flowSnippetDTO, result);
        return result;
    }

    private static void getAllFlowSnippets(FlowSnippetDTO flowSnippetDTO, List<FlowSnippetDTO> result) {
        result.add(flowSnippetDTO);
        CollectionUtil.nullToEmpty((Set)flowSnippetDTO.getProcessGroups()).stream().map(ProcessGroupDTO::getContents).forEach(f -> FlowSnippetDTOEnricher.getAllFlowSnippets(f, result));
    }

    private static void setName(Map<String, String> connectableNameMap, ConnectableDTO connectableDTO, Map<String, String> nameOverrides) {
        String name;
        if (connectableDTO != null && (name = connectableNameMap.get(connectableDTO.getId())) != null) {
            connectableDTO.setName(Optional.ofNullable(nameOverrides.get(connectableDTO.getId())).orElse(name));
        }
    }

    private static <T> void addConnectables(Map<String, String> connectableNameMap, Collection<T> hasIdAndNames, Function<T, String> idGetter, Function<T, String> nameGetter) {
        if (hasIdAndNames != null) {
            for (T hasIdAndName : hasIdAndNames) {
                String id = idGetter.apply(hasIdAndName);
                String name = nameGetter.apply(hasIdAndName);
                if (StringUtil.isNullOrEmpty((String)name)) continue;
                connectableNameMap.put(id, name);
            }
        }
    }
}

