/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import org.jetbrains.annotations.Nullable;

public class LPadStrFunctionFactory
implements FunctionFactory {
    private static final String SIGNATURE = "lpad(SIS)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function strFunc = args.getQuick(0);
        Function lenFunc = args.getQuick(1);
        Function fillTextFunc = args.getQuick(2);
        int maxLength = configuration.getStrFunctionMaxBufferLength();
        return new LPadStrFunc(strFunc, lenFunc, fillTextFunc, maxLength);
    }

    public static class LPadStrFunc
    extends StrFunction
    implements TernaryFunction {
        private final Function fillTextFunc;
        private final Function lenFunc;
        private final int maxLength;
        private final StringSink sink = new StringSink();
        private final StringSink sinkB = new StringSink();
        private final Function strFunc;

        public LPadStrFunc(Function strFunc, Function lenFunc, Function fillTexFunc, int maxLength) {
            this.strFunc = strFunc;
            this.lenFunc = lenFunc;
            this.fillTextFunc = fillTexFunc;
            this.maxLength = maxLength;
        }

        @Override
        public Function getCenter() {
            return this.lenFunc;
        }

        @Override
        public Function getLeft() {
            return this.strFunc;
        }

        @Override
        public String getName() {
            return "lpad";
        }

        @Override
        public Function getRight() {
            return this.fillTextFunc;
        }

        @Override
        public CharSequence getStr(Record rec) {
            return this.lPadStr(this.strFunc.getStr(rec), this.lenFunc.getInt(rec), this.fillTextFunc.getStr(rec), this.sink);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.lPadStr(this.strFunc.getStr(rec), this.lenFunc.getInt(rec), this.fillTextFunc.getStr(rec), this.sinkB);
        }

        @Override
        public int getStrLen(Record rec) {
            CharSequence str = this.strFunc.getStr(rec);
            int len = this.lenFunc.getInt(rec);
            CharSequence fillText = this.fillTextFunc.getStr(rec);
            if (str != null && len >= 0 && fillText != null && fillText.length() > 0) {
                return len;
            }
            return -1;
        }

        @Nullable
        private StringSink lPadStr(CharSequence str, int len, CharSequence fillText, StringSink sink) {
            if (str != null && len >= 0 && fillText != null && fillText.length() > 0) {
                if (len > this.maxLength) {
                    throw CairoException.nonCritical().put("breached memory limit set for ").put(LPadStrFunctionFactory.SIGNATURE).put(" [maxLength=").put(this.maxLength).put(", requiredLength=").put(len).put(']');
                }
                sink.clear();
                if (len > str.length()) {
                    int i;
                    int fillTextLen = fillText.length();
                    int n = (len - str.length()) / fillTextLen;
                    for (i = 0; i < n; ++i) {
                        sink.put(fillText);
                    }
                    n = (len - str.length()) % fillTextLen;
                    for (i = 0; i < n; ++i) {
                        sink.put(fillText.charAt(i));
                    }
                    sink.put(str);
                } else {
                    sink.put(str, 0, len);
                }
                return sink;
            }
            return null;
        }
    }
}

