/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.GeoHashes;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.BasePlanSink;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Sinkable;
import io.questdb.std.Uuid;

public class JsonPlanSink
extends BasePlanSink {
    final int NODE_ATTR = 2;
    final int NODE_CHILD = 4;
    final int NODE_META = 3;
    final int NODE_NONE = 0;
    final int NODE_TYPE = 1;
    final int NODE_VALUE = 5;
    String childIndent = "    ";
    int lastNodeDepth = 0;
    int lastNodeType = 0;
    boolean quoteValue = false;
    int valueStartPos = 0;

    @Override
    public PlanSink attr(CharSequence name) {
        this.checkType(2);
        this.sink.put(name);
        return this;
    }

    @Override
    public PlanSink child(CharSequence outer, Plannable inner) {
        this.checkType(4);
        ++this.depth;
        this.lastNodeType = 0;
        this.type(outer);
        this.child(inner);
        --this.depth;
        return this;
    }

    @Override
    public PlanSink child(Plannable p) {
        this.checkType(4);
        ++this.depth;
        this.lastNodeType = 0;
        if (p instanceof RecordCursorFactory) {
            this.factoryStack.push((RecordCursorFactory)p);
            p.toPlan(this);
            this.factoryStack.pop();
        } else {
            p.toPlan(this);
        }
        this.closeChild();
        this.lastNodeType = 4;
        this.lastNodeDepth = --this.depth;
        return this;
    }

    @Override
    public void clear() {
        super.clear();
        this.lastNodeDepth = 0;
        this.lastNodeType = 0;
        this.quoteValue = false;
        this.valueStartPos = 0;
    }

    @Override
    public void end() {
        switch (this.lastNodeType) {
            case 1: 
            case 5: {
                this.sink.putNoEsc("\",\n");
                break;
            }
            case 2: 
            case 3: {
                this.sink.putNoEsc("\": ");
                break;
            }
            case 4: {
                this.indent();
                this.sink.putNoEsc("} ]\n");
            }
        }
        this.depth = this.lastNodeDepth;
        while (this.depth-- > 2) {
            this.indent();
            this.sink.putNoEsc("} ]\n");
        }
        this.sink.putNoEsc("    }\n  }\n]");
    }

    @Override
    public CharSequence getLine(int idx) {
        return this.sink;
    }

    @Override
    public int getLineCount() {
        return 1;
    }

    @Override
    public PlanSink meta(CharSequence name) {
        this.checkType(3);
        this.sink.put(name);
        return this;
    }

    @Override
    public void of(RecordCursorFactory factory, SqlExecutionContext executionContext) {
        this.clear();
        this.start();
        this.executionContext = executionContext;
        if (factory != null) {
            this.factoryStack.push(factory);
            factory.toPlan(this);
        }
        this.end();
    }

    @Override
    public PlanSink type(CharSequence type) {
        this.checkType(1);
        this.sink.put("Node Type\": \"");
        this.sink.put(type);
        return this;
    }

    @Override
    public PlanSink val(ObjList<?> list, int from, int to) {
        this.checkType(5);
        return super.val(list, from, to);
    }

    @Override
    public PlanSink val(char c) {
        this.quoteValue = true;
        this.checkType(5);
        this.sink.put(c);
        return this;
    }

    @Override
    public PlanSink val(int i) {
        this.checkType(5);
        this.sink.put(i);
        return this;
    }

    @Override
    public PlanSink val(long l) {
        this.checkType(5);
        this.sink.put(l);
        return this;
    }

    @Override
    public PlanSink val(float f) {
        this.checkType(5);
        this.sink.put(f);
        return this;
    }

    @Override
    public PlanSink val(double d) {
        this.checkType(5);
        this.sink.put(d);
        return this;
    }

    @Override
    public PlanSink val(boolean b) {
        this.checkType(5);
        this.sink.put(b);
        return this;
    }

    @Override
    public PlanSink val(CharSequence cs) {
        this.quoteValue = true;
        this.checkType(5);
        this.sink.put(cs);
        return this;
    }

    @Override
    public PlanSink val(Sinkable s) {
        this.quoteValue = true;
        this.checkType(5);
        this.sink.put(s);
        return this;
    }

    @Override
    public PlanSink val(Plannable s) {
        this.quoteValue = true;
        this.checkType(5);
        if (s != null) {
            s.toPlan(this);
        } else {
            this.sink.put("null");
        }
        return this;
    }

    @Override
    public PlanSink val(long long0, long long1, long long2, long long3) {
        this.quoteValue = true;
        this.checkType(5);
        Numbers.appendLong256(long0, long1, long2, long3, this.sink);
        return this;
    }

    @Override
    public PlanSink val(long hash, int geoHashBits) {
        this.quoteValue = true;
        this.checkType(5);
        GeoHashes.append(hash, geoHashBits, this.sink);
        return this;
    }

    @Override
    public PlanSink valUuid(long lo, long hi) {
        this.quoteValue = true;
        this.checkType(5);
        if (Uuid.isNull(lo, hi)) {
            this.sink.put("null");
        } else {
            Numbers.appendUuid(lo, hi, this.sink);
        }
        return this;
    }

    private void checkType(int newNodeType) {
        if (this.lastNodeType == 0) {
            this.indent();
            this.sink.put('\"');
            this.lastNodeType = newNodeType;
            return;
        }
        if (newNodeType == this.lastNodeType && newNodeType != 4) {
            return;
        }
        switch (this.lastNodeType) {
            case 1: {
                this.sink.putNoEsc("\",\n");
                this.indent();
                break;
            }
            case 2: 
            case 3: {
                this.sink.put("\": ");
                break;
            }
            case 5: {
                if (this.quoteValue) {
                    this.sink.put('\"');
                    this.sink.setCharAt(this.valueStartPos, '\"');
                }
                this.sink.putNoEsc(",\n");
                this.indent();
                break;
            }
            case 4: {
                this.indent();
                if (newNodeType == 4) {
                    this.sink.putNoEsc("},\n");
                    break;
                }
                this.sink.putNoEsc("} ]\n");
            }
        }
        if (newNodeType == 4) {
            if (this.lastNodeType != 4) {
                this.sink.putNoEsc("\"Plans\": [\n");
                this.indent();
                this.sink.putNoEsc("{\n");
            } else {
                this.indent();
                this.sink.putNoEsc("{\n");
            }
        } else {
            int c = 34;
            if (newNodeType == 5) {
                this.valueStartPos = this.sink.length();
                if (!this.quoteValue) {
                    c = 32;
                }
            }
            this.sink.put((char)c);
        }
        this.lastNodeType = newNodeType;
        this.lastNodeDepth = this.depth;
    }

    private void closeChild() {
        switch (this.lastNodeType) {
            case 4: {
                this.indent();
                this.sink.putNoEsc("} ]\n");
                break;
            }
            case 5: {
                if (this.quoteValue) {
                    this.sink.setCharAt(this.valueStartPos, '\"');
                    this.sink.putNoEsc("\"\n");
                    break;
                }
                this.sink.putNoEsc("\n");
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.sink.putNoEsc("\"\n");
            }
        }
    }

    private void indent() {
        for (int i = 0; i < this.depth; ++i) {
            this.sink.put(this.childIndent);
        }
    }

    private void start() {
        this.depth = 2;
        this.sink.putNoEsc("[\n  {\n    \"Plan\": {\n");
    }
}

