/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.schema;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.Repetition;

public class ComplexRecordField
implements RecordField {
    private static final FieldType fieldType = FieldType.COMPLEX;
    private final String fieldName;
    private final Repetition repetition;
    private final List<RecordField> subFields;

    public ComplexRecordField(String fieldName, Repetition repetition, RecordField ... subFields) {
        this(fieldName, repetition, Stream.of(subFields).collect(Collectors.toList()));
    }

    public ComplexRecordField(String fieldName, Repetition repetition, List<RecordField> subFields) {
        Objects.requireNonNull(fieldName);
        Objects.requireNonNull(repetition);
        Objects.requireNonNull(subFields);
        if (subFields.isEmpty()) {
            throw new IllegalArgumentException("Cannot have a RecordField of type " + fieldType.name() + " without any sub-fields");
        }
        this.fieldName = fieldName;
        this.repetition = repetition;
        this.subFields = subFields;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public FieldType getFieldType() {
        return fieldType;
    }

    @Override
    public Repetition getRepetition() {
        return this.repetition;
    }

    @Override
    public List<RecordField> getSubFields() {
        return this.subFields;
    }

    public String toString() {
        return "ComplexRecordField[" + this.fieldName + "]";
    }

    public int hashCode() {
        return 81 + this.fieldName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordField)) {
            return false;
        }
        RecordField other = (RecordField)obj;
        return this.fieldName.equals(other.getFieldName());
    }
}

