/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AuxiliaryConfigImpl
implements AuxiliaryConfiguration {
    private static final Logger LOG = Logger.getLogger(AuxiliaryConfigImpl.class.getName());
    static final String AUX_CONFIG_ATTR_BASE = AuxiliaryConfiguration.class.getName();
    static final String AUX_CONFIG_FILENAME = ".netbeans.xml";
    private final Project project;

    public AuxiliaryConfigImpl(Project proj) {
        this.project = proj;
    }

    @Override
    public Element getConfigurationFragment(final String elementName, final String namespace, final boolean shared) {
        assert (this.project != null);
        return ProjectManager.mutex(false, this.project, new Project[0]).readAccess(new Mutex.Action<Element>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Element run() {
                block16: {
                    Element fragment;
                    Lookup lookup = AuxiliaryConfigImpl.this.project.getLookup();
                    assert (lookup != null) : AuxiliaryConfigImpl.access$000(AuxiliaryConfigImpl.this).getClass().getName() + " violates #185464";
                    AuxiliaryConfiguration delegate = lookup.lookup(AuxiliaryConfiguration.class);
                    if (delegate != null && (fragment = delegate.getConfigurationFragment(elementName, namespace, shared)) != null) {
                        if (elementName.equals(fragment.getLocalName()) && namespace.equals(fragment.getNamespaceURI())) {
                            return fragment;
                        }
                        LOG.log(Level.INFO, delegate.getClass().getName() + " produced wrong local name or namespace for " + namespace + "#" + elementName + " in " + AuxiliaryConfigImpl.this.project);
                    }
                    FileObject dir = AuxiliaryConfigImpl.this.project.getProjectDirectory();
                    if (shared) {
                        FileObject config = dir.getFileObject(AuxiliaryConfigImpl.AUX_CONFIG_FILENAME);
                        if (config != null) {
                            Element element;
                            InputStream is = config.getInputStream();
                            try {
                                InputSource input = new InputSource(is);
                                input.setSystemId(config.toURL().toString());
                                Element root = XMLUtil.parse(input, false, true, null, null).getDocumentElement();
                                element = XMLUtil.findElement(root, elementName, namespace);
                            }
                            catch (Throwable throwable) {
                                try {
                                    is.close();
                                    throw throwable;
                                }
                                catch (Exception x) {
                                    LOG.log(Level.INFO, "Cannot parse" + config, x);
                                }
                            }
                            is.close();
                            return element;
                        }
                    } else {
                        String attrName = AUX_CONFIG_ATTR_BASE + "." + namespace + "#" + elementName;
                        Object attr = dir.getAttribute(attrName);
                        if (attr instanceof String) {
                            try {
                                Element fragment2 = XMLUtil.parse(new InputSource(new StringReader((String)attr)), false, true, null, null).getDocumentElement();
                                if (elementName.equals(fragment2.getLocalName()) && namespace.equals(fragment2.getNamespaceURI())) {
                                    return fragment2;
                                }
                                LOG.log(Level.INFO, "Value " + attr + " of " + attrName + " on " + dir + " has the wrong local name or namespace");
                            }
                            catch (SAXException x) {
                                LOG.log(Level.INFO, "Cannot parse value " + attr + " of " + attrName + " on " + dir + ": " + x.getMessage());
                            }
                            catch (IOException x) {
                                if ($assertionsDisabled) break block16;
                                throw new AssertionError((Object)x);
                            }
                        }
                    }
                }
                return null;
            }
        });
    }

    @Override
    public void putConfigurationFragment(final Element fragment, final boolean shared) throws IllegalArgumentException {
        ProjectManager.mutex(false, this.project, new Project[0]).writeAccess(new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() {
                block16: {
                    String elementName = fragment.getLocalName();
                    String namespace = fragment.getNamespaceURI();
                    if (namespace == null) {
                        throw new IllegalArgumentException();
                    }
                    AuxiliaryConfiguration delegate = AuxiliaryConfigImpl.this.project.getLookup().lookup(AuxiliaryConfiguration.class);
                    if (delegate != null) {
                        delegate.putConfigurationFragment(fragment, shared);
                        AuxiliaryConfigImpl.this.removeFallbackImpl(elementName, namespace, shared);
                        return null;
                    }
                    FileObject dir = AuxiliaryConfigImpl.this.project.getProjectDirectory();
                    try {
                        if (shared) {
                            Element root;
                            Element oldFragment;
                            Document doc;
                            FileObject config = dir.getFileObject(AuxiliaryConfigImpl.AUX_CONFIG_FILENAME);
                            if (config != null) {
                                try (InputStream is = config.getInputStream();){
                                    InputSource input = new InputSource(is);
                                    input.setSystemId(config.toURL().toString());
                                    doc = XMLUtil.parse(input, false, true, null, null);
                                }
                            } else {
                                config = dir.createData(AuxiliaryConfigImpl.AUX_CONFIG_FILENAME);
                                doc = XMLUtil.createDocument("auxiliary-configuration", "http://www.netbeans.org/ns/auxiliary-configuration/1", null, null);
                            }
                            if ((oldFragment = XMLUtil.findElement(root = doc.getDocumentElement(), elementName, namespace)) != null) {
                                root.removeChild(oldFragment);
                            }
                            Node ref = null;
                            NodeList list = root.getChildNodes();
                            for (int i = 0; i < list.getLength(); ++i) {
                                Node node = list.item(i);
                                if (node.getNodeType() != 1) continue;
                                int comparison = node.getNodeName().compareTo(elementName);
                                if (comparison == 0) {
                                    comparison = node.getNamespaceURI().compareTo(namespace);
                                }
                                if (comparison <= 0) continue;
                                ref = node;
                                break;
                            }
                            root.insertBefore(root.getOwnerDocument().importNode(fragment, true), ref);
                            try (OutputStream os = config.getOutputStream();){
                                XMLUtil.write(doc, os, "UTF-8");
                                break block16;
                            }
                        }
                        String attrName = AUX_CONFIG_ATTR_BASE + "." + namespace + "#" + elementName;
                        dir.setAttribute(attrName, AuxiliaryConfigImpl.elementToString(fragment));
                    }
                    catch (Exception x) {
                        LOG.log(Level.WARNING, "Cannot save configuration to " + dir, x);
                    }
                }
                return null;
            }
        });
    }

    static String elementToString(Element e) throws ParserConfigurationException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        DOMImplementationLS ls = (DOMImplementationLS)doc.getImplementation().getFeature("LS", "3.0");
        assert (ls != null) : "No DOM 3 LS supported in " + doc.getClass().getName();
        doc.appendChild(doc.importNode(e, true));
        LSSerializer serializer = ls.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        return serializer.writeToString(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFallbackImpl(String elementName, String namespace, boolean shared) {
        block15: {
            FileObject dir = this.project.getProjectDirectory();
            try {
                if (shared) {
                    FileObject config = dir.getFileObject(AUX_CONFIG_FILENAME);
                    if (config == null) break block15;
                    try {
                        Document doc;
                        try (InputStream is = config.getInputStream();){
                            InputSource input = new InputSource(is);
                            input.setSystemId(config.toURL().toString());
                            doc = XMLUtil.parse(input, false, true, null, null);
                        }
                        Element root = doc.getDocumentElement();
                        Element toRemove = XMLUtil.findElement(root, elementName, namespace);
                        if (toRemove != null) {
                            root.removeChild(toRemove);
                            if (root.getElementsByTagName("*").getLength() > 0) {
                                try (OutputStream os = config.getOutputStream();){
                                    XMLUtil.write(doc, os, "UTF-8");
                                }
                            } else {
                                config.delete();
                            }
                            return true;
                        }
                        break block15;
                    }
                    catch (SAXException x) {
                        LOG.log(Level.INFO, "Cannot parse" + config, x);
                    }
                    break block15;
                }
                String attrName = AUX_CONFIG_ATTR_BASE + "." + namespace + "#" + elementName;
                if (dir.getAttribute(attrName) != null) {
                    dir.setAttribute(attrName, null);
                    return true;
                }
            }
            catch (IOException x) {
                LOG.warning("Cannot remove configuration from " + dir);
            }
        }
        return false;
    }

    @Override
    public boolean removeConfigurationFragment(final String elementName, final String namespace, final boolean shared) throws IllegalArgumentException {
        return ProjectManager.mutex(false, this.project, new Project[0]).writeAccess(new Mutex.Action<Boolean>(){

            @Override
            public Boolean run() {
                AuxiliaryConfiguration delegate = AuxiliaryConfigImpl.this.project.getLookup().lookup(AuxiliaryConfiguration.class);
                boolean result = false;
                if (delegate != null) {
                    result |= delegate.removeConfigurationFragment(elementName, namespace, shared);
                }
                return result |= AuxiliaryConfigImpl.this.removeFallbackImpl(elementName, namespace, shared);
            }
        });
    }
}

