/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.common;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.parsing.lucene.support.Queries;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.util.Pair;

public class Utils {
    private static final int MAX_INPUT_LENGTH = 1024;
    private static final char[] INVALID_CHARS = new char[]{'\n'};

    private Utils() {
        throw new IllegalStateException();
    }

    public static int containsWildCard(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    public static boolean isAllUpper(String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public static SearchType getSearchType(@NonNull String text, boolean exact, boolean isCaseSensitive, @NullAllowed String camelCaseSeparator, @NullAllowed String camelCasePart) {
        int wildcard = Utils.containsWildCard(text);
        if (exact) {
            return SearchType.EXACT_NAME;
        }
        if (wildcard != -1) {
            return isCaseSensitive ? SearchType.REGEXP : SearchType.CASE_INSENSITIVE_REGEXP;
        }
        if (Utils.isAllUpper(text) && text.length() > 1 || Queries.isCamelCase(text, camelCaseSeparator, camelCasePart)) {
            return isCaseSensitive ? SearchType.CAMEL_CASE : SearchType.CASE_INSENSITIVE_CAMEL_CASE;
        }
        return isCaseSensitive ? SearchType.PREFIX : SearchType.CASE_INSENSITIVE_PREFIX;
    }

    @NonNull
    public static SearchType toSearchType(@NonNull QuerySupport.Kind searchType) {
        switch (searchType) {
            case CAMEL_CASE: {
                return SearchType.CAMEL_CASE;
            }
            case CASE_INSENSITIVE_CAMEL_CASE: {
                return SearchType.CASE_INSENSITIVE_CAMEL_CASE;
            }
            case CASE_INSENSITIVE_PREFIX: {
                return SearchType.CASE_INSENSITIVE_PREFIX;
            }
            case CASE_INSENSITIVE_REGEXP: {
                return SearchType.CASE_INSENSITIVE_REGEXP;
            }
            case EXACT: {
                return SearchType.EXACT_NAME;
            }
            case PREFIX: {
                return SearchType.PREFIX;
            }
            case REGEXP: {
                return SearchType.REGEXP;
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)searchType));
    }

    @NonNull
    public static QuerySupport.Kind toQueryKind(@NonNull SearchType searchType) {
        switch (searchType) {
            case CAMEL_CASE: {
                return QuerySupport.Kind.CAMEL_CASE;
            }
            case CASE_INSENSITIVE_CAMEL_CASE: {
                return QuerySupport.Kind.CASE_INSENSITIVE_CAMEL_CASE;
            }
            case CASE_INSENSITIVE_EXACT_NAME: 
            case EXACT_NAME: {
                return QuerySupport.Kind.EXACT;
            }
            case CASE_INSENSITIVE_PREFIX: {
                return QuerySupport.Kind.CASE_INSENSITIVE_PREFIX;
            }
            case CASE_INSENSITIVE_REGEXP: {
                return QuerySupport.Kind.CASE_INSENSITIVE_REGEXP;
            }
            case PREFIX: {
                return QuerySupport.Kind.PREFIX;
            }
            case REGEXP: {
                return QuerySupport.Kind.REGEXP;
            }
        }
        throw new IllegalThreadStateException(String.valueOf((Object)searchType));
    }

    @NonNull
    public static String removeNonNeededWildCards(@NonNull String text) {
        StringBuilder sb = new StringBuilder();
        boolean lastAny = false;
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '*': {
                    if (!lastAny) {
                        sb.append(c);
                    }
                    lastAny = true;
                    continue block4;
                }
                case '?': {
                    if (lastAny) continue block4;
                    sb.append(c);
                    continue block4;
                }
                default: {
                    sb.append(c);
                    lastAny = false;
                }
            }
        }
        return sb.toString();
    }

    public static boolean isValidInput(@NonNull String input) {
        if (input.length() > 1024) {
            return false;
        }
        for (char c : INVALID_CHARS) {
            if (input.indexOf(c) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isNarrowing(@NonNull SearchType origSearchType, @NonNull SearchType newSearchType, @NonNull String origText, @NonNull String newText) {
        boolean origCaseSensitive = Utils.isCaseSensitive(origSearchType);
        boolean newCaseSensitive = Utils.isCaseSensitive(newSearchType);
        if (origCaseSensitive && !newCaseSensitive) {
            return false;
        }
        if (!newCaseSensitive) {
            origText = origText.toLowerCase();
            newText = newText.toLowerCase();
        }
        return newText.startsWith(origText);
    }

    @NonNull
    public static Pair<String, String> splitNameAndScope(@NonNull String text) {
        String name;
        String scope;
        int index = text.lastIndexOf(46);
        if (index >= 0) {
            scope = index == 0 ? null : text.substring(0, index);
            name = text.substring(index + 1);
        } else {
            scope = null;
            name = text;
        }
        return Pair.of(name, scope);
    }

    public static boolean isCaseSensitive(@NonNull SearchType searchType) {
        switch (searchType) {
            case CAMEL_CASE: 
            case EXACT_NAME: 
            case PREFIX: 
            case REGEXP: {
                return true;
            }
            case CASE_INSENSITIVE_CAMEL_CASE: 
            case CASE_INSENSITIVE_EXACT_NAME: 
            case CASE_INSENSITIVE_PREFIX: 
            case CASE_INSENSITIVE_REGEXP: {
                return false;
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)searchType));
    }
}

