/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.Tree;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.tools.FileObject;
import jpt30.tools.JavaFileObject;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.indexing.JavaParsingContext;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.parsing.lucene.support.LowMemoryWatcher;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.Indexable;

public abstract class CompileWorker {
    protected abstract ParsingOutput compile(ParsingOutput var1, Context var2, JavaParsingContext var3, Collection<? extends JavaCustomIndexer.CompileTuple> var4);

    protected void computeFQNs(Map<JavaFileObject, List<String>> file2FQNs, CompilationUnitTree cut, JavaCustomIndexer.CompileTuple tuple) {
        String pack = cut.getPackageName() != null ? cut.getPackageName().toString() + "." : "";
        String path = tuple.indexable.getRelativePath();
        int i = path.lastIndexOf(46);
        if (i >= 0) {
            path = path.substring(0, i);
        }
        path = FileObjects.convertFolder2Package(path);
        LinkedList<String> fqns = new LinkedList<String>();
        boolean hasClassesLivingElsewhere = false;
        for (Tree tree : cut.getTypeDecls()) {
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) continue;
            String fqn = pack + ((ClassTree)tree).getSimpleName().toString();
            fqns.add(fqn);
            if (path.equals(fqn)) continue;
            hasClassesLivingElsewhere = true;
        }
        if (hasClassesLivingElsewhere) {
            file2FQNs.put(tuple.jfo, fqns);
        }
    }

    protected final boolean isLowMemory(boolean[] tryToFree) {
        LowMemoryWatcher lm = LowMemoryWatcher.getInstance();
        boolean ilm = lm.isLowMemory();
        if (ilm && tryToFree != null && tryToFree[0]) {
            lm.free();
            ilm = lm.isLowMemory();
            tryToFree[0] = false;
        }
        return ilm;
    }

    protected final void freeMemory(boolean freeCaches) {
        LowMemoryWatcher lm = LowMemoryWatcher.getInstance();
        lm.free(freeCaches);
    }

    public static class ParsingOutput {
        public final boolean success;
        public final boolean lowMemory;
        public final String moduleName;
        public final Map<JavaFileObject, List<String>> file2FQNs;
        public final Set<ElementHandle<TypeElement>> addedTypes;
        public final Set<ElementHandle<ModuleElement>> addedModules;
        public final Set<File> createdFiles;
        public final Set<Indexable> finishedFiles;
        public final Set<ElementHandle<TypeElement>> modifiedTypes;
        public final Set<FileObject> aptGenerated;

        private ParsingOutput(boolean success, boolean lowMemory, @NullAllowed String moduleName, Map<JavaFileObject, List<String>> file2FQNs, Set<ElementHandle<TypeElement>> addedTypes, Set<ElementHandle<ModuleElement>> addedModules, Set<File> createdFiles, Set<Indexable> finishedFiles, Set<ElementHandle<TypeElement>> modifiedTypes, Set<FileObject> aptGenerated) {
            assert (success && !lowMemory || !success);
            this.success = success;
            this.lowMemory = lowMemory;
            this.moduleName = moduleName;
            this.file2FQNs = file2FQNs;
            this.addedTypes = addedTypes;
            this.addedModules = addedModules;
            this.createdFiles = createdFiles;
            this.finishedFiles = finishedFiles;
            this.modifiedTypes = modifiedTypes;
            this.aptGenerated = aptGenerated;
        }

        public static ParsingOutput success(@NullAllowed String moduleName, Map<JavaFileObject, List<String>> file2FQNs, Set<ElementHandle<TypeElement>> addedTypes, Set<ElementHandle<ModuleElement>> addedModules, Set<File> createdFiles, Set<Indexable> finishedFiles, Set<ElementHandle<TypeElement>> modifiedTypes, Set<FileObject> aptGenerated) {
            return new ParsingOutput(true, false, moduleName, file2FQNs, addedTypes, addedModules, createdFiles, finishedFiles, modifiedTypes, aptGenerated);
        }

        public static ParsingOutput failure(@NullAllowed String moduleName, Map<JavaFileObject, List<String>> file2FQNs, Set<ElementHandle<TypeElement>> addedTypes, Set<ElementHandle<ModuleElement>> addedModules, Set<File> createdFiles, Set<Indexable> finishedFiles, Set<ElementHandle<TypeElement>> modifiedTypes, Set<FileObject> aptGenerated) {
            return new ParsingOutput(false, false, moduleName, file2FQNs, addedTypes, addedModules, createdFiles, finishedFiles, modifiedTypes, aptGenerated);
        }

        public static ParsingOutput lowMemory(@NullAllowed String moduleName, Map<JavaFileObject, List<String>> file2FQNs, Set<ElementHandle<TypeElement>> addedTypes, Set<ElementHandle<ModuleElement>> addedModules, Set<File> createdFiles, Set<Indexable> finishedFiles, Set<ElementHandle<TypeElement>> modifiedTypes, Set<FileObject> aptGenerated) {
            return new ParsingOutput(false, true, moduleName, file2FQNs, addedTypes, addedModules, createdFiles, finishedFiles, modifiedTypes, aptGenerated);
        }
    }

    protected static class ModuleName {
        public String name;
        public boolean assigned;

        public ModuleName(String name) {
            this.name = name;
        }
    }
}

