/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jpt.sun.tools.javac.util.Abort;
import jpt.sun.tools.javac.util.ClientCodeException;
import jpt.sun.tools.javac.util.Context;
import jpt30.annotation.processing.Completion;
import jpt30.annotation.processing.ProcessingEnvironment;
import jpt30.annotation.processing.Processor;
import jpt30.annotation.processing.RoundEnvironment;
import jpt30.lang.model.SourceVersion;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.tools.Diagnostic;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.AnnotationProcessingQuery;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Module;
import org.netbeans.modules.java.source.indexing.Bundle;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.CachingArchiveClassLoader;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.usages.LongHashMap;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.indexing.PathRegistry;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public class APTUtils
implements ChangeListener,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(APTUtils.class.getName());
    private static final String PROCESSOR_MODULE_PATH = "processorModulePath";
    private static final String PROCESSOR_PATH = "processorPath";
    private static final String BOOT_PATH = "bootPath";
    private static final String COMPILE_PATH = "compilePath";
    private static final String APT_ENABLED = "aptEnabled";
    private static final String APT_DIRTY = "aptDirty";
    private static final String ANNOTATION_PROCESSORS = "annotationProcessors";
    private static final String SOURCE_LEVEL_ROOT = "sourceLevel";
    private static final String JRE_PROFILE = "jreProfile";
    private static final String COMPILER_OPTIONS = "compilerOptions";
    private static final int PATH_FLAG_EXISTS = 1;
    private static final Map<URL, APTUtils> knownSourceRootsMap = new HashMap<URL, APTUtils>();
    private static final Map<FileObject, Reference<APTUtils>> auxiliarySourceRootsMap = new WeakHashMap<FileObject, Reference<APTUtils>>();
    private static final Lookup HARDCODED_PROCESSORS = Lookups.forPath("Editors/text/x-java/AnnotationProcessors");
    private static final boolean DISABLE_CLASSLOADER_CACHE = Boolean.getBoolean("java.source.aptutils.disable.classloader.cache");
    private static final int SLIDING_WINDOW = 1000;
    private static final RequestProcessor RP = new RequestProcessor(APTUtils.class);
    private static final RequestProcessor ROOT_CHANGE_RP = new RequestProcessor(APTUtils.class);
    private final FileObject root;
    private volatile ClassPath bootPath;
    private volatile ClassPath compilePath;
    private final AtomicReference<ClassPath> processorPath;
    private final AtomicReference<ClassPath> processorModulePath;
    private final AnnotationProcessingQuery.Result aptOptions;
    private final SourceLevelQuery.Result sourceLevel;
    private final CompilerOptionsQuery.Result compilerOptions;
    private final RequestProcessor.Task slidingRefresh;
    private final UsedRoots usedRoots;
    private volatile ClassLoaderRef classLoaderCache;
    private static final Iterable<? extends String> javacPackages = Arrays.asList("com.sun.javadoc.", "jpt.sun.source.", "jpt30.annotation.processing.", "jpt30.lang.model.", "jpt30.tools.", "jpt.sun.tools.javac.", "jpt.sun.tools.javadoc.", "jpt.sun.tools.classfile.", "jpt.sun.tools.hc.");

    private APTUtils(@NonNull FileObject root) {
        this.root = root;
        this.bootPath = ClassPath.getClassPath(root, "classpath/boot");
        this.compilePath = ClassPath.getClassPath(root, "classpath/compile");
        this.processorPath = new AtomicReference<ClassPath>(ClassPath.getClassPath(root, "classpath/processor"));
        this.processorModulePath = new AtomicReference<ClassPath>(ClassPath.getClassPath(root, "modules/processor"));
        this.aptOptions = AnnotationProcessingQuery.getAnnotationProcessingOptions(root);
        this.sourceLevel = SourceLevelQuery.getSourceLevel2(root);
        this.compilerOptions = CompilerOptionsQuery.getOptions(root);
        this.slidingRefresh = RP.create(() -> IndexingManager.getDefault().refreshIndex(root.toURL(), Collections.emptyList(), false));
        this.usedRoots = new UsedRoots(root.toURL());
    }

    @CheckForNull
    public static APTUtils get(FileObject root) {
        APTUtils utils;
        if (root == null) {
            return null;
        }
        URL rootUrl = root.toURL();
        if (knownSourceRootsMap.containsKey(rootUrl)) {
            APTUtils utils2 = knownSourceRootsMap.get(rootUrl);
            if (utils2 == null) {
                utils2 = APTUtils.create(root);
                knownSourceRootsMap.put(rootUrl, utils2);
            }
            return utils2;
        }
        Reference<APTUtils> utilsRef = auxiliarySourceRootsMap.get(root);
        APTUtils aPTUtils = utils = utilsRef != null ? utilsRef.get() : null;
        if (utils != null) {
            return utils;
        }
        if (APTUtils.isAptBuildGeneratedFolder(root)) {
            return null;
        }
        utils = APTUtils.create(root);
        auxiliarySourceRootsMap.put(root, new WeakReference<APTUtils>(utils));
        return utils;
    }

    @CheckForNull
    public static APTUtils getIfExist(@NullAllowed FileObject root) {
        if (root == null) {
            return null;
        }
        URL rootUrl = root.toURL();
        APTUtils res = knownSourceRootsMap.get(rootUrl);
        if (res != null) {
            return res;
        }
        Reference<APTUtils> utilsRef = auxiliarySourceRootsMap.get(root);
        res = utilsRef != null ? utilsRef.get() : null;
        return res;
    }

    public static void sourceRootRegistered(FileObject root, URL rootURL) {
        if (root == null || knownSourceRootsMap.containsKey(rootURL) || PathRegistry.getDefault().getUnknownRoots().contains(rootURL)) {
            return;
        }
        Reference<APTUtils> utilsRef = auxiliarySourceRootsMap.remove(root);
        APTUtils utils = utilsRef != null ? utilsRef.get() : null;
        knownSourceRootsMap.put(rootURL, utils);
    }

    public static void sourceRootUnregistered(Iterable<? extends URL> roots) {
        for (URL uRL : roots) {
            knownSourceRootsMap.remove(uRL);
        }
        for (URL uRL : PathRegistry.getDefault().getUnknownRoots()) {
            knownSourceRootsMap.remove(uRL);
        }
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        if (projects.length == 0 && !knownSourceRootsMap.isEmpty()) {
            LOG.log(Level.WARNING, "Non removed known roots: {0}", knownSourceRootsMap.keySet());
            knownSourceRootsMap.clear();
        }
    }

    @NonNull
    private static APTUtils create(FileObject root) {
        APTUtils utils = new APTUtils(root);
        utils.listen();
        return utils;
    }

    private static boolean isAptBuildGeneratedFolder(@NonNull FileObject root) {
        ClassPath scp = ClassPath.getClassPath(root, "classpath/source");
        if (scp != null) {
            for (FileObject srcRoot : scp.getRoots()) {
                if (!root.toURL().equals(AnnotationProcessingQuery.getAnnotationProcessingOptions(srcRoot).sourceOutputDirectory())) continue;
                return true;
            }
        }
        return false;
    }

    @NonNull
    public FileObject getRoot() {
        return this.root;
    }

    public boolean aptEnabledOnScan() {
        return this.aptOptions.annotationProcessingEnabled().contains((Object)AnnotationProcessingQuery.Trigger.ON_SCAN);
    }

    public boolean aptEnabledInEditor() {
        return this.aptOptions.annotationProcessingEnabled().contains((Object)AnnotationProcessingQuery.Trigger.IN_EDITOR);
    }

    @CheckForNull
    public URL sourceOutputDirectory() {
        return this.aptOptions.sourceOutputDirectory();
    }

    public Collection<? extends Processor> resolveProcessors(boolean onScan) {
        ClassLoader cl;
        ClassPath[] pps = this.validatePaths();
        boolean isModule = false;
        ClassLoaderRef cache = this.classLoaderCache;
        if (cache == null || (cl = cache.get(this.root)) == null) {
            ClassLoader contextCL;
            ClassPath pp = pps[1];
            if (pps[0] != null && !pps[0].entries().isEmpty()) {
                pp = pps[0];
                isModule = true;
            }
            if (pp == null) {
                pp = ClassPath.EMPTY;
            }
            cl = CachingArchiveClassLoader.forClassPath(pp, (contextCL = Context.class.getClassLoader()) != null ? new BypassOpenIDEUtilClassLoader(contextCL) : ClassLoader.getSystemClassLoader().getParent(), this.usedRoots);
            this.classLoaderCache = !DISABLE_CLASSLOADER_CACHE ? new ClassLoaderRef(cl, this.root, isModule) : null;
        } else {
            isModule = cache.isModule;
        }
        Collection<Processor> result = this.lookupProcessors(cl, onScan, isModule);
        return result;
    }

    public Map<? extends String, ? extends String> processorOptions() {
        return this.aptOptions.processorOptions();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.verifyAttributes(this.root, true)) {
            this.slidingRefresh.schedule(1000);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("roots".equals(evt.getPropertyName())) {
            this.classLoaderCache = null;
            ROOT_CHANGE_RP.execute(() -> {
                if (this.verifyProcessorPath(this.root, this.usedRoots, PROCESSOR_MODULE_PATH) || this.verifyProcessorPath(this.root, this.usedRoots, PROCESSOR_PATH)) {
                    this.slidingRefresh.schedule(1000);
                }
            });
        }
    }

    private void listen() {
        APTUtils.listenOnProcessorPath(this.processorPath.get(), this);
        APTUtils.listenOnProcessorPath(this.processorModulePath.get(), this);
        this.aptOptions.addChangeListener(WeakListeners.change(this, this.aptOptions));
        if (this.sourceLevel.supportsChanges()) {
            this.sourceLevel.addChangeListener(WeakListeners.change(this, this.sourceLevel));
        }
        this.compilerOptions.addChangeListener(WeakListeners.change(this, this.compilerOptions));
    }

    private static void listenOnProcessorPath(@NullAllowed ClassPath cp, @NonNull APTUtils target) {
        if (cp != null) {
            cp.addPropertyChangeListener(WeakListeners.propertyChange(target, cp));
            cp.getRoots();
        }
    }

    private ClassPath[] validatePaths() {
        ClassPath pp;
        ClassPath pmp = this.processorModulePath.get();
        if (pmp == null && (pmp = ClassPath.getClassPath(this.root, "modules/processor")) != null && this.processorModulePath.compareAndSet(null, pmp)) {
            APTUtils.listenOnProcessorPath(pmp, this);
            this.classLoaderCache = null;
        }
        if ((pp = this.processorPath.get()) == null && (pp = ClassPath.getClassPath(this.root, "classpath/processor")) != null && this.processorPath.compareAndSet(null, pp)) {
            this.bootPath = ClassPath.getClassPath(this.root, "classpath/boot");
            this.compilePath = ClassPath.getClassPath(this.root, "classpath/compile");
            APTUtils.listenOnProcessorPath(pp, this);
            this.classLoaderCache = null;
        }
        return new ClassPath[]{pmp, pp};
    }

    private Collection<Processor> lookupProcessors(ClassLoader cl, boolean onScan, boolean isModule) {
        Iterable<? extends String> processorNames = this.aptOptions.annotationProcessorsToRun();
        if (processorNames == null) {
            processorNames = this.getProcessorNames(cl, isModule);
        }
        LinkedList<Processor> result = new LinkedList<Processor>();
        for (String string : processorNames) {
            try {
                Class<?> clazz = Class.forName(string, true, cl);
                Object instance = clazz.newInstance();
                if (!(instance instanceof Processor)) continue;
                result.add(new ErrorToleratingProcessor((Processor)instance));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, null, t);
            }
        }
        if (!onScan) {
            result.addAll(HARDCODED_PROCESSORS.lookupAll(Processor.class));
        }
        return result;
    }

    @NonNull
    private Iterable<? extends String> getProcessorNames(@NonNull ClassLoader cl, boolean isModule) {
        try {
            return CachingArchiveClassLoader.readAction(() -> {
                InputStream stream;
                LinkedList<String> result = new LinkedList<String>();
                InputStream inputStream = stream = isModule ? cl.getResourceAsStream("module-info.class") : null;
                if (stream != null) {
                    ClassFile classFile = new ClassFile(stream);
                    Module module = classFile.getModule();
                    module.getProvidesEntries().stream().filter(providesEntry -> Processor.class.getName().equals(providesEntry.getService().getExternalName())).forEachOrdered(providesEntry -> providesEntry.getImplementations().forEach(implementation -> result.add(implementation.getExternalName())));
                } else {
                    Enumeration<URL> resources = cl.getResources("META-INF/services/" + Processor.class.getName());
                    while (resources.hasMoreElements()) {
                        BufferedReader ins = null;
                        try {
                            String line;
                            URLConnection uc = resources.nextElement().openConnection();
                            uc.setUseCaches(false);
                            ins = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
                            while ((line = ins.readLine()) != null) {
                                int hash = line.indexOf(35);
                                String string = line = hash != -1 ? line.substring(0, hash) : line;
                                if ((line = line.trim()).length() <= 0) continue;
                                result.add(line);
                            }
                        }
                        catch (IOException ex) {
                            LOG.log(Level.FINE, null, ex);
                        }
                        finally {
                            if (ins == null) continue;
                            ins.close();
                        }
                    }
                }
                return result;
            });
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, null, ex);
            return Collections.emptySet();
        }
    }

    boolean verifyAttributes(FileObject fo, boolean checkOnly) {
        if (fo == null) {
            return false;
        }
        boolean vote = false;
        try {
            boolean apEnabledOnScan;
            String cmpOptsStr;
            ClassPath[] pps = this.validatePaths();
            URL url = fo.toURL();
            String val = JavaIndex.getAttribute(url, APT_DIRTY, null);
            if (Boolean.parseBoolean(val)) {
                JavaIndex.LOG.fine("forcing reindex due to processors dirty");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
                JavaIndex.setAttribute(url, APT_DIRTY, null);
            }
            if (JavaIndex.ensureAttributeValue(url, SOURCE_LEVEL_ROOT, this.sourceLevel.getSourceLevel(), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to source level change");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (JavaIndex.ensureAttributeValue(url, JRE_PROFILE, this.sourceLevel.getProfile().getName(), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to jre profile change");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (JavaIndex.ensureAttributeValue(url, COMPILER_OPTIONS, cmpOptsStr = JavacParser.validateCompilerOptions(this.compilerOptions.getArguments(), null).stream().collect(Collectors.joining(" ")), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to compiler options change");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (JavaIndex.ensureAttributeValue(url, BOOT_PATH, APTUtils.pathToString(this.bootPath), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to boot path change");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (JavaIndex.ensureAttributeValue(url, COMPILE_PATH, APTUtils.pathToString(this.compilePath), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to compile path change");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (JavaIndex.ensureAttributeValue(url, APT_ENABLED, (apEnabledOnScan = this.aptOptions.annotationProcessingEnabled().contains((Object)AnnotationProcessingQuery.Trigger.ON_SCAN)) ? Boolean.TRUE.toString() : null, checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to change in annotation processing options");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (!apEnabledOnScan) {
                return vote;
            }
            if (JavaIndex.ensureAttributeValue(url, PROCESSOR_MODULE_PATH, APTUtils.pathToFlaggedString(pps[0], false), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to processor module path change");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (JavaIndex.ensureAttributeValue(url, PROCESSOR_PATH, APTUtils.pathToFlaggedString(pps[1], false), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to processor path change");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
            if (JavaIndex.ensureAttributeValue(url, ANNOTATION_PROCESSORS, APTUtils.encodeToStirng(this.aptOptions.annotationProcessorsToRun()), checkOnly)) {
                JavaIndex.LOG.fine("forcing reindex due to change in annotation processors");
                vote = true;
                if (checkOnly) {
                    return vote;
                }
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace(ioe);
        }
        return vote;
    }

    private boolean verifyProcessorPath(@NonNull FileObject root, @NonNull UsedRoots usedRoots, @NonNull String id) {
        try {
            ClassPath pp;
            LongHashMap<? extends File> used = usedRoots.getRoots();
            URL url = root.toURL();
            ClassPath[] pps = this.validatePaths();
            ClassPath classPath = pp = PROCESSOR_MODULE_PATH.equals(id) ? pps[0] : pps[1];
            if (pp == null) {
                pp = ClassPath.EMPTY;
            }
            Set currentExitingFiles = pp.entries().stream().map(e -> e.getRoot()).filter(fo -> fo != null && fo.isValid()).map(fo -> FileUtil.isArchiveArtifact(fo) ? FileUtil.getArchiveFile(fo) : fo).filter(fo -> fo != null && fo.isValid()).map(FileUtil::toFile).filter(file -> file != null).collect(Collectors.toSet());
            Set currentAllFiles = pp.entries().stream().map(e -> FileUtil.archiveOrDirForURL(e.getURL())).filter(file -> file != null).collect(Collectors.toSet());
            HashSet<File> oldExistingFiles = new HashSet<File>();
            HashSet<File> oldAllFiles = new HashSet<File>();
            String raw = JavaIndex.getAttribute(url, id, "");
            if (!raw.isEmpty()) {
                String[] parts = raw.split(File.pathSeparator);
                for (int i = 0; i < parts.length; i += 2) {
                    File f2 = new File(parts[i]);
                    int flags = 1;
                    try {
                        if (i + 1 < parts.length) {
                            flags = Integer.parseInt(parts[i + 1]);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    oldAllFiles.add(f2);
                    if (!(flags & true)) continue;
                    oldExistingFiles.add(f2);
                }
            }
            HashSet added = new HashSet(currentExitingFiles);
            added.removeAll(oldExistingFiles);
            Set<Object> removed = new HashSet(oldExistingFiles);
            removed.removeAll(currentExitingFiles);
            LOG.log(Level.FINEST, "Added: {0}", added);
            LOG.log(Level.FINEST, "Removed: {0}", removed);
            if (!added.isEmpty() || !removed.isEmpty()) {
                JavaIndex.setAttribute(url, id, APTUtils.pathToFlaggedString(pp, true));
            }
            boolean res = false;
            Iterator it = removed.iterator();
            while (it.hasNext()) {
                File f3 = (File)it.next();
                if (currentAllFiles.contains(f3)) continue;
                LOG.log(Level.FINEST, "Removed from path: {0}", f3);
                it.remove();
                usedRoots.remove(f3);
                res = true;
            }
            Predicate<File> pUsed = f -> used == null || used.containsKey(f);
            Predicate<Pair> pModified = p -> used == null || (Long)p.second() == -1L || used.get(p.first()) != ((Long)p.second()).longValue();
            Predicate<File> pNotProjDep = f -> {
                URL furl = FileUtil.urlForArchiveOrDir(f);
                return furl == null ? true : !APTUtils.hasSourceCache(furl);
            };
            if (!(removed = removed.stream().filter(pUsed).filter(pNotProjDep).collect(Collectors.toSet())).isEmpty()) {
                LOG.log(Level.FINEST, "Important deleted: {0}", removed);
                res = true;
            }
            Iterator it2 = added.iterator();
            while (it2.hasNext()) {
                File f4 = (File)it2.next();
                if (oldAllFiles.contains(f4)) continue;
                LOG.log(Level.FINEST, "Added to path: {0}", f4);
                it2.remove();
                res = true;
            }
            Collection times = added.stream().filter(pUsed).map(f -> Pair.of(f, f.isFile() ? f.length() : -1L)).filter(pModified).collect(Collectors.toList());
            if (!times.isEmpty()) {
                LOG.log(Level.FINEST, "Important changed: {0}", times);
                for (Pair p2 : times) {
                    usedRoots.update((File)p2.first(), (Long)p2.second());
                }
                res = true;
            }
            if (res) {
                JavaIndex.setAttribute(url, APT_DIRTY, Boolean.TRUE.toString());
                JavaIndex.LOG.fine("forcing reindex due to processor path change");
            }
            return res;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace(ioe);
            return false;
        }
    }

    @NonNull
    private static String pathToString(@NullAllowed ClassPath cp) {
        StringBuilder b = new StringBuilder();
        if (cp == null) {
            cp = ClassPath.EMPTY;
        }
        for (ClassPath.Entry cpe : cp.entries()) {
            URL u;
            FileObject fo = cpe.getRoot();
            if (fo != null) {
                u = fo.toURL();
                APTUtils.append(b, u);
                continue;
            }
            if (!APTUtils.hasSourceCache(cpe.getURL())) continue;
            u = cpe.getURL();
            APTUtils.append(b, u);
        }
        return b.toString();
    }

    @NonNull
    private static String pathToFlaggedString(@NullAllowed ClassPath cp, boolean checkArchiveFile) {
        StringBuilder b = new StringBuilder();
        if (cp == null) {
            cp = ClassPath.EMPTY;
        }
        for (ClassPath.Entry cpe : cp.entries()) {
            boolean exists = Optional.ofNullable(cpe.getRoot()).map(fo -> checkArchiveFile && FileUtil.isArchiveArtifact(fo) ? FileUtil.getArchiveFile(fo) : fo).map(fo -> checkArchiveFile ? fo.isValid() : true).orElse(Boolean.FALSE);
            APTUtils.append(b, cpe.getURL()).append(File.pathSeparatorChar).append(exists ? 1 : 0);
        }
        return b.toString();
    }

    private static String encodeToStirng(Iterable<? extends String> strings) {
        if (strings == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<? extends String> it = strings.iterator();
        while (it.hasNext()) {
            sb.append((Object)it.next());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    @NonNull
    private static StringBuilder append(@NonNull StringBuilder builder, @NonNull URL url) {
        File f = FileUtil.archiveOrDirForURL(url);
        if (f != null) {
            if (builder.length() > 0) {
                builder.append(File.pathSeparatorChar);
            }
            builder.append(f.getAbsolutePath());
        } else {
            if (builder.length() > 0) {
                builder.append(File.pathSeparatorChar);
            }
            builder.append(url);
        }
        return builder;
    }

    private static boolean hasSourceCache(@NonNull URL root) {
        return SourceForBinaryQuery.findSourceRoots2(root).preferSources();
    }

    private static final class ErrorToleratingProcessor
    implements Processor {
        private final Processor delegate;
        private ProcessingEnvironment processingEnv;
        private boolean valid = true;

        public ErrorToleratingProcessor(Processor delegate) {
            this.delegate = delegate;
        }

        @Override
        public Set<String> getSupportedOptions() {
            return this.delegate.getSupportedOptions();
        }

        @Override
        public Set<String> getSupportedAnnotationTypes() {
            return this.delegate.getSupportedAnnotationTypes();
        }

        @Override
        public SourceVersion getSupportedSourceVersion() {
            return this.delegate.getSupportedSourceVersion();
        }

        @Override
        public void init(ProcessingEnvironment processingEnv) {
            this.delegate.init(processingEnv);
            this.processingEnv = processingEnv;
        }

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            if (!this.valid) {
                return false;
            }
            try {
                return this.delegate.process(annotations, roundEnv);
            }
            catch (ThreadDeath | Abort | ClientCodeException err) {
                this.valid = false;
                throw err;
            }
            catch (Throwable t) {
                this.valid = false;
                Element el = roundEnv.getRootElements().isEmpty() ? null : roundEnv.getRootElements().iterator().next();
                StringBuilder exception = new StringBuilder();
                exception.append(t.getMessage()).append("\n");
                for (StackTraceElement ste : t.getStackTrace()) {
                    exception.append(ste).append("\n");
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, Bundle.ERR_ProcessorException(this.delegate.getClass().getName(), exception.toString()), el);
                return false;
            }
        }

        @Override
        public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
            return this.delegate.getCompletions(element, annotation, member, userText);
        }
    }

    private static final class UsedRoots
    implements Consumer<URL> {
        private static final String ATTR_USED_PROC = "apUsed";
        private static final int DEFERRED_SAVE = 2500;
        private static final LongHashMap<File> TOMBSTONE = new LongHashMap();
        private static final RequestProcessor SAVER = new RequestProcessor(UsedRoots.class.getName(), 1, false, false);
        private final URL root;
        private final RequestProcessor.Task saveTask;
        private LongHashMap<File> used;

        UsedRoots(@NonNull URL root) {
            this.root = root;
            this.saveTask = SAVER.create(() -> this.save());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@NonNull URL url) {
            UsedRoots usedRoots = this;
            synchronized (usedRoots) {
                File f;
                this.load();
                if (this.used == null || this.used == TOMBSTONE) {
                    this.used = new LongHashMap();
                }
                if ((f = FileUtil.archiveOrDirForURL(url)) != null) {
                    long size;
                    long l = size = f.isFile() ? f.length() : -1L;
                    if (!this.used.containsKey(f)) {
                        this.used.put(f, size);
                        this.saveTask.schedule(2500);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(@NonNull File file, long size) {
            UsedRoots usedRoots = this;
            synchronized (usedRoots) {
                this.load();
                if (this.used == null || this.used == TOMBSTONE) {
                    this.used = new LongHashMap();
                }
                if (this.used.put(file, size) != size) {
                    this.saveTask.schedule(2500);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(@NonNull File file) {
            UsedRoots usedRoots = this;
            synchronized (usedRoots) {
                this.load();
                if (this.used == null || this.used == TOMBSTONE) {
                    return;
                }
                if (this.used.remove(file) != Long.MIN_VALUE) {
                    this.saveTask.schedule(2500);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            UsedRoots usedRoots = this;
            synchronized (usedRoots) {
                this.used = TOMBSTONE;
            }
        }

        @CheckForNull
        LongHashMap<? extends File> getRoots() {
            LongHashMap<File> res = this.load();
            return res == TOMBSTONE ? null : res;
        }

        @NonNull
        private synchronized LongHashMap<File> load() {
            block9: {
                if (this.used == null) {
                    try {
                        String raw = JavaIndex.getAttribute(this.root, ATTR_USED_PROC, null);
                        if (raw != null && !raw.isEmpty()) {
                            LongHashMap<File> s = new LongHashMap<File>();
                            String[] parts = raw.split(File.pathSeparator);
                            for (int i = 0; i < parts.length; i += 2) {
                                File f = new File(parts[i]);
                                long size = -1L;
                                if (i + 1 < parts.length) {
                                    try {
                                        size = Long.parseLong(parts[i + 1]);
                                    }
                                    catch (NumberFormatException e) {
                                        LOG.log(parts[i + 1].isEmpty() ? Level.FINE : Level.WARNING, "Wrong size of {0}: {1}", new Object[]{f.getAbsolutePath(), parts[i + 1]});
                                    }
                                }
                                s.put(f, size);
                            }
                            this.used = s;
                            break block9;
                        }
                        this.used = TOMBSTONE;
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace(ioe);
                        this.used = TOMBSTONE;
                    }
                }
            }
            assert (this.used != null);
            return this.used;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void save() {
            String val;
            LongHashMap<File> toSave;
            UsedRoots usedRoots = this;
            synchronized (usedRoots) {
                toSave = this.used == TOMBSTONE ? null : new LongHashMap<File>(this.used);
            }
            if (toSave == null) {
                val = null;
            } else {
                StringBuilder raw = new StringBuilder();
                for (LongHashMap.Entry<File> e : toSave.entrySet()) {
                    if (raw.length() != 0) {
                        raw.append(File.pathSeparatorChar);
                    }
                    raw.append(e.getKey().getAbsolutePath());
                    raw.append(File.pathSeparator);
                    raw.append(e.getValue());
                }
                val = raw.toString();
            }
            try {
                JavaIndex.setAttribute(this.root, ATTR_USED_PROC, val);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace(ioe);
            }
            finally {
                UsedRoots usedRoots2 = this;
                synchronized (usedRoots2) {
                    if (this.used == TOMBSTONE) {
                        this.used = null;
                    }
                }
            }
        }
    }

    private static final class ClassLoaderRef
    extends SoftReference<ClassLoader>
    implements Runnable {
        private final long timeStamp;
        private final String rootPath;
        private final boolean isModule;

        public ClassLoaderRef(ClassLoader cl, FileObject root, boolean isModule) {
            super(cl, BaseUtilities.activeReferenceQueue());
            this.timeStamp = ClassLoaderRef.getTimeStamp(root);
            this.rootPath = FileUtil.getFileDisplayName(root);
            this.isModule = isModule;
            LOG.log(Level.FINER, "ClassLoader for root {0} created.", new Object[]{this.rootPath});
        }

        public ClassLoader get(FileObject root) {
            long curTimeStamp = ClassLoaderRef.getTimeStamp(root);
            return curTimeStamp == this.timeStamp ? (ClassLoader)this.get() : null;
        }

        @Override
        public void run() {
            LOG.log(Level.FINER, "ClassLoader for root {0} freed.", new Object[]{this.rootPath});
        }

        private static long getTimeStamp(FileObject root) {
            FileObject archiveFile = FileUtil.getArchiveFile(root);
            return archiveFile != null ? root.lastModified().getTime() : -1L;
        }
    }

    private static final class BypassOpenIDEUtilClassLoader
    extends ClassLoader {
        private final ClassLoader contextCL;

        public BypassOpenIDEUtilClassLoader(ClassLoader contextCL) {
            super(BypassOpenIDEUtilClassLoader.getSystemClassLoader().getParent());
            this.contextCL = contextCL;
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            char f;
            char c = f = name.length() > 4 ? name.charAt(4) : (char)'\u0000';
            if (f == 'x' || f == 's') {
                for (String pack : javacPackages) {
                    if (!name.startsWith(pack)) continue;
                    return this.contextCL.loadClass(name);
                }
            }
            return super.loadClass(name, resolve);
        }
    }
}

