/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.batch;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import jpt.sun.tools.javac.api.JavacTaskImpl;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.Log;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.java.hints.spiimpl.JavaFixImpl;
import org.netbeans.modules.java.hints.spiimpl.MessageImpl;
import org.netbeans.modules.java.hints.spiimpl.SyntheticFix;
import org.netbeans.modules.java.hints.spiimpl.batch.BatchSearch;
import org.netbeans.modules.java.hints.spiimpl.batch.ProgressHandleWrapper;
import org.netbeans.modules.java.hints.spiimpl.ipi.upgrade.ProjectDependencyUpgrader;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.parsing.CompilationInfoImpl;
import org.netbeans.modules.java.source.save.DiffUtilities;
import org.netbeans.modules.java.source.save.ElementOverlay;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class BatchUtilities {
    private static final Logger LOG = Logger.getLogger(BatchUtilities.class.getName());
    public static final String ENSURE_DEPENDENCY = "ensure-dependency";

    public static Collection<ModificationResult> applyFixes(BatchSearch.BatchResult candidates, @NonNull ProgressHandleWrapper progress, AtomicBoolean cancel, Collection<? super MessageImpl> problems) {
        return BatchUtilities.applyFixes(candidates, progress, cancel, new ArrayList(), problems);
    }

    public static Collection<ModificationResult> applyFixes(BatchSearch.BatchResult candidates, @NonNull ProgressHandleWrapper progress, AtomicBoolean cancel, Collection<? super RefactoringElementImplementation> fileChanges, Collection<? super MessageImpl> problems) {
        return BatchUtilities.applyFixes(candidates, progress, cancel, fileChanges, null, problems);
    }

    public static Collection<ModificationResult> applyFixes(BatchSearch.BatchResult candidates, @NonNull ProgressHandleWrapper progress, AtomicBoolean cancel, Collection<? super RefactoringElementImplementation> fileChanges, Map<JavaFix, ModificationResult> changesPerFix, Collection<? super MessageImpl> problems) {
        return BatchUtilities.applyFixes(candidates, progress, cancel, fileChanges, changesPerFix, false, problems);
    }

    public static Collection<ModificationResult> applyFixes(BatchSearch.BatchResult candidates, final @NonNull ProgressHandleWrapper progress, AtomicBoolean cancel, final Collection<? super RefactoringElementImplementation> fileChanges, final Map<JavaFix, ModificationResult> changesPerFix, boolean doNotRegisterClassPath, final Collection<? super MessageImpl> problems) {
        final IdentityHashMap processedDependencyChanges = new IdentityHashMap();
        final LinkedHashMap<FileObject, List<ModificationResult.Difference>> result = new LinkedHashMap<FileObject, List<ModificationResult.Difference>>();
        final HashMap<FileObject, byte[]> resourceContentChanges = new HashMap<FileObject, byte[]>();
        BatchSearch.VerifiedSpansCallBack callback = new BatchSearch.VerifiedSpansCallBack(){
            private ElementOverlay overlay;

            @Override
            public void groupStarted() {
                this.overlay = ElementOverlay.getOrCreateOverlay();
            }

            @Override
            public boolean spansVerified(CompilationController wc, BatchSearch.Resource r, Collection<? extends ErrorDescription> hints) throws Exception {
                if (hints.isEmpty()) {
                    return true;
                }
                Constructor wcConstr = WorkingCopy.class.getDeclaredConstructor(CompilationInfoImpl.class, ElementOverlay.class);
                wcConstr.setAccessible(true);
                WorkingCopy copy = (WorkingCopy)wcConstr.newInstance(JavaSourceAccessor.getINSTANCE().getCompilationInfoImpl(wc), this.overlay);
                Method setJavaSource = CompilationInfo.class.getDeclaredMethod("setJavaSource", JavaSource.class);
                setJavaSource.setAccessible(true);
                setJavaSource.invoke((Object)copy, wc.getJavaSource());
                copy.toPhase(JavaSource.Phase.RESOLVED);
                progress.tick();
                if (BatchUtilities.applyFixes(copy, processedDependencyChanges, hints, resourceContentChanges, fileChanges, changesPerFix, (Collection<? super MessageImpl>)problems)) {
                    return false;
                }
                JavacTaskImpl jt = JavaSourceAccessor.getINSTANCE().getJavacTask(copy);
                Log.instance((Context)jt.getContext()).nerrors = 0;
                Method getChanges = WorkingCopy.class.getDeclaredMethod("getChanges", Map.class);
                getChanges.setAccessible(true);
                result.put(copy.getFileObject(), (List)getChanges.invoke((Object)copy, new HashMap()));
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "fixes applied to: {0}", FileUtil.getFileDisplayName(wc.getFileObject()));
                }
                return true;
            }

            @Override
            public void groupFinished() {
                this.overlay = null;
            }

            @Override
            public void cannotVerifySpan(BatchSearch.Resource r) {
                problems.add(new MessageImpl(HintContext.MessageKind.WARNING, "Cannot parse: " + r.getRelativePath()));
            }
        };
        BatchSearch.getVerifiedSpans(candidates, progress, callback, doNotRegisterClassPath, problems, cancel);
        BatchUtilities.addResourceContentChanges(resourceContentChanges, result);
        return Collections.singletonList(JavaSourceAccessor.getINSTANCE().createModificationResult(result, Collections.emptyMap()));
    }

    public static void addResourceContentChanges(Map<FileObject, byte[]> resourceContentChanges, Map<FileObject, List<ModificationResult.Difference>> result) {
        for (Map.Entry<FileObject, byte[]> e : resourceContentChanges.entrySet()) {
            try {
                Charset encoding = FileEncodingQuery.getEncoding(e.getKey());
                Document originalDocument = BatchUtilities.getDocument(e.getKey());
                String[] origContent = new String[1];
                Source[] s = new Source[1];
                if (originalDocument != null) {
                    originalDocument.render(() -> {
                        try {
                            origContent[0] = originalDocument.getText(0, originalDocument.getLength());
                            s[0] = Source.create(originalDocument);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace(ex);
                        }
                    });
                }
                if (origContent[0] == null) {
                    byte[] origBytes = e.getKey().asBytes();
                    origContent[0] = encoding.newDecoder().decode(ByteBuffer.wrap(origBytes)).toString();
                    s[0] = Source.create(e.getKey());
                }
                String newContent = encoding.newDecoder().decode(ByteBuffer.wrap(e.getValue())).toString();
                result.put(e.getKey(), DiffUtilities.diff2ModificationResultDifference(e.getKey(), null, Collections.emptyMap(), origContent[0], newContent, s[0]));
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace(ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }

    @CheckForNull
    public static Document getDocument(@NonNull FileObject file) {
        try {
            DataObject od = DataObject.find(file);
            EditorCookie ec = od.getLookup().lookup(EditorCookie.class);
            if (ec == null) {
                return null;
            }
            return ec.getDocument();
        }
        catch (DataObjectNotFoundException ex) {
            LOG.log(Level.FINE, null, ex);
            return null;
        }
    }

    private static String positionToString(ErrorDescription ed) {
        try {
            return ed.getFile().getNameExt() + ":" + ed.getRange().getBegin().getLine();
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, null, ex);
            return ed.getFile().getNameExt();
        }
    }

    public static boolean applyFixes(WorkingCopy copy, Map<Project, Set<String>> processedDependencyChanges, Collection<? extends ErrorDescription> hints, Map<FileObject, byte[]> resourceContentChanges, Collection<? super RefactoringElementImplementation> fileChanges, Collection<? super MessageImpl> problems) throws IllegalStateException, Exception {
        return BatchUtilities.applyFixes(copy, processedDependencyChanges, hints, resourceContentChanges, fileChanges, null, problems);
    }

    public static boolean applyFixes(WorkingCopy copy, Map<Project, Set<String>> processedDependencyChanges, Collection<? extends ErrorDescription> hints, Map<FileObject, byte[]> resourceContentChanges, Collection<? super RefactoringElementImplementation> fileChanges, Map<JavaFix, ModificationResult> changesPerFix, Collection<? super MessageImpl> problems) throws IllegalStateException, Exception {
        LinkedHashSet<JavaFix> fixes = new LinkedHashSet<JavaFix>();
        for (ErrorDescription errorDescription : hints) {
            if (!errorDescription.getFixes().isComputed()) {
                throw new IllegalStateException();
            }
            Object toApply = null;
            for (Fix f : errorDescription.getFixes().getFixes()) {
                if (f instanceof SyntheticFix) continue;
                if (toApply == null) {
                    toApply = f;
                    continue;
                }
                problems.add(new MessageImpl(HintContext.MessageKind.WARNING, "More than one fix for: " + errorDescription.getDescription() + " at " + BatchUtilities.positionToString(errorDescription) + ", only the first one will be used."));
            }
            if (toApply == null) {
                boolean doWarning = false;
                if (!$assertionsDisabled) {
                    doWarning = true;
                    if (!true) {
                        throw new AssertionError();
                    }
                }
                if (!doWarning) continue;
                problems.add(new MessageImpl(HintContext.MessageKind.WARNING, "No fix for: " + errorDescription.getDescription() + " at " + BatchUtilities.positionToString(errorDescription) + "."));
                continue;
            }
            if (!(toApply instanceof JavaFixImpl)) {
                throw new IllegalStateException(toApply.getClass().getName());
            }
            fixes.add(((JavaFixImpl)toApply).jf);
        }
        if (BatchUtilities.fixDependencies(copy.getFileObject(), fixes, processedDependencyChanges)) {
            return true;
        }
        for (JavaFix javaFix : fixes) {
            JavaFixImpl.Accessor.INSTANCE.process(javaFix, copy, false, resourceContentChanges, fileChanges);
            if (changesPerFix == null) continue;
            ElementOverlay overlay = ElementOverlay.getOrCreateOverlay();
            Constructor wcConstr = WorkingCopy.class.getDeclaredConstructor(CompilationInfoImpl.class, ElementOverlay.class);
            wcConstr.setAccessible(true);
            WorkingCopy perFixCopy = (WorkingCopy)wcConstr.newInstance(JavaSourceAccessor.getINSTANCE().getCompilationInfoImpl(copy), overlay);
            Method setJavaSource = CompilationInfo.class.getDeclaredMethod("setJavaSource", JavaSource.class);
            setJavaSource.setAccessible(true);
            setJavaSource.invoke((Object)perFixCopy, copy.getJavaSource());
            perFixCopy.toPhase(JavaSource.Phase.RESOLVED);
            HashMap<FileObject, byte[]> perFixResourceContentChanges = new HashMap<FileObject, byte[]>();
            JavaFixImpl.Accessor.INSTANCE.process(javaFix, perFixCopy, false, perFixResourceContentChanges, new ArrayList());
            JavacTaskImpl jt = JavaSourceAccessor.getINSTANCE().getJavacTask(perFixCopy);
            Log.instance((Context)jt.getContext()).nerrors = 0;
            Method getChanges = WorkingCopy.class.getDeclaredMethod("getChanges", Map.class);
            getChanges.setAccessible(true);
            HashMap<FileObject, List<ModificationResult.Difference>> changes = new HashMap<FileObject, List<ModificationResult.Difference>>();
            changes.put(perFixCopy.getFileObject(), (List)getChanges.invoke((Object)perFixCopy, new HashMap()));
            BatchUtilities.addResourceContentChanges(resourceContentChanges, changes);
            Iterator it = changes.entrySet().iterator();
            while (it.hasNext()) {
                if (!((List)it.next().getValue()).isEmpty()) continue;
                it.remove();
            }
            if (changes.isEmpty()) continue;
            ModificationResult perFixResult = JavaSourceAccessor.getINSTANCE().createModificationResult(changes, Collections.emptyMap());
            changesPerFix.put(javaFix, perFixResult);
        }
        return false;
    }

    public static Collection<ModificationResult> applyFixes(Map<FileObject, Collection<JavaFix>> toRun) {
        LinkedHashMap<FileObject, List<ModificationResult.Difference>> result = new LinkedHashMap<FileObject, List<ModificationResult.Difference>>();
        HashMap<FileObject, byte[]> resourceContentChanges = new HashMap<FileObject, byte[]>();
        Map<ClasspathInfo, Collection<FileObject>> cp2Files = BatchUtilities.sortFiles(toRun.keySet());
        for (Map.Entry<ClasspathInfo, Collection<FileObject>> e : cp2Files.entrySet()) {
            try {
                ModificationResult mr = JavaSource.create(e.getKey(), e.getValue()).runModificationTask(parameter -> {
                    if (parameter.toPhase(JavaSource.Phase.RESOLVED).compareTo(JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    for (JavaFix jf : (Collection)toRun.get(parameter.getFileObject())) {
                        JavaFixImpl.Accessor.INSTANCE.process(jf, (WorkingCopy)parameter, false, (Map<FileObject, byte[]>)resourceContentChanges, new ArrayList());
                    }
                });
                result.putAll(JavaSourceAccessor.getINSTANCE().getDiffsFromModificationResult(mr));
            }
            catch (IOException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
        BatchUtilities.addResourceContentChanges(resourceContentChanges, result);
        return Collections.singletonList(JavaSourceAccessor.getINSTANCE().createModificationResult(result, Collections.emptyMap()));
    }

    public static Collection<FileObject> getSourceGroups(Iterable<? extends Project> prjs) {
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        for (Project project : prjs) {
            Sources s = ProjectUtils.getSources(project);
            for (SourceGroup sg : s.getSourceGroups("java")) {
                result.add(sg.getRootFolder());
            }
        }
        return result;
    }

    public static Map<ClasspathInfo, Collection<FileObject>> sortFiles(Collection<? extends FileObject> from) {
        HashMap<CPCategorizer, LinkedList<FileObject>> m = new HashMap<CPCategorizer, LinkedList<FileObject>>();
        for (FileObject fileObject : from) {
            CPCategorizer cpCategorizer = new CPCategorizer(fileObject);
            LinkedList<FileObject> files = (LinkedList<FileObject>)m.get(cpCategorizer);
            if (files == null) {
                files = new LinkedList<FileObject>();
                m.put(cpCategorizer, files);
            }
            files.add(fileObject);
        }
        IdentityHashMap<ClasspathInfo, Collection<FileObject>> result = new IdentityHashMap<ClasspathInfo, Collection<FileObject>>();
        for (Map.Entry e : m.entrySet()) {
            ClasspathInfo cpInfo = new ClasspathInfo.Builder(((CPCategorizer)e.getKey()).boot).setClassPath(((CPCategorizer)e.getKey()).compile).setSourcePath(((CPCategorizer)e.getKey()).source).setModuleSourcePath(((CPCategorizer)e.getKey()).moduleSrcPath).setModuleBootPath(((CPCategorizer)e.getKey()).moduleBootPath).setModuleCompilePath(((CPCategorizer)e.getKey()).moduleCompilePath).setModuleClassPath(((CPCategorizer)e.getKey()).moduleClassPath).build();
            result.put(cpInfo, (Collection)e.getValue());
        }
        return result;
    }

    private static final ClassPath getClassPath(FileObject forFO, String id) {
        ClassPath result = ClassPath.getClassPath(forFO, id);
        if (result == null) {
            result = "classpath/boot".equals(id) ? JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries() : ClassPath.EMPTY;
        }
        return result;
    }

    public static boolean fixDependencies(FileObject file, Iterable<? extends JavaFix> toProcess, Map<Project, Set<String>> alreadyProcessed) {
        boolean modified = false;
        block0: for (JavaFix javaFix : toProcess) {
            Project p;
            String updateTo = JavaFixImpl.Accessor.INSTANCE.getOptions(javaFix).get(ENSURE_DEPENDENCY);
            if (updateTo == null || (p = FileOwnerQuery.getOwner(file)) == null) continue;
            Set<String> seen = alreadyProcessed.get(p);
            if (seen == null) {
                seen = new HashSet<String>();
                alreadyProcessed.put(p, seen);
            }
            if (!seen.add(updateTo)) continue;
            for (ProjectDependencyUpgrader up : Lookup.getDefault().lookupAll(ProjectDependencyUpgrader.class)) {
                if (!up.ensureDependency(p, updateTo, false)) continue;
                modified = true;
                continue block0;
            }
        }
        return modified;
    }

    public static void recursive(FileObject root, FileObject file, Collection<FileObject> collected, ProgressHandleWrapper progress, int depth, Properties timeStamps, Set<String> removedFiles, boolean recursive) {
        if (!VisibilityQuery.getDefault().isVisible(file)) {
            return;
        }
        if (file.isData()) {
            if (timeStamps != null) {
                String relativePath = FileUtil.getRelativePath(root, file);
                String lastModified = Long.toHexString(file.lastModified().getTime());
                removedFiles.remove(relativePath);
                if (lastModified.equals(timeStamps.getProperty(relativePath))) {
                    return;
                }
                timeStamps.setProperty(relativePath, lastModified);
            }
            if ("java".equals(file.getExt()) || "text/x-java".equals(FileUtil.getMIMEType(file, "text/x-java"))) {
                collected.add(file);
            }
        } else {
            ProgressHandleWrapper inner;
            FileObject[] children = file.getChildren();
            if (children.length == 0) {
                return;
            }
            ProgressHandleWrapper progressHandleWrapper = inner = depth < 2 ? progress.startNextPartWithEmbedding(ProgressHandleWrapper.prepareParts(children.length)) : null;
            if (inner == null && progress != null) {
                progress.startNextPart(children.length);
            } else {
                progress = null;
            }
            for (FileObject c : children) {
                if (recursive || c.isData()) {
                    BatchUtilities.recursive(root, c, collected, inner, depth + 1, timeStamps, removedFiles, recursive);
                }
                if (progress == null) continue;
                progress.tick();
            }
        }
    }

    private static final class CPCategorizer {
        private final String cps;
        private final ClassPath boot;
        private final ClassPath compile;
        private final ClassPath source;
        private final ClassPath moduleSrcPath;
        private final ClassPath moduleBootPath;
        private final ClassPath moduleCompilePath;
        private final ClassPath moduleClassPath;
        private final FileObject sourceRoot;

        public CPCategorizer(FileObject file) {
            this.boot = BatchUtilities.getClassPath(file, "classpath/boot");
            this.compile = BatchUtilities.getClassPath(file, "classpath/compile");
            this.source = BatchUtilities.getClassPath(file, "classpath/source");
            this.moduleSrcPath = BatchUtilities.getClassPath(file, "modules/source");
            this.moduleBootPath = BatchUtilities.getClassPath(file, "modules/boot");
            this.moduleCompilePath = BatchUtilities.getClassPath(file, "modules/compile");
            this.moduleClassPath = BatchUtilities.getClassPath(file, "modules/classpath");
            this.sourceRoot = this.source != null ? this.source.findOwnerRoot(file) : null;
            StringBuilder cps = new StringBuilder();
            if (this.boot != null) {
                cps.append(this.boot.toString(ClassPath.PathConversionMode.PRINT));
            }
            if (this.compile != null) {
                cps.append(this.compile.toString(ClassPath.PathConversionMode.PRINT));
            }
            if (this.source != null) {
                cps.append(this.source.toString(ClassPath.PathConversionMode.PRINT));
            }
            if (this.moduleSrcPath != null) {
                cps.append(this.moduleSrcPath.toString(ClassPath.PathConversionMode.PRINT));
            }
            if (this.moduleBootPath != null) {
                cps.append(this.moduleBootPath.toString(ClassPath.PathConversionMode.PRINT));
            }
            if (this.moduleCompilePath != null) {
                cps.append(this.moduleCompilePath.toString(ClassPath.PathConversionMode.PRINT));
            }
            if (this.moduleClassPath != null) {
                cps.append(this.moduleClassPath.toString(ClassPath.PathConversionMode.PRINT));
            }
            this.cps = cps.toString();
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + this.cps.hashCode();
            hash = 53 * hash + (this.sourceRoot != null ? this.sourceRoot.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CPCategorizer other = (CPCategorizer)obj;
            if (!this.cps.equals(other.cps)) {
                return false;
            }
            return this.sourceRoot == other.sourceRoot || this.sourceRoot != null && this.sourceRoot.equals(other.sourceRoot);
        }
    }
}

