/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.LineMap;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.SourcePositions;
import jpt.sun.source.util.TreePath;
import jpt30.tools.Diagnostic;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.modules.java.source.parsing.Hacks;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OrganizeMembers {
    public static ErrorDescription checkMembers(final HintContext context) {
        for (Diagnostic d : context.getInfo().getDiagnostics()) {
            if (!Hacks.isSyntaxError(d)) continue;
            return null;
        }
        Source source = context.getInfo().getSnapshot().getSource();
        try {
            ModificationResult result = ModificationResult.runModificationTask(Collections.singleton(source), new UserTask(){

                @Override
                public void run(ResultIterator resultIterator) throws Exception {
                    WorkingCopy copy = WorkingCopy.get(resultIterator.getParserResult());
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    OrganizeMembers.doOrganizeMembers(copy, context.getPath());
                }
            });
            List<? extends ModificationResult.Difference> diffs = result.getDifferences(source.getFileObject());
            if (diffs != null && !diffs.isEmpty() && !OrganizeMembers.checkGuarded(context.getInfo().getDocument(), diffs)) {
                Fix fix = new OrganizeMembersFix(context.getInfo(), context.getPath()).toEditorFix();
                SourcePositions sp = context.getInfo().getTrees().getSourcePositions();
                int offset = diffs.get(0).getStartPosition().getOffset();
                LineMap lm = context.getInfo().getCompilationUnit().getLineMap();
                long lno = lm.getLineNumber(offset);
                if (lno >= 1L) {
                    offset = (int)lm.getStartPosition(lno);
                }
                CompilationUnitTree cut = context.getPath().getCompilationUnit();
                ClassTree clazz = (ClassTree)context.getPath().getLeaf();
                for (Tree tree : clazz.getMembers()) {
                    if (context.getInfo().getTreeUtilities().isSynthetic(new TreePath(context.getPath(), tree)) || sp.getStartPosition(cut, tree) < (long)offset) continue;
                    return ErrorDescriptionFactory.forTree(context, tree, NbBundle.getMessage(OrganizeMembers.class, "MSG_OragnizeMembers"), fix);
                }
                return ErrorDescriptionFactory.forTree(context, clazz, NbBundle.getMessage(OrganizeMembers.class, "MSG_OragnizeMembers"), fix);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace(ex);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static void doOrganizeMembers(WorkingCopy copy, TreePath path) {
        GeneratorUtilities gu = GeneratorUtilities.get(copy);
        ClassTree clazz = (ClassTree)path.getLeaf();
        clazz = gu.importComments(clazz, copy.getCompilationUnit());
        TreeMaker maker = copy.getTreeMaker();
        ClassTree nue = maker.Class(clazz.getModifiers(), clazz.getSimpleName(), clazz.getTypeParameters(), clazz.getExtendsClause(), clazz.getImplementsClause(), Collections.emptyList());
        ArrayList<void> members = new ArrayList<void>(clazz.getMembers().size());
        HashMap<void, Tree> memberMap = new HashMap<void, Tree>(clazz.getMembers().size());
        ArrayList<Tree> enumValues = new ArrayList<Tree>();
        for (Tree tree : clazz.getMembers()) {
            void var11_16;
            if (copy.getTreeUtilities().isSynthetic(new TreePath(path, tree))) continue;
            switch (tree.getKind()) {
                case CLASS: 
                case INTERFACE: 
                case ENUM: 
                case ANNOTATION_TYPE: {
                    Tree tree2 = maker.setLabel(tree, ((ClassTree)tree).getSimpleName());
                    break;
                }
                case VARIABLE: {
                    Tree tree3 = maker.setLabel(tree, ((VariableTree)tree).getName());
                    if (!copy.getTreeUtilities().isEnumConstant((VariableTree)tree)) break;
                    enumValues.add(tree3);
                    break;
                }
                case METHOD: {
                    Tree tree4 = maker.setLabel(tree, ((MethodTree)tree).getName());
                    break;
                }
                case BLOCK: {
                    BlockTree blockTree = maker.asReplacementOf(maker.Block(((BlockTree)tree).getStatements(), ((BlockTree)tree).isStatic()), tree, true);
                    break;
                }
                default: {
                    Tree tree5 = tree;
                }
            }
            members.add(var11_16);
            memberMap.put(var11_16, tree);
        }
        if (enumValues.isEmpty()) {
            nue = GeneratorUtilities.get(copy).insertClassMembers(nue, members);
        } else {
            members.removeAll(enumValues);
            int max = nue.getMembers().size();
            for (Tree tree : enumValues) {
                nue = maker.insertClassMember(nue, max++, tree);
            }
            nue = GeneratorUtilities.get(copy).insertClassMembers(nue, members);
        }
        ClassTree changed = maker.Class(clazz.getModifiers(), clazz.getSimpleName(), clazz.getTypeParameters(), clazz.getExtendsClause(), clazz.getImplementsClause(), Collections.emptyList());
        boolean bl = false;
        for (Tree tree : nue.getMembers()) {
            void var10_15;
            Tree orig = (Tree)memberMap.get(tree);
            changed = maker.insertClassMember(changed, (int)var10_15, orig);
            ++var10_15;
        }
        copy.rewrite(clazz, changed);
    }

    private static boolean checkGuarded(Document doc, List<? extends ModificationResult.Difference> diffs) {
        if (doc instanceof GuardedDocument) {
            MarkBlockChain chain = ((GuardedDocument)doc).getGuardedBlockChain();
            for (ModificationResult.Difference difference : diffs) {
                if ((chain.compareBlock(difference.getStartPosition().getOffset(), difference.getEndPosition().getOffset()) & 1) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static class OrganizeMembersAction
    extends BaseAction {
        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent component) {
            if (component == null || !component.isEditable() || !component.isEnabled()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            final BaseDocument doc = (BaseDocument)component.getDocument();
            final Source source = Source.create(doc);
            if (source != null) {
                AtomicBoolean cancel = new AtomicBoolean();
                ProgressUtils.runOffEventDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ModificationResult result = ModificationResult.runModificationTask(Collections.singleton(source), new UserTask(){

                                @Override
                                public void run(ResultIterator resultIterator) throws Exception {
                                    WorkingCopy copy = WorkingCopy.get(resultIterator.getParserResult());
                                    copy.toPhase(JavaSource.Phase.RESOLVED);
                                    TreeUtilities tu = copy.getTreeUtilities();
                                    TreePath path = tu.pathFor(component.getCaretPosition());
                                    path = tu.getPathElementOfKind(EnumSet.of(Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE), path);
                                    if (path != null) {
                                        OrganizeMembers.doOrganizeMembers(copy, path);
                                    } else {
                                        CompilationUnitTree cut = copy.getCompilationUnit();
                                        List<? extends Tree> typeDecls = cut.getTypeDecls();
                                        if (typeDecls.isEmpty()) {
                                            Toolkit.getDefaultToolkit().beep();
                                        } else {
                                            OrganizeMembers.doOrganizeMembers(copy, copy.getTrees().getPath(cut, typeDecls.get(0)));
                                        }
                                    }
                                }
                            });
                            List<? extends ModificationResult.Difference> diffs = result.getDifferences(source.getFileObject());
                            if (diffs != null && !diffs.isEmpty() && !OrganizeMembers.checkGuarded(doc, diffs)) {
                                result.commit();
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                            }
                        }
                        catch (Exception ex) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                }, NbBundle.getMessage(OrganizeMembers.class, "MSG_OragnizeMembers"), cancel, false);
            }
        }
    }

    private static class OrganizeMembersFix
    extends JavaFix {
        public OrganizeMembersFix(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        @Override
        public String getText() {
            return NbBundle.getMessage(OrganizeMembers.class, "FIX_OrganizeMembers");
        }

        @Override
        protected void performRewrite(JavaFix.TransformationContext ctx) {
            OrganizeMembers.doOrganizeMembers(ctx.getWorkingCopy(), ctx.getPath());
        }
    }
}

