/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.AbstractClassPathProvider;
import org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.PatchedPublic;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class ProjectHooks {
    private static final Logger LOG = Logger.getLogger(ProjectHooks.class.getName());

    private ProjectHooks() {
        throw new IllegalStateException("No instance allowed");
    }

    @NonNull
    public static ProjectOpenedHookBuilder createProjectOpenedHookBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper, @NonNull AbstractClassPathProvider cpProvider) {
        return new ProjectOpenedHookBuilder(project, eval, updateHelper, genFilesHelper, cpProvider);
    }

    @PatchedPublic
    private static ProjectOpenedHookBuilder createProjectOpenedHookBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper, @NonNull ClassPathProviderImpl cpProviderImpl) {
        return new ProjectOpenedHookBuilder(project, eval, updateHelper, genFilesHelper, cpProviderImpl);
    }

    @NonNull
    public static ProjectXmlSavedHookBuilder createProjectXmlSavedHookBuilder(@NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper) {
        return new ProjectXmlSavedHookBuilder(eval, updateHelper, genFilesHelper);
    }

    private static void runSafe(@NonNull Runnable r) {
        try {
            r.run();
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            LOG.log(Level.INFO, "Action exception", t);
        }
    }

    private static final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        private final PropertyEvaluator eval;
        private final UpdateHelper updateHelper;
        private final GeneratedFilesHelper genFilesHelper;
        private final List<? extends Runnable> preActions;
        private final List<? extends Runnable> postActions;
        private final URL buildImplTemplate;
        private final URL buildTemplate;
        private final String buildScriptProperty;
        private final Callable<Boolean> overridePredicate;

        ProjectXmlSavedHookImpl(@NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper, @NonNull List<? extends Runnable> preActions, @NonNull List<? extends Runnable> postActions, @NullAllowed URL buildImplTemplate, @NullAllowed URL buildTemplate, @NonNull String buildScriptProperty, @NullAllowed Callable<Boolean> overridePredicate) {
            Parameters.notNull("eval", eval);
            Parameters.notNull("updateHelper", updateHelper);
            Parameters.notNull("genFilesHelper", genFilesHelper);
            Parameters.notNull("preActions", preActions);
            Parameters.notNull("postActions", postActions);
            Parameters.notNull("buildScriptProperty", buildScriptProperty);
            this.eval = eval;
            this.updateHelper = updateHelper;
            this.genFilesHelper = genFilesHelper;
            this.preActions = preActions;
            this.postActions = postActions;
            this.buildImplTemplate = buildImplTemplate;
            this.buildTemplate = buildTemplate;
            this.buildScriptProperty = buildScriptProperty;
            this.overridePredicate = overridePredicate;
        }

        @Override
        protected void projectXmlSaved() throws IOException {
            try {
                ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        for (Runnable r : preActions) {
                            ProjectHooks.runSafe(r);
                        }
                        if (updateHelper.isCurrent()) {
                            if (buildImplTemplate != null) {
                                FileObject projectDir;
                                FileObject buildImpl;
                                int state = genFilesHelper.getBuildScriptState("nbproject/build-impl.xml", buildImplTemplate);
                                boolean forceRewriteBuildImpl = false;
                                if ((this.shoulOverrideModifiedBuildImpl() && (state & 4) == 4 || state == 60) && (buildImpl = (projectDir = updateHelper.getAntProjectHelper().getProjectDirectory()).getFileObject("nbproject/build-impl.xml")) != null) {
                                    String name = buildImpl.getName();
                                    String backupext = String.format("%s~", buildImpl.getExt());
                                    FileObject oldBackup = buildImpl.getParent().getFileObject(name, backupext);
                                    if (oldBackup != null) {
                                        oldBackup.delete();
                                    }
                                    FileUtil.copyFile(buildImpl, buildImpl.getParent(), name, backupext);
                                    forceRewriteBuildImpl = true;
                                }
                                if (forceRewriteBuildImpl) {
                                    genFilesHelper.generateBuildScriptFromStylesheet("nbproject/build-impl.xml", buildImplTemplate);
                                } else {
                                    genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", buildImplTemplate, false);
                                }
                            }
                            if (buildTemplate != null) {
                                genFilesHelper.refreshBuildScript(CommonProjectUtils.getBuildXmlName(eval, buildScriptProperty), buildTemplate, false);
                            }
                        }
                        for (Runnable r : postActions) {
                            ProjectHooks.runSafe(r);
                        }
                        return null;
                    }
                });
            }
            catch (MutexException e) {
                Exception inner = e.getException();
                throw inner instanceof IOException ? (IOException)inner : new IOException(inner);
            }
        }

        private boolean shoulOverrideModifiedBuildImpl() {
            try {
                return this.overridePredicate != null && this.overridePredicate.call() == Boolean.TRUE;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace(ex);
                return false;
            }
        }
    }

    private static final class ProjectOpenedHookImpl
    extends ProjectOpenedHook
    implements AbstractClassPathProvider.ClassPathsChangeListener {
        private static final RequestProcessor PROJECT_OPENED_RP = new RequestProcessor(ProjectOpenedHookImpl.class);
        private final Project project;
        private final PropertyEvaluator eval;
        private final UpdateHelper updateHelper;
        private final GeneratedFilesHelper genFilesHelper;
        private final AbstractClassPathProvider cpProvider;
        private final Set<String> classPathTypes;
        private final List<? extends Runnable> preClose;
        private final List<? extends Runnable> postClose;
        private final List<? extends Runnable> preOpen;
        private final List<? extends Runnable> postOpen;
        private final URL buildTemplate;
        private final URL buildImplTemplate;
        private final String buildScriptProperty;
        private final Map<String, Set<ClassPath>> cpCache;
        private final AtomicReference<AbstractClassPathProvider.ClassPathsChangeListener> cpListener;

        ProjectOpenedHookImpl(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper, @NonNull AbstractClassPathProvider cpProvider, @NonNull Set<String> classPathTypes, @NonNull List<? extends Runnable> preOpen, @NonNull List<? extends Runnable> postOpen, @NonNull List<? extends Runnable> preClose, @NonNull List<? extends Runnable> postClose, @NullAllowed URL buildImplTemplate, @NullAllowed URL buildTemplate, @NonNull String buildScriptProperty) {
            Parameters.notNull("project", project);
            Parameters.notNull("eval", eval);
            Parameters.notNull("updateHelper", updateHelper);
            Parameters.notNull("genFilesHelper", genFilesHelper);
            Parameters.notNull("cpProvider", cpProvider);
            Parameters.notNull("classPathTypes", classPathTypes);
            Parameters.notNull("preOpen", preOpen);
            Parameters.notNull("postOpen", postOpen);
            Parameters.notNull("preClose", preClose);
            Parameters.notNull("postClose", postClose);
            Parameters.notNull("buildScriptProperty", buildScriptProperty);
            this.project = project;
            this.eval = eval;
            this.updateHelper = updateHelper;
            this.genFilesHelper = genFilesHelper;
            this.cpProvider = cpProvider;
            this.classPathTypes = classPathTypes;
            this.preOpen = preOpen;
            this.postOpen = postOpen;
            this.preClose = preClose;
            this.postClose = postClose;
            this.buildImplTemplate = buildImplTemplate;
            this.buildTemplate = buildTemplate;
            this.buildScriptProperty = buildScriptProperty;
            this.cpCache = new HashMap<String, Set<ClassPath>>();
            this.cpListener = new AtomicReference();
        }

        @Override
        protected void projectOpened() {
            this.runAtomic(new Runnable(){

                @Override
                public void run() {
                    for (Runnable r : preOpen) {
                        ProjectHooks.runSafe(r);
                    }
                    try {
                        if (updateHelper.isCurrent()) {
                            if (buildImplTemplate != null) {
                                genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", buildImplTemplate, true);
                            }
                            if (buildTemplate != null) {
                                genFilesHelper.refreshBuildScript(CommonProjectUtils.getBuildXmlName(eval, buildScriptProperty), buildTemplate, true);
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.log(Level.INFO, NbBundle.getMessage(ProjectHooks.class, "ERR_RegenerateProjectFiles"), e);
                    }
                }
            });
            HashMap<String, Set<ClassPath>> snapshot = new HashMap<String, Set<ClassPath>>();
            for (String classPathType : this.classPathTypes) {
                ClassPath[] cps = this.cpProvider.getProjectClassPaths(classPathType);
                Set newCps = Collections.newSetFromMap(new IdentityHashMap());
                Collections.addAll(newCps, cps);
                snapshot.put(classPathType, newCps);
            }
            this.updateClassPathCache(snapshot);
            AbstractClassPathProvider.ClassPathsChangeListener l = this.cpListener.get();
            if (l == null && this.cpListener.compareAndSet(null, l = (AbstractClassPathProvider.ClassPathsChangeListener)WeakListeners.create(AbstractClassPathProvider.ClassPathsChangeListener.class, this, this.cpProvider))) {
                this.cpProvider.addClassPathsChangeListener(l);
            }
            this.runAtomic(new Runnable(){

                @Override
                public void run() {
                    this.updateUserBuildPropertiesRef();
                    for (Runnable r : postOpen) {
                        ProjectHooks.runSafe(r);
                    }
                    this.saveProject();
                }
            });
            this.verifyEncoding();
        }

        @Override
        protected void projectClosed() {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    AbstractClassPathProvider.ClassPathsChangeListener l;
                    block7: {
                        for (Runnable r : preClose) {
                            ProjectHooks.runSafe(r);
                        }
                        if (project.getProjectDirectory().isValid()) {
                            try {
                                ProjectManager.getDefault().saveProject(project);
                            }
                            catch (IOException e) {
                                if (!project.getProjectDirectory().canWrite()) break block7;
                                Exceptions.printStackTrace(e);
                            }
                        }
                    }
                    if ((l = (AbstractClassPathProvider.ClassPathsChangeListener)cpListener.get()) != null && cpListener.compareAndSet(l, null)) {
                        cpProvider.removeClassPathsChangeListener(l);
                    }
                    HashMap snapshot = new HashMap();
                    for (String classPathType : classPathTypes) {
                        snapshot.put(classPathType, Collections.emptySet());
                    }
                    this.updateClassPathCache(snapshot);
                    for (Runnable r : postClose) {
                        ProjectHooks.runSafe(r);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                PROJECT_OPENED_RP.execute(r);
            } else {
                r.run();
            }
        }

        @Override
        public void classPathsChange(AbstractClassPathProvider.ClassPathsChangeEvent event) {
            HashMap<String, Set<ClassPath>> snapshot = new HashMap<String, Set<ClassPath>>();
            for (String string : event.getChangedClassPathTypes()) {
                if (!this.classPathTypes.contains(string)) continue;
                ClassPath[] cps = this.cpProvider.getProjectClassPaths(string);
                Set newCps = Collections.newSetFromMap(new IdentityHashMap());
                Collections.addAll(newCps, cps);
                snapshot.put(string, newCps);
            }
            if (!snapshot.isEmpty()) {
                this.updateClassPathCache(snapshot);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateClassPathCache(@NonNull Map<String, Set<ClassPath>> snapshot) {
            GlobalPathRegistry gpr = GlobalPathRegistry.getDefault();
            Map<String, Set<ClassPath>> map = this.cpCache;
            synchronized (map) {
                for (Map.Entry<String, Set<ClassPath>> e : snapshot.entrySet()) {
                    String id = e.getKey();
                    Set<ClassPath> newCps = e.getValue();
                    Set oldCps = this.cpCache.getOrDefault(id, Collections.emptySet());
                    Set toAdd = Collections.newSetFromMap(new IdentityHashMap());
                    toAdd.addAll(newCps);
                    toAdd.removeAll(oldCps);
                    Set toRemove = Collections.newSetFromMap(new IdentityHashMap());
                    toRemove.addAll(oldCps);
                    toRemove.removeAll(newCps);
                    this.cpCache.put(id, newCps);
                    gpr.unregister(id, toRemove.toArray(new ClassPath[toRemove.size()]));
                    gpr.register(id, toAdd.toArray(new ClassPath[toAdd.size()]));
                }
            }
        }

        private void updateUserBuildPropertiesRef() {
            EditableProperties ep = this.updateHelper.getProperties("nbproject/private/private.properties");
            File buildProperties = new File(Places.getUserDirectory(), "build.properties");
            ep.setProperty("user.properties.file", buildProperties.getAbsolutePath());
            this.updateHelper.putProperties("nbproject/private/private.properties", ep);
        }

        private void verifyEncoding() {
            String prop = this.eval.getProperty("source.encoding");
            if (prop != null) {
                try {
                    Charset.forName(prop);
                }
                catch (IllegalCharsetNameException e) {
                    LOG.log(Level.WARNING, "Illegal charset: {0} in project: {1}", new Object[]{prop, FileUtil.getFileDisplayName(this.project.getProjectDirectory())});
                }
                catch (UnsupportedCharsetException e) {
                    LOG.log(Level.WARNING, "Unsupported charset: {0} in project: {1}", new Object[]{prop, FileUtil.getFileDisplayName(this.project.getProjectDirectory())});
                }
            }
        }

        private void runAtomic(final @NonNull Runnable r) {
            FileUtil.runAtomicAction(new Runnable(){

                @Override
                public void run() {
                    ProjectManager.mutex().writeAccess(new Runnable(){

                        @Override
                        public void run() {
                            r.run();
                        }
                    });
                }
            });
        }

        private void saveProject() {
            try {
                ProjectManager.getDefault().saveProject(this.project);
            }
            catch (IOException e) {
                if (!this.project.getProjectDirectory().canWrite()) {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message(NbBundle.getMessage(ProjectHooks.class, "ERR_ProjectReadOnly", this.project.getProjectDirectory().getName()));
                    DialogDisplayer.getDefault().notify(nd);
                }
                Exceptions.printStackTrace(e);
            }
        }
    }

    public static final class ProjectXmlSavedHookBuilder {
        private final PropertyEvaluator eval;
        private final UpdateHelper updateHelper;
        private final GeneratedFilesHelper genFilesHelper;
        private final List<Runnable> preActions = new LinkedList<Runnable>();
        private final List<Runnable> postActions = new LinkedList<Runnable>();
        private String buildScriptProperty = "buildfile";
        private URL buildImplTemplate;
        private URL buildTemplate;
        private Callable<Boolean> overridePredicate;

        private ProjectXmlSavedHookBuilder(@NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper) {
            Parameters.notNull("eval", eval);
            Parameters.notNull("updateHelper", updateHelper);
            Parameters.notNull("genFilesHelper", genFilesHelper);
            this.eval = eval;
            this.updateHelper = updateHelper;
            this.genFilesHelper = genFilesHelper;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder addPreAction(@NonNull Runnable action) {
            Parameters.notNull("action", action);
            this.preActions.add(action);
            return this;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder addPostAction(@NonNull Runnable action) {
            Parameters.notNull("action", action);
            this.postActions.add(action);
            return this;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder setBuildTemplate(@NonNull URL template) {
            Parameters.notNull("template", template);
            this.buildTemplate = template;
            return this;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder setBuildImplTemplate(@NonNull URL template) {
            Parameters.notNull("template", template);
            this.buildImplTemplate = template;
            return this;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder setBuildScriptProperty(@NonNull String propertyName) {
            Parameters.notNull("propertyName", propertyName);
            this.buildScriptProperty = propertyName;
            return this;
        }

        @NonNull
        public ProjectXmlSavedHookBuilder setOverrideModifiedBuildImplPredicate(@NonNull Callable<Boolean> predicate) {
            Parameters.notNull("predicate", predicate);
            this.overridePredicate = predicate;
            return this;
        }

        @NonNull
        public ProjectXmlSavedHook build() {
            return new ProjectXmlSavedHookImpl(this.eval, this.updateHelper, this.genFilesHelper, this.preActions, this.postActions, this.buildImplTemplate, this.buildTemplate, this.buildScriptProperty, this.overridePredicate);
        }
    }

    public static final class ProjectOpenedHookBuilder {
        private final Project project;
        private final PropertyEvaluator eval;
        private final UpdateHelper updateHelper;
        private final GeneratedFilesHelper genFilesHelper;
        private final AbstractClassPathProvider cpProvider;
        private final Set<String> classPathTypes = new HashSet<String>();
        private final List<Runnable> preOpen = new LinkedList<Runnable>();
        private final List<Runnable> postOpen = new LinkedList<Runnable>();
        private final List<Runnable> preClose = new LinkedList<Runnable>();
        private final List<Runnable> postClose = new LinkedList<Runnable>();
        private String buildScriptProperty = "buildfile";
        private URL buildTemplate;
        private URL buildImplTemplate;

        private ProjectOpenedHookBuilder(@NonNull Project project, @NonNull PropertyEvaluator eval, @NonNull UpdateHelper updateHelper, @NonNull GeneratedFilesHelper genFilesHelper, @NonNull AbstractClassPathProvider cpProvider) {
            Parameters.notNull("project", project);
            Parameters.notNull("eval", eval);
            Parameters.notNull("updateHelper", updateHelper);
            Parameters.notNull("genFilesHelper", genFilesHelper);
            Parameters.notNull("cpProviderImpl", cpProvider);
            this.project = project;
            this.eval = eval;
            this.updateHelper = updateHelper;
            this.genFilesHelper = genFilesHelper;
            this.cpProvider = cpProvider;
        }

        @NonNull
        public ProjectOpenedHookBuilder addClassPathType(@NonNull String classPathType) {
            Parameters.notNull("classPathType", classPathType);
            this.classPathTypes.add(classPathType);
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder addOpenPreAction(@NonNull Runnable action) {
            Parameters.notNull("action", action);
            this.preOpen.add(action);
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder addOpenPostAction(@NonNull Runnable action) {
            Parameters.notNull("action", action);
            this.postOpen.add(action);
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder addClosePreAction(@NonNull Runnable action) {
            Parameters.notNull("action", action);
            this.preClose.add(action);
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder addClosePostAction(@NonNull Runnable action) {
            Parameters.notNull("action", action);
            this.postClose.add(action);
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder setBuildTemplate(@NonNull URL template) {
            Parameters.notNull("template", template);
            this.buildTemplate = template;
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder setBuildImplTemplate(@NonNull URL template) {
            Parameters.notNull("template", template);
            this.buildImplTemplate = template;
            return this;
        }

        @NonNull
        public ProjectOpenedHookBuilder setBuildScriptProperty(@NonNull String propertyName) {
            Parameters.notNull("propertyName", propertyName);
            this.buildScriptProperty = propertyName;
            return this;
        }

        @NonNull
        public ProjectOpenedHook build() {
            return new ProjectOpenedHookImpl(this.project, this.eval, this.updateHelper, this.genFilesHelper, this.cpProvider, this.classPathTypes, this.preOpen, this.postOpen, this.preClose, this.postClose, this.buildImplTemplate, this.buildTemplate, this.buildScriptProperty);
        }
    }
}

