/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;

public class PersistentObjectList<T extends PersistentObject> {
    private static final Logger LOGGER = Logger.getLogger(PersistentObjectManager.class.getName());
    private final Map<ElementHandle<TypeElement>, List<T>> type2Objects = new HashMap<ElementHandle<TypeElement>, List<T>>();

    public void add(List<T> objects) {
        for (PersistentObject newObject : objects) {
            List<T> list = this.type2Objects.get(newObject.getTypeElementHandle());
            if (list == null) {
                list = new ArrayList<T>();
                this.type2Objects.put(newObject.getTypeElementHandle(), list);
            }
            list.add(newObject);
        }
    }

    public boolean put(ElementHandle<TypeElement> typeHandle, List<T> objects) {
        ArrayList<PersistentObject> list = new ArrayList<PersistentObject>();
        for (PersistentObject object : objects) {
            ElementHandle<TypeElement> sourceHandle = object.getTypeElementHandle();
            if (sourceHandle.equals(typeHandle)) {
                list.add(object);
                continue;
            }
            LOGGER.log(Level.WARNING, "setObjects: ignoring object with incorrect ElementHandle {0} (expected {1})", new Object[]{sourceHandle, typeHandle});
        }
        if (list.size() > 0) {
            this.type2Objects.put(typeHandle, list);
            return true;
        }
        List<T> oldList = this.type2Objects.remove(typeHandle);
        return oldList != null;
    }

    public List<T> remove(ElementHandle<TypeElement> typeHandle) {
        return this.type2Objects.remove(typeHandle);
    }

    public void clear() {
        this.type2Objects.clear();
    }

    public List<T> get() {
        ArrayList<T> result = new ArrayList<T>(this.type2Objects.size() * 2);
        for (List<T> list : this.type2Objects.values()) {
            result.addAll(list);
        }
        return Collections.unmodifiableList(result);
    }

    public List<T> get(ElementHandle<TypeElement> typeHandle) {
        List<T> list = this.type2Objects.get(typeHandle);
        return list != null ? Collections.unmodifiableList(list) : null;
    }
}

