/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.openide.util.NbPreferences;

public class Containers {
    private static Reference<OperationContainer<InstallSupport>> INSTALL;
    private static Reference<OperationContainer<InstallSupport>> INTERNAL_UPDATE;
    private static Reference<OperationContainer<InstallSupport>> UPDATE;
    private static Reference<OperationContainer<InstallSupport>> INSTALL_FOR_NBMS;
    private static Reference<OperationContainer<InstallSupport>> UPDATE_FOR_NBMS;
    private static Reference<OperationContainer<OperationSupport>> UNINSTALL;
    private static Reference<OperationContainer<OperationSupport>> ENABLE;
    private static Reference<OperationContainer<OperationSupport>> DISABLE;
    private static Reference<OperationContainer<OperationSupport>> CUSTOM_INSTALL;
    private static Reference<OperationContainer<OperationSupport>> CUSTOM_UNINSTALL;

    private Containers() {
    }

    public static void initNotify() {
        try {
            Containers.forAvailableNbms().removeAll();
            Containers.forUpdateNbms().removeAll();
            Containers.forAvailable().removeAll();
            Containers.forUninstall().removeAll();
            Containers.forUpdate().removeAll();
            Containers.forEnable().removeAll();
            Containers.forDisable().removeAll();
            Containers.forCustomInstall().removeAll();
            Containers.forCustomUninstall().removeAll();
            Containers.forInternalUpdate().removeAll();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationContainer<InstallSupport> forAvailableNbms() {
        Class<Containers> clazz = Containers.class;
        synchronized (Containers.class) {
            OperationContainer<InstallSupport> container = null;
            if (INSTALL_FOR_NBMS != null) {
                container = INSTALL_FOR_NBMS.get();
            }
            if (container == null) {
                container = OperationContainer.createForInstall();
                INSTALL_FOR_NBMS = new WeakReference<OperationContainer<InstallSupport>>(container);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Containers.useUnpack200(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationContainer<InstallSupport> forUpdateNbms() {
        Class<Containers> clazz = Containers.class;
        synchronized (Containers.class) {
            OperationContainer<InstallSupport> container = null;
            if (UPDATE_FOR_NBMS != null) {
                container = UPDATE_FOR_NBMS.get();
            }
            if (container == null) {
                container = OperationContainer.createForUpdate();
                UPDATE_FOR_NBMS = new WeakReference<OperationContainer<InstallSupport>>(container);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Containers.useUnpack200(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationContainer<InstallSupport> forAvailable() {
        Class<Containers> clazz = Containers.class;
        synchronized (Containers.class) {
            OperationContainer<InstallSupport> container = null;
            if (INSTALL != null) {
                container = INSTALL.get();
            }
            if (container == null) {
                container = OperationContainer.createForInstall();
                INSTALL = new WeakReference<OperationContainer<InstallSupport>>(container);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Containers.useUnpack200(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationContainer<InstallSupport> forUpdate() {
        Class<Containers> clazz = Containers.class;
        synchronized (Containers.class) {
            OperationContainer<InstallSupport> container = null;
            if (UPDATE != null) {
                container = UPDATE.get();
            }
            if (container == null) {
                container = OperationContainer.createForUpdate();
                UPDATE = new WeakReference<OperationContainer<InstallSupport>>(container);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Containers.useUnpack200(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationContainer<OperationSupport> forUninstall() {
        Class<Containers> clazz = Containers.class;
        synchronized (Containers.class) {
            OperationContainer<OperationSupport> container = null;
            if (UNINSTALL != null) {
                container = UNINSTALL.get();
            }
            if (container == null) {
                container = OperationContainer.createForUninstall();
                UNINSTALL = new WeakReference<OperationContainer<OperationSupport>>(container);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Containers.useUnpack200(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationContainer<OperationSupport> forEnable() {
        Class<Containers> clazz = Containers.class;
        synchronized (Containers.class) {
            OperationContainer<OperationSupport> container = null;
            if (ENABLE != null) {
                container = ENABLE.get();
            }
            if (container == null) {
                container = OperationContainer.createForEnable();
                ENABLE = new WeakReference<OperationContainer<OperationSupport>>(container);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Containers.useUnpack200(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationContainer<OperationSupport> forDisable() {
        Class<Containers> clazz = Containers.class;
        synchronized (Containers.class) {
            OperationContainer<OperationSupport> container = null;
            if (DISABLE != null) {
                container = DISABLE.get();
            }
            if (container == null) {
                container = OperationContainer.createForDisable();
                DISABLE = new WeakReference<OperationContainer<OperationSupport>>(container);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Containers.useUnpack200(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationContainer<OperationSupport> forCustomInstall() {
        Class<Containers> clazz = Containers.class;
        synchronized (Containers.class) {
            OperationContainer<OperationSupport> container = null;
            if (CUSTOM_INSTALL != null) {
                container = CUSTOM_INSTALL.get();
            }
            if (container == null) {
                container = OperationContainer.createForCustomInstallComponent();
                CUSTOM_INSTALL = new WeakReference<OperationContainer<OperationSupport>>(container);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Containers.useUnpack200(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationContainer<OperationSupport> forCustomUninstall() {
        Class<Containers> clazz = Containers.class;
        synchronized (Containers.class) {
            OperationContainer<OperationSupport> container = null;
            if (CUSTOM_UNINSTALL != null) {
                container = CUSTOM_UNINSTALL.get();
            }
            if (container == null) {
                container = OperationContainer.createForCustomUninstallComponent();
                CUSTOM_UNINSTALL = new WeakReference<OperationContainer<OperationSupport>>(container);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Containers.useUnpack200(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationContainer<InstallSupport> forInternalUpdate() {
        Class<Containers> clazz = Containers.class;
        synchronized (Containers.class) {
            OperationContainer<InstallSupport> container = null;
            if (INTERNAL_UPDATE != null) {
                container = INTERNAL_UPDATE.get();
            }
            if (container == null) {
                container = OperationContainer.createForInternalUpdate();
                INTERNAL_UPDATE = new WeakReference<OperationContainer<InstallSupport>>(container);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Containers.useUnpack200(container);
        }
    }

    public static void defineUnpack200(File executable) {
        NbPreferences.forModule(OperationContainer.class).put("unpack200", executable.getPath());
        INSTALL.clear();
        INTERNAL_UPDATE.clear();
        UPDATE.clear();
        INSTALL_FOR_NBMS.clear();
        UPDATE_FOR_NBMS.clear();
        UNINSTALL.clear();
        ENABLE.clear();
        DISABLE.clear();
        CUSTOM_INSTALL.clear();
        CUSTOM_UNINSTALL.clear();
    }

    private static <T> OperationContainer<T> useUnpack200(OperationContainer<T> container) {
        File file;
        String pack200 = NbPreferences.forModule(OperationContainer.class).get("unpack200", null);
        if (pack200 != null && (file = new File(pack200)).canExecute()) {
            container.setUnpack200(file);
        }
        return container;
    }
}

