/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.ScaledBitmapIcon;
import org.netbeans.core.startup.TopLogging;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class Splash
implements Stamps.Updater {
    private static Splash splash;
    private static final boolean noBar;
    private static final String ICON_16 = "org/netbeans/core/startup/frame.gif";
    private static final String ICON_32 = "org/netbeans/core/startup/frame32.gif";
    private static final String ICON_48 = "org/netbeans/core/startup/frame48.gif";
    private static final String ICON_256 = "org/netbeans/core/startup/frame256.png";
    private static final String ICON_512 = "org/netbeans/core/startup/frame512.png";
    private static final String ICON_1024 = "org/netbeans/core/startup/frame1024.png";
    private Frame frame;
    private SplashPainter painter;
    private SplashComponent comp;
    private SplashScreen splashScreen;
    private static final boolean USE_LAUNCHER_SPLASH = false;

    public static Splash getInstance() {
        if (splash == null) {
            splash = new Splash();
        }
        return splash;
    }

    public static void showAboutDialog(Frame parent, JComponent info) {
        Splash.createAboutDialog(parent, info).setVisible(true);
    }

    private static JDialog createAboutDialog(Frame parent, JComponent info) {
        SplashDialog splashDialog = new SplashDialog(parent, info);
        return splashDialog;
    }

    private void initFrameIcons(Frame f) {
        f.setIconImages(Arrays.asList(ImageUtilities.loadImage(ICON_16, true), ImageUtilities.loadImage(ICON_32, true), ImageUtilities.loadImage(ICON_48, true), ImageUtilities.loadImage(ICON_256, true), ImageUtilities.loadImage(ICON_512, true), ImageUtilities.loadImage(ICON_1024, true)));
    }

    private Splash() {
        Stamps s = Stamps.getModulesJARs();
        if (!CLIOptions.isNoSplash() && !GraphicsEnvironment.isHeadless()) {
            try {
                this.splashScreen = SplashScreen.getSplashScreen();
                if (this.splashScreen != null) {
                    Graphics2D graphics = this.splashScreen.createGraphics();
                    this.painter = new SplashPainter(graphics, null, false);
                }
            }
            catch (RuntimeException x) {
                Exceptions.printStackTrace(x);
            }
            if (this.painter == null) {
                this.comp = new SplashComponent(false);
                this.painter = this.comp.painter;
            }
        }
    }

    final int getMaxSteps() {
        return this.painter.maxSteps;
    }

    final int getProgress() {
        return this.painter.progress;
    }

    public void setRunning(boolean running) {
        if (CLIOptions.isNoSplash()) {
            return;
        }
        if (this.comp == null) {
            return;
        }
        if (running) {
            if (this.frame == null) {
                this.frame = new Frame(NbBundle.getMessage(Splash.class, "LBL_splash_window_title"));
                this.frame.setType(Window.Type.POPUP);
                this.initFrameIcons(this.frame);
                this.frame.setUndecorated(true);
                this.frame.setLayout(new BorderLayout());
                this.frame.add((Component)this.comp, "Center");
                this.frame.setResizable(false);
                int width = Integer.parseInt(NbBundle.getMessage(Splash.class, "SPLASH_WIDTH"));
                int height = Integer.parseInt(NbBundle.getMessage(Splash.class, "SPLASH_HEIGHT"));
                this.frame.setPreferredSize(new Dimension(width, height));
                SwingUtilities.invokeLater(new SplashRunner(this.frame, true));
            }
        } else {
            SwingUtilities.invokeLater(new SplashRunner(this.frame, false));
        }
    }

    public void dispose() {
        this.setRunning(false);
        splash = null;
    }

    public void increment(int steps) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.painter != null) {
            this.painter.increment(steps);
        }
    }

    public Component getComponent() {
        return this.comp;
    }

    public void print(String s) {
        if (CLIOptions.isNoSplash() || this.painter == null) {
            return;
        }
        this.painter.setText(s);
    }

    public void addToMaxSteps(int steps) {
        if (noBar || CLIOptions.isNoSplash()) {
            return;
        }
        if (this.painter != null) {
            this.painter.addToMaxSteps(steps);
        }
    }

    static void center(Window c) {
        c.pack();
        c.setBounds(Utilities.findCenterBounds(c.getSize()));
    }

    public static Image loadContent(boolean about) {
        return ImageUtilities.icon2Image(Splash.loadContentIcon(about));
    }

    private static Icon loadContentIcon(boolean about) {
        Image ret = null;
        if (about) {
            ret = ImageUtilities.loadImage("org/netbeans/core/startup/about.png", true);
        }
        if (ret == null) {
            ret = ImageUtilities.loadImage("org/netbeans/core/startup/splash.gif", true);
        }
        if (ret == null) {
            return null;
        }
        return new ScaledBitmapIcon(ret, Integer.parseInt(NbBundle.getMessage(Splash.class, "SPLASH_WIDTH")), Integer.parseInt(NbBundle.getMessage(Splash.class, "SPLASH_HEIGHT")));
    }

    @Override
    public void flushCaches(DataOutputStream os) throws IOException {
        ImageIO.write((RenderedImage)((BufferedImage)Splash.loadContent(false)), "png", os);
    }

    @Override
    public void cacheReady() {
    }

    static {
        noBar = Boolean.getBoolean("netbeans.splash.nobar") || !Boolean.parseBoolean(NbBundle.getMessage(Splash.class, "SplashShowProgressBar"));
    }

    private static class SplashRunner
    implements Runnable {
        private Window splashWindow;
        private boolean visible;

        public SplashRunner(Window splashWindow, boolean visible) {
            this.splashWindow = splashWindow;
            this.visible = visible;
        }

        @Override
        public void run() {
            if (this.visible) {
                Splash.center(this.splashWindow);
                this.splashWindow.setVisible(true);
                this.splashWindow.toFront();
            } else {
                this.splashWindow.setVisible(false);
                this.splashWindow.dispose();
            }
        }
    }

    private static class SplashDialog
    extends JDialog
    implements ActionListener {
        static final long serialVersionUID = 5185644855500178404L;
        private final SplashComponent splashComponent = new SplashComponent(true);

        public SplashDialog(Frame parent, JComponent infoPanel) {
            super(parent, true);
            JPanel splashPanel = new JPanel();
            JTabbedPane tabbedPane = new JTabbedPane();
            this.setTitle(NbBundle.getMessage(Splash.class, "CTL_About_Title"));
            splashPanel.add(this.splashComponent);
            tabbedPane.addTab(NbBundle.getMessage(Splash.class, "CTL_About_Title"), splashPanel);
            tabbedPane.addTab(NbBundle.getMessage(Splash.class, "CTL_About_Detail"), infoPanel);
            this.getContentPane().add((Component)tabbedPane, "Center");
            this.getRootPane().registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 1);
            tabbedPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Splash.class, "ACSN_AboutTabs"));
            tabbedPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, "ACSD_AboutTabs"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Splash.class, "ACSD_AboutDialog"));
            Splash.center(this);
            this.setDefaultCloseOperation(2);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class SplashPainter {
        TextBox statusBox;
        TextBox versionBox;
        Color color_bar;
        Color color_edge;
        Color color_corner;
        private Rectangle dirty = new Rectangle();
        private Rectangle bar = new Rectangle();
        private Rectangle bar_inc = new Rectangle();
        private int progress = 0;
        private int maxSteps = 0;
        private int barStart = 0;
        private int barLength = 0;
        private Icon image;
        private String text;
        private Graphics2D graphics;
        private final JComponent comp;
        private final boolean about;
        long next;

        public SplashPainter(Graphics graphics, JComponent comp, boolean about) {
            this.graphics = (Graphics2D)graphics;
            this.comp = comp;
            this.about = about;
        }

        final void init() throws MissingResourceException, NumberFormatException {
            assert (SwingUtilities.isEventDispatchThread());
            if (this.statusBox != null) {
                return;
            }
            this.maxSteps = 140;
            ResourceBundle bundle = NbBundle.getBundle(Splash.class);
            this.statusBox = TextBox.parse(this.graphics, this.comp, bundle, "SplashRunningText", false);
            this.versionBox = TextBox.parse(this.graphics, this.comp, bundle, "SplashVersionText", true);
            StringTokenizer st = new StringTokenizer(bundle.getString("SplashProgressBarBounds"), " ,");
            try {
                this.bar = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
                Integer rgb = Integer.decode(bundle.getString("SplashProgressBarColor"));
                this.color_bar = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarEdgeColor"));
                this.color_edge = new Color(rgb);
                rgb = Integer.decode(bundle.getString("SplashProgressBarCornerColor"));
                this.color_corner = new Color(rgb);
            }
            catch (NumberFormatException nfe) {
                Util.err.warning("Number format exception loading splash screen parameters.");
                Logger.getLogger("global").log(Level.WARNING, null, nfe);
                this.color_bar = Color.ORANGE;
                this.color_edge = Color.BLUE;
                this.color_corner = Color.GREEN;
                this.bar = new Rectangle(0, 0, 80, 10);
            }
            this.image = Splash.loadContentIcon(this.about);
            if (this.comp != null) {
                this.comp.setFont(this.statusBox.font);
            }
        }

        final void repaint(Rectangle r) {
            if (this.comp != null) {
                this.comp.repaint(r);
            } else if (this.next < System.currentTimeMillis()) {
                this.paint();
                try {
                    Splash s = splash;
                    if (s != null) {
                        s.splashScreen.update();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.next = System.currentTimeMillis() + 200L;
            }
        }

        public void setText(final String text) {
            if (text != null && text.equals(this.text)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.init();
                    if (text == null) {
                        this.repaint(dirty);
                        return;
                    }
                    if (statusBox.fm == null) {
                        return;
                    }
                    this.adjustText(text);
                    statusBox.layout(text, null);
                    dirty = dirty.union(statusBox.effectiveBounds);
                    this.repaint(dirty);
                    dirty = new Rectangle(statusBox.effectiveBounds);
                }
            });
        }

        private void adjustText(String text) {
            String newText = null;
            if (text == null) {
                return;
            }
            if (this.statusBox.fm == null) {
                return;
            }
            int width = this.statusBox.fm.stringWidth(text);
            if (width > this.statusBox.bounds.width) {
                String newString;
                StringTokenizer st = new StringTokenizer(text);
                while (st.hasMoreTokens()) {
                    String element = st.nextToken();
                    newString = newText == null ? element : newText + " " + element;
                    if (this.statusBox.fm.stringWidth(newString + "...") > this.statusBox.bounds.width) {
                        this.text = newText + "...";
                        break;
                    }
                    newText = newString;
                }
                if (newText == null) {
                    this.text = "";
                    newString = "";
                    newText = "";
                    for (int i = 0; i < text.length(); ++i) {
                        if (this.statusBox.fm.stringWidth((newString = newString + text.charAt(i)) + "...") > this.statusBox.bounds.width) {
                            this.text = newText + "...";
                            break;
                        }
                        newText = newString;
                    }
                }
            } else {
                this.text = text;
            }
        }

        public void increment(int steps) {
            int bl;
            if (steps <= 0) {
                return;
            }
            this.progress += steps;
            if (this.progress > this.maxSteps) {
                this.progress = this.maxSteps;
            } else if (this.maxSteps > 0 && ((bl = this.bar.width * this.progress / this.maxSteps - this.barStart) > 1 || this.barStart % 2 == 0)) {
                this.barLength = bl;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.init();
                        this.repaint(bar);
                    }
                });
            }
        }

        final void addToMaxSteps(int steps) {
            if (steps == 0) {
                return;
            }
            if (this.maxSteps == 0) {
                int prog = this.progress / steps;
                this.maxSteps = steps;
                this.progress = prog;
            } else {
                int max = this.maxSteps + steps;
                int prog = this.progress * max / this.maxSteps;
                this.maxSteps = max;
                this.progress = prog;
            }
        }

        void paint() {
            if (this.image != null) {
                this.image.paintIcon(this.comp, this.graphics, 0, 0);
            }
            this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (this.versionBox != null) {
                String buildNumber = System.getProperty("netbeans.buildnumber");
                this.versionBox.layout(NbBundle.getMessage(TopLogging.class, "currentVersion", buildNumber), this.graphics);
            }
            if (this.text != null) {
                this.statusBox.layout(this.text, this.graphics);
            }
            if (!noBar && this.maxSteps > 0) {
                this.graphics.setColor(this.color_bar);
                this.graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
                if (!this.color_bar.equals(this.color_corner)) {
                    this.graphics.setColor(this.color_corner);
                    this.graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
                    this.graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
                }
                if (!this.color_bar.equals(this.color_edge)) {
                    this.graphics.setColor(this.color_edge);
                    this.graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
                    this.graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
                }
                this.barStart += this.barLength;
                this.barLength = 0;
            }
        }
    }

    private static final class TextBox {
        final Rectangle bounds;
        final Color color;
        final int textSize;
        final Font font;
        final FontMetrics fm;
        final int horizontalAlignment;
        final Rectangle effectiveBounds = new Rectangle();

        private TextBox(Rectangle bounds, Color color, int textSize, Font font, FontMetrics fontMetrics, int horizontalAlignment) {
            this.bounds = bounds;
            this.color = color;
            this.textSize = textSize;
            this.font = font;
            this.fm = fontMetrics;
            this.horizontalAlignment = horizontalAlignment;
        }

        public void layout(String text, Graphics graphics) {
            if (this.fm == null) {
                return;
            }
            SwingUtilities.layoutCompoundLabel(this.fm, text, null, 3, this.horizontalAlignment, 3, this.horizontalAlignment, this.bounds, new Rectangle(), this.effectiveBounds, 0);
            if (graphics != null) {
                graphics.setColor(this.color);
                graphics.setFont(this.font);
                graphics.drawString(text, this.effectiveBounds.x, this.effectiveBounds.y + this.fm.getAscent());
            }
        }

        public static TextBox parse(Graphics graphics, JComponent comp, ResourceBundle bundle, String prefix, boolean optional) {
            if (optional && !bundle.containsKey(prefix + "Bounds")) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(bundle.getString(prefix + "Bounds"), " ,");
            Rectangle bounds = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            Color color = Color.BLACK;
            try {
                Integer rgb = Integer.decode(bundle.getString(prefix + "Color"));
                color = new Color(rgb);
            }
            catch (NumberFormatException nfe) {
                Util.err.warning("Number format exception loading splash screen parameters.");
                Logger.getLogger("global").log(Level.WARNING, null, nfe);
            }
            int size = 12;
            try {
                String sizeStr = bundle.getString(prefix + "FontSize");
                size = Integer.parseInt(sizeStr);
            }
            catch (MissingResourceException sizeStr) {
            }
            catch (NumberFormatException sizeStr) {
                // empty catch block
            }
            int horizontalAlignment = 2;
            try {
                switch (bundle.getString(prefix + "HorizontalAlignment").toLowerCase(Locale.US)) {
                    case "left": {
                        horizontalAlignment = 2;
                        break;
                    }
                    case "center": {
                        horizontalAlignment = 0;
                        break;
                    }
                    case "right": {
                        horizontalAlignment = 4;
                        break;
                    }
                    default: {
                        Util.err.warning("Invalid horizontal alignment for splash screen text box");
                        break;
                    }
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            Font font = new Font(bundle.getString(prefix + "FontType"), 0, size);
            FontMetrics fontMetrics = comp != null ? comp.getFontMetrics(font) : graphics.getFontMetrics(font);
            return new TextBox(bounds, color, size, font, fontMetrics, horizontalAlignment);
        }
    }

    private static class SplashComponent
    extends JComponent
    implements Accessible {
        final SplashPainter painter;

        public SplashComponent(boolean about) {
            this.painter = new SplashPainter((Graphics2D)this.getGraphics(), this, about);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics graphics) {
            this.painter.graphics = (Graphics2D)graphics;
            this.painter.paint();
        }

        @Override
        public boolean isOpaque() {
            return true;
        }

        @Override
        public String toString() {
            return "SplashComponent - progress: " + this.painter.progress + "/" + this.painter.maxSteps + " text: " + this.painter.text;
        }
    }
}

