/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.net.URL;
import java.security.CodeSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Events;
import org.netbeans.InvalidException;
import org.netbeans.ModuleData;
import org.netbeans.ModuleManager;
import org.netbeans.NbInstrumentation;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Enumerations;
import org.openide.util.Exceptions;
import org.openide.util.Union2;

public abstract class Module
extends ModuleInfo {
    public static final String PROP_RELOADABLE = "reloadable";
    public static final String PROP_CLASS_LOADER = "classLoader";
    public static final String PROP_MANIFEST = "manifest";
    public static final String PROP_VALID = "valid";
    public static final String PROP_PROBLEMS = "problems";
    protected final ModuleManager mgr;
    protected final Events events;
    private final Object history;
    private boolean enabled;
    private final boolean autoload;
    protected boolean reloadable;
    private final boolean eager;
    protected ClassLoader classloader;
    private ModuleData data;
    private NbInstrumentation instr;
    private static final Object DATA_LOCK = new Object();

    protected Module(ModuleManager mgr, Events ev, Object history, boolean reloadable, boolean autoload, boolean eager) throws IOException {
        if (autoload && eager) {
            throw new IllegalArgumentException("A module may not be both autoload and eager");
        }
        this.mgr = mgr;
        this.events = ev;
        this.history = history;
        this.reloadable = reloadable;
        this.autoload = autoload;
        this.eager = eager;
        this.enabled = false;
    }

    protected Module(ModuleManager mgr, Events ev, Object history, ClassLoader classloader) throws InvalidException {
        this(mgr, ev, history, classloader, false, false);
    }

    protected Module(ModuleManager mgr, Events ev, Object history, ClassLoader classloader, boolean autoload, boolean eager) throws InvalidException {
        if (autoload && eager) {
            throw new IllegalArgumentException("A module may not be both autoload and eager");
        }
        this.mgr = mgr;
        this.events = ev;
        this.history = history;
        this.classloader = classloader;
        this.reloadable = false;
        this.autoload = autoload;
        this.eager = eager;
        this.enabled = false;
    }

    ModuleData createData(ObjectInput in, Manifest mf) throws IOException {
        if (in != null) {
            return new ModuleData(in);
        }
        return new ModuleData(mf, this);
    }

    final void writeData(ObjectOutput out) throws IOException {
        this.data().write(out);
    }

    final ModuleData data() {
        try {
            return this.dataWithCheck();
        }
        catch (InvalidException ex) {
            throw new IllegalStateException(ex);
        }
    }

    final ModuleData dataWithCheck() throws InvalidException {
        Object object = DATA_LOCK;
        synchronized (object) {
            if (this.data != null) {
                return this.data;
            }
            Util.err.log(Level.FINE, "Initialize data {0}", this.getJarFile());
            InputStream is = this.mgr.dataFor(this.getJarFile());
            if (is != null) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(is);
                    ModuleData mine = this.createData(ois, null);
                    ois.close();
                    assert (this.data == null);
                    this.data = mine;
                    return mine;
                }
                catch (IOException ex) {
                    Util.err.log(Level.INFO, "Cannot read cache for " + this.getJarFile(), ex);
                }
            }
            try {
                ModuleData mine = this.createData(null, this.getManifest());
                assert (mine == this.data);
                return mine;
            }
            catch (InvalidException ex) {
                throw ex;
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    final void assignData(ModuleData data) {
        assert (Thread.holdsLock(DATA_LOCK));
        this.data = data;
    }

    public ModuleManager getManager() {
        return this.mgr;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    void setEnabled(boolean enabled) {
        if (this.isFixed() && !enabled) {
            throw new IllegalStateException("Cannot disable a fixed module: " + this);
        }
        this.enabled = enabled;
    }

    public boolean isValid() {
        return this.mgr.get(this.getCodeNameBase()) == this;
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public boolean isEager() {
        return this.eager;
    }

    @Override
    public Object getAttribute(String attr) {
        return this.getManifest().getMainAttributes().getValue(attr);
    }

    @Override
    public String getCodeName() {
        return this.data().getCodeName();
    }

    String getFragmentHostCodeName() {
        String fragmentHostCodeName = this.mgr.fragmentFor(this.getJarFile());
        if (fragmentHostCodeName != null) {
            return fragmentHostCodeName.isEmpty() ? null : fragmentHostCodeName;
        }
        try {
            fragmentHostCodeName = this.data().getFragmentHostCodeName();
        }
        catch (IllegalStateException ex) {
            fragmentHostCodeName = null;
        }
        return fragmentHostCodeName;
    }

    @Override
    public String getCodeNameBase() {
        String cnb = this.mgr.cnbFor(this.getJarFile());
        if (cnb != null) {
            return cnb;
        }
        return this.data().getCodeNameBase();
    }

    @Override
    public int getCodeNameRelease() {
        return this.data().getCodeNameRelease();
    }

    @Override
    public String[] getProvides() {
        return this.data().getProvides();
    }

    public final boolean provides(String token) {
        String[] provides = this.getProvides();
        if (provides == null) {
            return false;
        }
        for (int i = 0; i < provides.length; ++i) {
            if (!provides[i].equals(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Dependency> getDependencies() {
        return new HashSet<Dependency>(Arrays.asList(this.getDependenciesArray()));
    }

    public final Dependency[] getDependenciesArray() {
        Dependency[] dependenciesA;
        try {
            dependenciesA = this.data().getDependencies();
        }
        catch (IllegalStateException ex) {
            dependenciesA = null;
        }
        return dependenciesA == null ? new Dependency[]{} : dependenciesA;
    }

    @Override
    public SpecificationVersion getSpecificationVersion() {
        return this.data().getSpecificationVersion();
    }

    @Override
    public String getImplementationVersion() {
        return this.data().getImplementationVersion();
    }

    @Override
    public String getBuildVersion() {
        return this.data().getBuildVersion();
    }

    @Override
    public boolean owns(Class<?> clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl instanceof Util.ModuleProvider) {
            return ((Util.ModuleProvider)((Object)cl)).getModule() == this;
        }
        if (cl != this.classloader) {
            return false;
        }
        String _codeName = Module.findClasspathModuleCodeName(clazz);
        if (_codeName != null) {
            return _codeName.equals(this.getCodeName());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String findClasspathModuleCodeName(Class<?> clazz) {
        CodeSource src = clazz.getProtectionDomain().getCodeSource();
        if (src != null) {
            String string;
            URL loc = src.getLocation();
            if (loc.toString().matches(".+\\.jar")) {
                loc = new URL("jar:" + loc + "!/");
            }
            URL manifest = new URL(loc, "META-INF/MANIFEST.MF");
            InputStream is = manifest.openStream();
            try {
                string = new Manifest(is).getMainAttributes().getValue("OpenIDE-Module");
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException x) {
                    Logger.getLogger(Module.class.getName()).log(Level.FINE, null, x);
                }
            }
            is.close();
            return string;
        }
        return null;
    }

    public PackageExport[] getPublicPackages() {
        return this.data().getPublicPackages();
    }

    boolean isDeclaredAsFriend(Module module) {
        Set<String> friendNames = this.data().getFriendNames();
        if (friendNames == null) {
            return true;
        }
        return friendNames.contains(module.getCodeNameBase());
    }

    protected void parseManifest() throws InvalidException {
        this.data();
    }

    public abstract List<File> getAllJars();

    public boolean isReloadable() {
        return this.reloadable;
    }

    public abstract void setReloadable(boolean var1);

    public abstract void reload() throws IOException;

    @Override
    public ClassLoader getClassLoader() throws IllegalArgumentException {
        if (!this.enabled) {
            throw new IllegalArgumentException("Not enabled: " + this.getCodeNameBase());
        }
        assert (this.classloader != null) : "Should have had a non-null loader for " + this;
        return this.classloader;
    }

    protected abstract void classLoaderUp(Set<Module> var1) throws IOException;

    protected abstract void classLoaderDown();

    protected abstract void cleanup();

    protected abstract void destroy();

    public abstract boolean isFixed();

    public File getJarFile() {
        return null;
    }

    public abstract Manifest getManifest();

    public void releaseManifest() {
    }

    public Set<Object> getProblems() {
        if (!this.isValid()) {
            throw new IllegalStateException("Not valid: " + this);
        }
        if (this.isEnabled()) {
            return Collections.emptySet();
        }
        HashSet<Object> problems = new HashSet<Object>();
        for (Union2<Dependency, InvalidException> problem : this.mgr.missingDependencies(this)) {
            if (problem.hasFirst()) {
                problems.add(problem.first());
                continue;
            }
            problems.add(problem.second());
        }
        return problems;
    }

    final void firePropertyChange0(String prop, Object old, Object nue) {
        if (Util.err.isLoggable(Level.FINE)) {
            Util.err.log(Level.FINE, "Module.propertyChange: {0} {1}: {2} -> {3}", new Object[]{this, prop, old, nue});
        }
        this.firePropertyChange(prop, old, nue);
    }

    public final Object getHistory() {
        return this.history;
    }

    public final int getStartLevel() {
        return this.getStartLevelImpl();
    }

    int getStartLevelImpl() {
        return -1;
    }

    public String toString() {
        String s = "Module:" + this.getCodeNameBase();
        if (!this.isValid()) {
            s = s + "[invalid]";
        }
        return s;
    }

    public Enumeration<URL> findResources(String resources) {
        try {
            ClassLoader cl = this.getClassLoader();
            if (cl instanceof ProxyClassLoader) {
                return ((ProxyClassLoader)cl).findResources(resources);
            }
            throw new IllegalStateException("Unexpected ClassLoader: " + cl + ".");
        }
        catch (Exception x) {
            Exceptions.printStackTrace(x);
            return Enumerations.empty();
        }
    }

    void refineDependencies(Set<Dependency> dependencies) {
        this.mgr.refineDependencies(this, dependencies);
    }

    void registerCoveredPackages(Set<String> known) {
        this.data().registerCoveredPackages(known);
    }

    Set<String> getCoveredPackages() {
        return this.data().getCoveredPackages();
    }

    public final boolean isNetigso() {
        return this.isNetigsoImpl();
    }

    boolean isNetigsoImpl() {
        return false;
    }

    final void assignInstrumentation(NbInstrumentation agent) {
        this.instr = agent;
    }

    void unregisterInstrumentation() {
        NbInstrumentation.unregisterAgent(this.instr);
    }

    public static final class PackageExport {
        public final String pkg;
        public final boolean recursive;

        public PackageExport(String pkg, boolean recursive) {
            this.pkg = pkg;
            this.recursive = recursive;
        }

        public String toString() {
            return "PackageExport[" + this.pkg + (this.recursive ? "**/" : "") + "]";
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PackageExport)) {
                return false;
            }
            PackageExport other = (PackageExport)obj;
            return this.pkg.equals(other.pkg) && this.recursive == other.recursive;
        }

        public int hashCode() {
            return this.pkg.hashCode();
        }

        static void write(DataOutput dos, PackageExport[] arr) throws IOException {
            if (arr == null) {
                dos.writeInt(0);
                return;
            }
            dos.writeInt(arr.length);
            for (PackageExport pe : arr) {
                dos.writeUTF(pe.pkg);
                dos.writeBoolean(pe.recursive);
            }
        }

        static PackageExport[] read(DataInput is) throws IOException {
            int cnt = is.readInt();
            if (cnt == 0) {
                return null;
            }
            PackageExport[] arr = new PackageExport[cnt];
            for (int i = 0; i < cnt; ++i) {
                String pkg = is.readUTF();
                boolean recursive = is.readBoolean();
                arr[i] = new PackageExport(pkg, recursive);
            }
            return arr;
        }
    }
}

