/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;

class TemplateAttributesProviderImpl
implements CreateFromTemplateAttributesProvider {
    private final AntProjectHelper helper;
    private final FileEncodingQueryImplementation encodingQuery;
    private static final Logger LOG = Logger.getLogger(TemplateAttributesProviderImpl.class.getName());

    public TemplateAttributesProviderImpl(AntProjectHelper helper, FileEncodingQueryImplementation encodingQuery) {
        this.helper = helper;
        this.encodingQuery = encodingQuery;
    }

    @Override
    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
        Charset charset;
        String encoding;
        String license;
        HashMap<String, String> values = new HashMap<String, String>();
        EditableProperties priv = this.helper.getProperties("nbproject/private/private.properties");
        EditableProperties props = this.helper.getProperties("nbproject/project.properties");
        String licensePath = priv.getProperty("project.licensePath");
        if (licensePath == null) {
            licensePath = props.getProperty("project.licensePath");
        }
        if (licensePath != null && (licensePath = this.helper.getStandardPropertyEvaluator().evaluate(licensePath)) != null) {
            File path = FileUtil.normalizeFile(this.helper.resolveFile(licensePath));
            if (path.exists() && path.isAbsolute()) {
                URI uri = Utilities.toURI(path);
                licensePath = uri.toString();
                values.put("licensePath", licensePath);
            } else {
                LOG.log(Level.INFO, "project.licensePath value not accepted - " + licensePath);
            }
        }
        if ((license = priv.getProperty("project.license")) == null) {
            license = props.getProperty("project.license");
        }
        if (license != null) {
            values.put("license", license);
        }
        String string = encoding = (charset = this.encodingQuery.getEncoding(target.getPrimaryFile())) != null ? charset.name() : null;
        if (encoding != null) {
            values.put("encoding", encoding);
        }
        try {
            Project prj = ProjectManager.getDefault().findProject(this.helper.getProjectDirectory());
            ProjectInformation info = ProjectUtils.getInformation(prj);
            if (info != null) {
                String pdname;
                String pname = info.getName();
                if (pname != null) {
                    values.put("name", pname);
                }
                if ((pdname = info.getDisplayName()) != null) {
                    values.put("displayName", pdname);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TemplateAttributesProviderImpl.class.getName()).log(Level.FINE, "", ex);
        }
        if (values.isEmpty()) {
            return null;
        }
        return Collections.singletonMap("project", values);
    }
}

