/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletRequest;
import org.apache.myfaces.portlet.faces.util.map.PortletAbstractMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRequestParameterMap
extends PortletAbstractMap<String> {
    private final PortletRequest mPortletRequest;
    private final Map<String, String> mInternalAttributes;

    public PortletRequestParameterMap(Object request, Map<String, String> internal) {
        if (request instanceof PortletRequest) {
            this.mPortletRequest = (PortletRequest)request;
            this.mInternalAttributes = internal == null ? Collections.emptyMap() : new HashMap<String, String>(internal);
        } else {
            throw new IllegalArgumentException("Only supported in a portlet environment");
        }
    }

    @Override
    public String getAttribute(String key) {
        if (this.mPortletRequest != null) {
            String value = this.mPortletRequest.getParameter(key);
            if (value != null) {
                return value;
            }
            return this.mInternalAttributes.get(key);
        }
        throw new IllegalArgumentException("Only supported in a portlet environment");
    }

    @Override
    public void setAttribute(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAttribute(String key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        if (this.mPortletRequest != null) {
            ArrayList attrNames = new ArrayList(5);
            Enumeration requestAttrNames = this.mPortletRequest.getParameterNames();
            while (requestAttrNames.hasMoreElements()) {
                attrNames.add(requestAttrNames.nextElement());
            }
            attrNames.addAll(this.mInternalAttributes.keySet());
            return Collections.enumeration(attrNames);
        }
        throw new IllegalArgumentException("Only supported in a portlet environment");
    }
}

