/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.util.config;

import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.portlet.PortletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigurationProcessor {
    private static final String FACES_CONFIG_METAINF_PATH = "META-INF/faces-config.xml";
    private static final String FACES_CONFIG_WEBINF_PATH = "/WEB-INF/faces-config.xml";
    private List<String> mExcludedAttributes = null;

    public FacesConfigurationProcessor(PortletContext context) {
        if (context != null) {
            this.scanForFacesMappings(context);
        }
    }

    public List<String> getExcludedAttributes() {
        return this.mExcludedAttributes;
    }

    private void scanForFacesMappings(PortletContext context) {
        SAXParserFactory factory = this.getSAXFactory();
        try {
            SAXParser parser = factory.newSAXParser();
            FacesConfigXmlHandler handler = null;
            ClassLoader cl = this.getCurrentClassLoader(context);
            Enumeration<URL> items = cl.getResources(FACES_CONFIG_METAINF_PATH);
            while (items.hasMoreElements()) {
                URL nextElement = items.nextElement();
                if (handler == null) {
                    handler = new FacesConfigXmlHandler();
                } else {
                    handler.reset();
                }
                parser.parse(nextElement.openStream(), (DefaultHandler)handler);
            }
            InputStream configStream = context.getResourceAsStream(FACES_CONFIG_WEBINF_PATH);
            if (configStream != null) {
                parser.parse(configStream, (DefaultHandler)handler);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ClassLoader getCurrentClassLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    private SAXParserFactory getSAXFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        return factory;
    }

    private class FacesConfigXmlHandler
    extends DefaultHandler {
        private static final String APPLICATION_ELEMENT = "application";
        private static final String APP_EXTENSION_ELEMENT = "application-extension";
        private static final String EXCLUDED_ATTRIBUTES_ELEMENT = "excluded-attributes";
        private static final String EXCLUDED_ATTRIBUTE_ELEMENT = "excluded-attribute";
        private boolean mInApplicationElement = false;
        private boolean mInApplicationExtensionElement = false;
        private boolean mInExcludedAttributesElement = false;
        private StringBuilder mContent;

        private FacesConfigXmlHandler() {
        }

        public void reset() {
            this.mInExcludedAttributesElement = false;
            this.mInApplicationExtensionElement = false;
            this.mInApplicationElement = false;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (APPLICATION_ELEMENT.equals(localName)) {
                this.mInApplicationElement = true;
            } else if (APP_EXTENSION_ELEMENT.equals(localName)) {
                this.mInApplicationExtensionElement = true;
            } else if (EXCLUDED_ATTRIBUTES_ELEMENT.equals(localName)) {
                this.mInExcludedAttributesElement = true;
            } else if (EXCLUDED_ATTRIBUTE_ELEMENT.equals(localName) && this.mInApplicationElement && this.mInApplicationExtensionElement && this.mInExcludedAttributesElement) {
                this.mContent = new StringBuilder();
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mContent != null) {
                this.mContent.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (APPLICATION_ELEMENT.equals(localName)) {
                this.mInApplicationElement = false;
            } else if (APP_EXTENSION_ELEMENT.equals(localName)) {
                this.mInApplicationExtensionElement = false;
            } else if (EXCLUDED_ATTRIBUTES_ELEMENT.equals(localName)) {
                this.mInExcludedAttributesElement = false;
            } else if (EXCLUDED_ATTRIBUTE_ELEMENT.equals(localName) && this.mContent != null && this.mContent.length() > 0) {
                String excludedAttribute = this.mContent.toString().trim();
                if (FacesConfigurationProcessor.this.mExcludedAttributes == null) {
                    FacesConfigurationProcessor.this.mExcludedAttributes = new ArrayList(5);
                }
                if (!FacesConfigurationProcessor.this.mExcludedAttributes.contains(excludedAttribute)) {
                    FacesConfigurationProcessor.this.mExcludedAttributes.add(excludedAttribute);
                }
            }
            this.mContent = null;
        }
    }
}

