"use strict";
/*! Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const mocha_1 = require("mocha");
const chai_1 = require("chai");
const StandardInits_1 = require("../frameworkBase/_ext/shared/StandardInits");
var defaultMyFaces = StandardInits_1.StandardInits.defaultMyFaces;
const OamSubmit_1 = require("../../myfaces/OamSubmit");
var setHiddenInput = OamSubmit_1.oam.setHiddenInput;
const mona_dish_1 = require("mona-dish");
var clearHiddenInput = OamSubmit_1.oam.clearHiddenInput;
var submitForm = OamSubmit_1.oam.submitForm;
const sinon_1 = __importDefault(require("sinon"));
/**
 * specialized tests testing the xhr core behavior when it hits the xmlHttpRequest object
 */
(0, mocha_1.describe)('Tests on the xhr core when it starts to call the request', function () {
    beforeEach(() => {
        return defaultMyFaces();
    });
    (0, mocha_1.it)('namespace must exist', function () {
        var _a, _b, _c;
        (0, chai_1.expect)(!!(myfaces === null || myfaces === void 0 ? void 0 : myfaces.oam)).to.eq(true);
        (0, chai_1.expect)(!!((_a = myfaces === null || myfaces === void 0 ? void 0 : myfaces.oam) === null || _a === void 0 ? void 0 : _a.setHiddenInput)).to.eq(true);
        (0, chai_1.expect)(!!((_b = myfaces === null || myfaces === void 0 ? void 0 : myfaces.oam) === null || _b === void 0 ? void 0 : _b.clearHiddenInput)).to.eq(true);
        (0, chai_1.expect)(!!((_c = myfaces === null || myfaces === void 0 ? void 0 : myfaces.oam) === null || _c === void 0 ? void 0 : _c.submitForm)).to.eq(true);
    });
    (0, mocha_1.it)('hidden input setting must work', function () {
        let FORM_ID = "blarg";
        setHiddenInput(FORM_ID, "new_hidden", "hiddenvalue");
        (0, chai_1.expect)(mona_dish_1.DomQuery.byId(FORM_ID).querySelectorAll("input[name='new_hidden']").isPresent());
        (0, chai_1.expect)(mona_dish_1.DomQuery.byId(FORM_ID).querySelectorAll("input[name='new_hidden']").inputValue.value).to.eq("hiddenvalue");
    });
    (0, mocha_1.it)('resetting the hidden input must work', function () {
        let FORM_ID = "blarg";
        setHiddenInput(FORM_ID, "new_hidden", "hiddenvalue");
        clearHiddenInput(FORM_ID, "new_hidden");
        (0, chai_1.expect)(mona_dish_1.DomQuery.byId(FORM_ID).querySelectorAll("input[name='new_hidden']").isAbsent()).to.eq(true);
    });
    (0, mocha_1.it)('submit form must work', function () {
        let FORM_ID = "blarg";
        let form = mona_dish_1.DomQuery.byId(FORM_ID);
        const submit_spy = sinon_1.default.spy(() => {
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga1\']').isPresent()).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga1\']').length == 1).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga1\']').inputValue.value == 'val_booga1').to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga2\']').isPresent()).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga2\']').length == 1).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga2\']').inputValue.value == 'val_booga2').to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll(`input[name='${FORM_ID}:_idcl']`).isPresent()).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll(`input[name='${FORM_ID}:_idcl']`).length == 1).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll(`input[name='${FORM_ID}:_idcl']`).inputValue.value == 'mylink').to.eq(true);
            (0, chai_1.expect)(form.attr("target").value).to.eq('target1');
        });
        form.value.value.submit = submit_spy;
        submitForm(FORM_ID, 'mylink', 'target1', {
            booga1: "val_booga1",
            booga2: "val_booga2"
        });
        (0, chai_1.expect)(submit_spy.called).to.eq(true);
        form = mona_dish_1.DomQuery.byId(FORM_ID);
        (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga1\']').isAbsent()).to.eq(true);
        (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga2\']').isAbsent()).to.eq(true);
        (0, chai_1.expect)(form.querySelectorAll(`input[name='${FORM_ID}:_idcl']`).isAbsent()).to.eq(true);
    });
    (0, mocha_1.it)('onsubmit form must work', function () {
        let FORM_ID = "blarg";
        let form = mona_dish_1.DomQuery.byId(FORM_ID);
        const onsumbit = () => {
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga1\']').isPresent()).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga1\']').length == 1).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga1\']').inputValue.value == 'val_booga1').to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga2\']').isPresent()).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga2\']').length == 1).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga2\']').inputValue.value == 'val_booga2').to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll(`input[name='${FORM_ID}:_idcl']`).isPresent()).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll(`input[name='${FORM_ID}:_idcl']`).length == 1).to.eq(true);
            (0, chai_1.expect)(form.querySelectorAll(`input[name='${FORM_ID}:_idcl']`).inputValue.value == 'mylink').to.eq(true);
            (0, chai_1.expect)(form.attr("target").value).to.eq('target1');
            return false;
        };
        const os_spy = sinon_1.default.spy(onsumbit);
        const submit_spy = sinon_1.default.spy(() => { });
        form.value.value.onsubmit = os_spy;
        form.value.value.submit = submit_spy;
        submitForm(FORM_ID, 'mylink', 'target1', {
            booga1: "val_booga1",
            booga2: "val_booga2"
        });
        //we also have to interceot onsbumit
        (0, chai_1.expect)(os_spy.called).to.eq(true);
        (0, chai_1.expect)(submit_spy.called).to.eq(false);
        form = mona_dish_1.DomQuery.byId(FORM_ID);
        (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga1\']').isAbsent()).to.eq(true);
        (0, chai_1.expect)(form.querySelectorAll('input[name=\'booga2\']').isAbsent()).to.eq(true);
        (0, chai_1.expect)(form.querySelectorAll(`input[name='${FORM_ID}:_idcl']`).isAbsent()).to.eq(true);
        // expect(submit_spy.called).to.eq(true);
    });
    // further tests will follow if needed, for now the namespace must be restored
});
//# sourceMappingURL=OamSubmit.spec.js.map