/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.commons.resourcehandler;

import javax.el.ValueExpression;

import org.apache.myfaces.commons.resourcehandler.resource.ResourceMeta;

/**
 * This abstract class extends from default ResourceMeta to allow cache request path expressions on
 * the resource cache and reuse it across requests.
 * 
 * @author Leonardo Uribe
 *
 */
public abstract class ExtendedResourceMeta extends ResourceMeta
{
    public abstract ValueExpression getRequestPathExpression();
    
    public abstract void setRequestPathExpression(ValueExpression expression);
}
