/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.webapp;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentClassicTagBase;
import javax.faces.webapp.UIComponentELTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ComponentUtils;
import org.apache.myfaces.trinidad.webapp.StringArrayValueExpression;
import org.apache.myfaces.trinidad.webapp.TagUtils;

public abstract class UIXComponentELTag
extends UIComponentELTag {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXComponentELTag.class);
    @Deprecated
    public static final String DOCUMENT_CREATED_KEY = "org.apache.myfaces.trinidad.DOCUMENTCREATED";
    private static final String _STAMPING_COUNT_KEY = UIXComponentELTag.class.getName() + ".STAMPING";
    private MethodExpression _attributeChangeListener;
    private String _validationError;
    private String _bindingExpression;
    private boolean _skipEndTagSuperCall = false;
    private ValueExpression _binding;

    public void setAttributeChangeListener(MethodExpression attributeChangeListener) {
        this._attributeChangeListener = attributeChangeListener;
    }

    public int doStartTag() throws JspException {
        int retVal;
        String facetName;
        UIXComponentELTag parentTag;
        UIComponentClassicTagBase parentTagBase;
        FacesContext context = this.getFacesContext();
        Map reqMap = context.getExternalContext().getRequestMap();
        Map facesContextAttributes = this.getFacesContext().getAttributes();
        if (!this._isProcessingStampingComponentTag(facesContextAttributes) && (parentTagBase = UIXComponentELTag.getParentUIComponentClassicTagBase((PageContext)this.pageContext)) instanceof UIXComponentELTag && (parentTag = (UIXComponentELTag)parentTagBase).checkChildTagExecution(this, facetName = this.getFacetName()) == CheckExecutionResult.REJECT) {
            this._skipEndTagSuperCall = true;
            return 0;
        }
        this._skipEndTagSuperCall = false;
        try {
            retVal = super.doStartTag();
        }
        catch (RuntimeException rte) {
            this._logSevereTagProcessingError(context, rte);
            throw rte;
        }
        catch (JspException jspe) {
            this._logSevereTagProcessingError(context, jspe);
            throw jspe;
        }
        if (this._validationError != null) {
            throw new JspException(this._validationError);
        }
        this._checkStartingStampingTag(facesContextAttributes);
        return retVal;
    }

    public int doEndTag() throws JspException {
        if (this._skipEndTagSuperCall) {
            this._skipEndTagSuperCall = false;
            return 6;
        }
        this._checkEndingStampingTag();
        return super.doEndTag();
    }

    protected boolean isProcessingStampingComponentTag() {
        return this._isProcessingStampingComponentTag(this.getFacesContext().getAttributes());
    }

    protected boolean isStampingTag() {
        return false;
    }

    protected CheckExecutionResult checkChildTagExecution(UIComponentELTag childTag, String facetName) {
        return CheckExecutionResult.ACCEPT;
    }

    protected UIComponent createComponent(FacesContext context, String newId) throws JspException {
        UIComponent component = null;
        if (RequestContext.isInComponentBindingContext(context) && this.hasBinding()) {
            ValueExpression binding = this._getBinding();
            binding.setValue(this.getELContext(), null);
        }
        if ((component = super.createComponent(context, newId)) != null && component.getParent() != null) {
            this._logStaleParent(context, component, component.getParent());
        }
        return component;
    }

    public void release() {
        this._binding = null;
        super.release();
    }

    public CheckExecutionResult checkChildTagExecution(UIComponent childComponent) {
        return CheckExecutionResult.ACCEPT;
    }

    protected final void setProperties(UIComponent component) {
        if (component instanceof UIViewRoot) {
            throw new IllegalStateException("<f:view> was not present on this page; tag " + (Object)((Object)this) + "encountered without an <f:view> being processed.");
        }
        super.setProperties(component);
        UIXComponent uixComponent = (UIXComponent)component;
        if (this._attributeChangeListener != null) {
            uixComponent.setAttributeChangeListener(this._attributeChangeListener);
        }
        this.setProperties(uixComponent.getFacesBean());
    }

    protected void setProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            bean.setProperty(key, expression.getValue(FacesContext.getCurrentInstance().getELContext()));
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setStringArrayProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            bean.setProperty(key, TagUtils.parseNameTokens(expression.getValue(FacesContext.getCurrentInstance().getELContext())));
        } else {
            expression = new StringArrayValueExpression(expression);
            bean.setValueExpression(key, expression);
        }
    }

    protected void setStringListProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            bean.setProperty(key, TagUtils.parseNameTokensAsList(expression.getValue(FacesContext.getCurrentInstance().getELContext())));
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setStringSetProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            bean.setProperty(key, TagUtils.parseNameTokensAsSet(expression.getValue(FacesContext.getCurrentInstance().getELContext())));
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setNumberProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            Object value = expression.getValue(FacesContext.getCurrentInstance().getELContext());
            if (value != null) {
                if (value instanceof Number) {
                    bean.setProperty(key, value);
                } else {
                    String valueStr = value.toString();
                    if (valueStr.indexOf(46) == -1) {
                        bean.setProperty(key, Integer.valueOf(valueStr));
                    } else {
                        bean.setProperty(key, Double.valueOf(valueStr));
                    }
                }
            }
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setIntArrayProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            String[] strings;
            Object value = expression.getValue(FacesContext.getCurrentInstance().getELContext());
            if (value != null && (strings = TagUtils.parseNameTokens(value)) != null) {
                try {
                    int[] ints = new int[strings.length];
                    for (int i = 0; i < strings.length; ++i) {
                        int j;
                        ints[i] = j = Integer.parseInt(strings[i]);
                    }
                }
                catch (NumberFormatException e) {
                    _LOG.severe("CANNOT_CONVERT_INTO_INT_ARRAY", value);
                    _LOG.severe(e);
                    return;
                }
            }
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    public void setBinding(ValueExpression valueExpression) throws JspException {
        this._binding = valueExpression;
        super.setBinding(valueExpression);
    }

    private ValueExpression _getBinding() {
        return this._binding;
    }

    protected void setDateProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            bean.setProperty(key, UIXComponentELTag._parseISODate(expression.getValue(FacesContext.getCurrentInstance().getELContext())));
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setMaxDateProperty(FacesBean bean, PropertyKey key, ValueExpression expression) {
        if (expression == null) {
            return;
        }
        if (expression.isLiteralText()) {
            Date d = UIXComponentELTag._parseISODate(expression.getValue(FacesContext.getCurrentInstance().getELContext()));
            Calendar c = Calendar.getInstance();
            TimeZone tz = RequestContext.getCurrentInstance().getTimeZone();
            if (tz != null) {
                c.setTimeZone(tz);
            }
            c.setTime(d);
            c.set(11, 23);
            c.set(12, 59);
            c.set(13, 59);
            c.set(14, 999);
            bean.setProperty(key, c.getTime());
        } else {
            bean.setValueExpression(key, expression);
        }
    }

    protected void setProperties(FacesBean bean) {
    }

    protected void setValidationError(String validationError) {
        this._validationError = validationError;
    }

    private void _checkStartingStampingTag(Map<Object, Object> facesContextAttributes) {
        if (this.isStampingTag()) {
            AtomicInteger count = (AtomicInteger)facesContextAttributes.get(_STAMPING_COUNT_KEY);
            if (count == null) {
                facesContextAttributes.put(_STAMPING_COUNT_KEY, new AtomicInteger(1));
            } else {
                count.set(count.get() + 1);
            }
        }
    }

    private void _checkEndingStampingTag() {
        if (this.isStampingTag()) {
            Map facesContextAttributes = this.getFacesContext().getAttributes();
            AtomicInteger count = (AtomicInteger)facesContextAttributes.get(_STAMPING_COUNT_KEY);
            if (count.get() == 1) {
                facesContextAttributes.remove(_STAMPING_COUNT_KEY);
            } else {
                count.set(count.get() - 1);
            }
        }
    }

    private boolean _isProcessingStampingComponentTag(Map<Object, Object> facesContextAttributes) {
        return facesContextAttributes.containsKey(_STAMPING_COUNT_KEY);
    }

    private void _logSevereTagProcessingError(FacesContext context, Throwable e) {
        UIViewRoot viewRoot = context.getViewRoot();
        UIComponent component = this.getComponentInstance();
        String scopedId = this._getScopedId(component, viewRoot);
        String parentScopedId = this._getParentScopedId(viewRoot);
        String message = _LOG.getMessage("ERROR_PARSING_COMPONENT_TAG", new Object[]{scopedId, parentScopedId});
        _LOG.severe(message, e);
    }

    private String _getScopedId(UIComponent component, UIViewRoot viewRoot) {
        if (component == null) {
            return this.getId();
        }
        return ComponentUtils.getScopedIdForComponent(component, (UIComponent)viewRoot);
    }

    private void _logStaleParent(FacesContext context, UIComponent child, UIComponent oldParent) {
        this._logStaleParentAtLevel(context, child, oldParent, Level.INFO);
    }

    private void _logStaleParentAtLevel(FacesContext context, UIComponent child, UIComponent oldParent, Level level) {
        if (_LOG.isLoggable(level)) {
            UIViewRoot viewRoot = context.getViewRoot();
            String scopedId = ComponentUtils.getScopedIdForComponent(child, (UIComponent)viewRoot);
            String oldParentScopedId = ComponentUtils.getScopedIdForComponent(oldParent, (UIComponent)viewRoot);
            String newParentScopedId = this._getParentScopedId(viewRoot);
            String bindingEL = this._getBindingExpression();
            _LOG.log(level, "ERROR_CREATE_COMPONENT_STALE", new Object[]{scopedId, oldParentScopedId, newParentScopedId, bindingEL});
        }
    }

    private String _getBindingExpression() {
        if (this._getBinding() != null) {
            if (this._bindingExpression == null) {
                this._bindingExpression = this._getBinding().getExpressionString();
            }
            return this._bindingExpression;
        }
        return null;
    }

    private String _getParentScopedId(UIViewRoot viewRoot) {
        UIComponentClassicTagBase parentTag = UIComponentClassicTagBase.getParentUIComponentClassicTagBase((PageContext)this.pageContext);
        if (parentTag != null) {
            UIComponent parent = parentTag.getComponentInstance();
            return ComponentUtils.getScopedIdForComponent(parent, (UIComponent)viewRoot);
        }
        return null;
    }

    private static final Date _parseISODate(Object o) {
        if (o == null) {
            return null;
        }
        String stringValue = o.toString();
        try {
            return UIXComponentELTag._getDateFormat().parse(stringValue);
        }
        catch (ParseException pe) {
            _LOG.info("CANNOT_PARSE_VALUE_INTO_DATE", stringValue);
            return null;
        }
    }

    private static DateFormat _getDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        TimeZone tz = RequestContext.getCurrentInstance().getTimeZone();
        if (tz != null) {
            sdf.setTimeZone(tz);
        }
        return sdf;
    }

    protected static enum CheckExecutionResult {
        ACCEPT,
        REJECT;

    }
}

