/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.uix;

import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.trinidad.component.UIXCollection;
import org.apache.myfaces.trinidad.component.UIXProcess;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.ProcessUtils;
import org.apache.myfaces.trinidadinternal.uinode.UINodeRendererBase;

public class ProcessRenderer
extends UINodeRendererBase {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ProcessRenderer.class);

    public void decode(FacesContext context, UIComponent component) {
        Object source;
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        Object event = requestMap.get("event");
        if (event != null && event.equals("goto") && (source = requestMap.get("source")) != null && source.equals(component.getClientId(context))) {
            Object valueObject = requestMap.get("value");
            Object sizeObject = requestMap.get("size");
            if (valueObject != null) {
                int value = -1;
                try {
                    value = Integer.parseInt(valueObject.toString());
                }
                catch (NumberFormatException nfe) {
                    _LOG.severe((Throwable)nfe);
                }
                int size = 0;
                try {
                    size = Integer.parseInt(sizeObject.toString());
                }
                catch (NumberFormatException nfe) {
                    _LOG.warning((Throwable)nfe);
                }
                if (size < 0) {
                    size = 0;
                }
                if (value >= 0) {
                    UIXProcess process = (UIXProcess)component;
                    Object oldPath = process.getRowKey();
                    Object focusPath = process.getFocusRowKey();
                    process.setRowKey(focusPath);
                    UIComponent stamp = process.getNodeStamp();
                    int index = process.getRowIndex();
                    index = size == 0 ? ProcessUtils.getBackIndex((UIXCollection)process, stamp, index) : ProcessUtils.getNextIndex((UIXCollection)process, stamp, index);
                    process.setRowIndex(index);
                    new ActionEvent(stamp).queue();
                    process.setRowKey(oldPath);
                }
            }
        }
    }
}

