/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.CollectionComponent;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.component.core.data.CoreTable;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.util.ThreadLocalUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.BandingData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.ColumnData;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RenderStage;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.table.RowData;

public class TableRenderingContext {
    public static final int NORMAL_COLUMN = 0;
    public static final int HIDDEN_COLUMN = 1;
    public static final int USER_INVISIBLE_COLUMN = 2;
    private final UIComponent _table;
    private final String _tableId;
    private String _jsVarName;
    private Object _tableWidth;
    private Object _tableHeight;
    private CollectionComponent _collectionComponent;
    private int _detailColumnIndex = -1;
    private int _columnCount = -1;
    private int _actualColumnCount = -1;
    private Boolean _immediate;
    private UIComponent _detail;
    private boolean _hasNavigation;
    private int[] _hiddenColumns;
    private int _hiddenColumnCount;
    private boolean[] _rowsHidden;
    private boolean _hasColumnHeaders = false;
    private BandingData _banding = null;
    private ColumnData _columnData;
    private RowData _rowData;
    private boolean _verticalGrid;
    private boolean _horizontalGrid;
    private final Boolean _rowSelection;
    private RenderStage _renderStage;
    private boolean _explicitHeaderIDMode = false;
    private boolean _hasColumnHeadersUsed = false;
    private Map<Object, Object> _tableProps = null;
    private TableRenderingContext _previous;
    private Object _nodeList;
    public static final int DONT_KNOW = -1;
    private static final ThreadLocal<TableRenderingContext> _CURRENT_CONTEXT = ThreadLocalUtils.newRequestThreadLocal();

    public static TableRenderingContext getCurrentInstance() {
        return _CURRENT_CONTEXT.get();
    }

    public TableRenderingContext(FacesContext context, RenderingContext arc, UIComponent component) {
        boolean hasNav;
        CollectionComponent collectionComponent = (CollectionComponent)component;
        collectionComponent.setRowIndex(-1);
        String tableId = component.getClientId(context);
        this._table = component;
        this._tableId = tableId;
        this._columnCount = component.getChildCount();
        this._collectionComponent = collectionComponent;
        this._jsVarName = "_uixt_" + XhtmlUtils.getJSIdentifier(tableId);
        this._rowData = new RowData(this);
        this._columnData = new ColumnData();
        int length = this.getColumnCount();
        this._hiddenColumns = new int[length];
        this._gatherChildInformation(component);
        this._columnData.setColumnCount(length - this._hiddenColumnCount);
        this._renderStage = new RenderStage();
        this._detail = CoreRenderer.getFacet((UIComponent)component, (String)"detailStamp");
        this._tableWidth = this._getAttr(component, CoreTable.WIDTH_KEY);
        this._tableHeight = component.getAttributes().get("height");
        int rows = collectionComponent.getRowCount();
        this._hasNavigation = hasNav = rows > this.getRowData().getVisibleRowCount() || rows < 0;
        String rowSelection = (String)this._getAttr(component, CoreTable.ROW_SELECTION_KEY);
        this._rowSelection = "single".equals(rowSelection) ? Boolean.FALSE : ("multiple".equals(rowSelection) ? Boolean.TRUE : null);
        this._verticalGrid = (Boolean)this._getAttr(component, CoreTable.VERTICAL_GRID_VISIBLE_KEY);
        this._horizontalGrid = (Boolean)this._getAttr(component, CoreTable.HORIZONTAL_GRID_VISIBLE_KEY);
    }

    private Object _getAttr(UIComponent component, PropertyKey key) {
        return component.getAttributes().get(key.getName());
    }

    public void install() {
        this._previous = TableRenderingContext.getCurrentInstance();
        _CURRENT_CONTEXT.set(this);
    }

    public void release() {
        _CURRENT_CONTEXT.set(this._previous);
    }

    public final String getJSVarName() {
        return this._jsVarName;
    }

    public final RenderStage getRenderStage() {
        return this._renderStage;
    }

    public final Object getTableWidth() {
        return this._tableWidth;
    }

    public final Object getTableHeight() {
        return this._tableHeight;
    }

    public final void setExplicitHeaderIDMode(boolean isEnabled) {
        if (!XhtmlRenderer.isInaccessibleMode((RenderingContext)RenderingContext.getCurrentInstance())) {
            this._explicitHeaderIDMode = isEnabled;
        }
    }

    public final boolean isExplicitHeaderIDMode() {
        return this._explicitHeaderIDMode;
    }

    public final UIComponent getTable() {
        return this._table;
    }

    public final String getTableId() {
        return this._tableId;
    }

    public final CollectionComponent getCollectionComponent() {
        return this._collectionComponent;
    }

    public RowKeySet getSelectedRowKeys() {
        return ((UIXTable)this.getCollectionComponent()).getSelectedRowKeys();
    }

    public final boolean isImmediate() {
        if (this._immediate == null) {
            Object value = this.getTable().getAttributes().get("immediate");
            this._immediate = TableRenderingContext._toBoolean(value, false);
        }
        return this._immediate;
    }

    public final boolean hasNavigation() {
        return this._hasNavigation;
    }

    public final Object getColumnWidth(int physicalIndex) {
        return this._columnData.getWidth(physicalIndex);
    }

    public final boolean hasColumnHeaders() {
        this._hasColumnHeadersUsed = true;
        return this._hasColumnHeaders;
    }

    public final void columnHeadersPresent() {
        if (this._hasColumnHeadersUsed) {
            throw new IllegalStateException();
        }
        this._hasColumnHeaders = true;
    }

    public final void setDetailColumnIndex(int physicalIndex) {
        this._detailColumnIndex = physicalIndex;
    }

    public final int getDetailColumnIndex() {
        return this._detailColumnIndex;
    }

    public UIComponent getDetail() {
        return this._detail;
    }

    public final void setRowHidden(int index) {
        int rowCount = 0;
        if (this._rowsHidden == null) {
            rowCount = index * 2;
            this._rowsHidden = new boolean[rowCount];
        } else if (index >= this._rowsHidden.length) {
            rowCount = Math.max(this._rowsHidden.length, index) * 2;
            boolean[] newArray = new boolean[rowCount];
            System.arraycopy(this._rowsHidden, 0, newArray, 0, this._rowsHidden.length);
            this._rowsHidden = newArray;
        }
        this._rowsHidden[index] = true;
    }

    public final boolean isRowHidden(int index) {
        boolean rv = false;
        if (this._rowsHidden != null && this._rowsHidden.length > index) {
            rv = this._rowsHidden[index];
        }
        return rv;
    }

    public final boolean hasSelectAll() {
        return Boolean.TRUE.equals(this._rowSelection);
    }

    public final boolean hasSelection() {
        return this._rowSelection != null;
    }

    public final int[] getHiddenColumns() {
        return this._hiddenColumns;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public final int getActualColumnCount() {
        if (this._actualColumnCount < 0) {
            int columns = this._columnData.getColumnCount();
            this._actualColumnCount = columns + this.getSpecialColumnCount();
        }
        return this._actualColumnCount;
    }

    public int getSpecialColumnCount() {
        int columns = 0;
        if (this.hasSelection()) {
            ++columns;
        }
        if (this.getDetail() != null) {
            ++columns;
        }
        return columns;
    }

    public final BandingData getBanding() {
        if (this._banding == null) {
            this._banding = BandingData.create(this);
        }
        return this._banding;
    }

    public final ColumnData getColumnData() {
        return this._columnData;
    }

    public final RowData getRowData() {
        return this._rowData;
    }

    public boolean hasGrid(int before, boolean vertical) {
        if (before >= 0) {
            return vertical ? this._verticalGrid : this._horizontalGrid;
        }
        return true;
    }

    public Object getHeaderNodesList() {
        return this._nodeList;
    }

    public void setHeaderNodeList(Object nodeList) {
        this._nodeList = nodeList;
    }

    private static Boolean _toBoolean(Object value, boolean defaultValue) {
        if (defaultValue) {
            return Boolean.FALSE.equals(value) ? Boolean.FALSE : Boolean.TRUE;
        }
        return Boolean.TRUE.equals(value) ? Boolean.TRUE : Boolean.FALSE;
    }

    private void _gatherChildInformation(UIComponent parent) {
        List children = parent.getChildren();
        int count = children.size();
        for (int index = 0; index < count; ++index) {
            UIComponent child = (UIComponent)children.get(index);
            if (child.isRendered() || this._hiddenColumns[index] == 1) continue;
            this._hiddenColumns[index] = 1;
            ++this._hiddenColumnCount;
        }
    }

    public static boolean isInsideContentOfTable() {
        TableRenderingContext tContext = _CURRENT_CONTEXT.get();
        if (tContext == null) {
            return false;
        }
        return tContext.getRenderStage().getStage() == 30;
    }

    public final Object getTableProperty(Object key) {
        Map<Object, Object> props = this._tableProps;
        return props == null ? null : props.get(key);
    }

    public final Object setTableProperty(Object key, Object value) {
        Map<Object, Object> props = this._tableProps;
        if (props == null) {
            this._tableProps = props = new HashMap<Object, Object>(5);
        }
        return props.put(key, value);
    }
}

