/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectOneRadio;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AutoSubmitUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.LabelAndMessageRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectOneRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class SimpleSelectOneRadioRenderer
extends SimpleSelectOneRenderer {
    private PropertyKey _accessKeyKey;
    private PropertyKey _layoutKey;
    private PropertyKey _unselectedLabelKey;

    public SimpleSelectOneRadioRenderer() {
        this(CoreSelectOneRadio.TYPE);
    }

    public SimpleSelectOneRadioRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._accessKeyKey = type.findKey("accessKey");
        this._layoutKey = type.findKey("layout");
        this._unselectedLabelKey = type.findKey("unselectedLabel");
    }

    @Override
    protected void encodeElementContent(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int selectedIndex, Converter converter, boolean valuePassThru) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("span", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean, false);
        boolean applyFieldSet = SimpleSelectOneRadioRenderer._applyFieldSetWrapper(rc);
        if (applyFieldSet) {
            String shortDesc = this.getShortDesc(component, bean);
            if (shortDesc == null) {
                applyFieldSet = false;
            } else {
                writer.startElement("fieldset", null);
                writer.writeAttribute("style", (Object)"border:none;margin:0px;padding:0px;", null);
                writer.startElement("legend", null);
                SimpleSelectOneRadioRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"p_OraHiddenLabel");
                writer.writeText((Object)shortDesc, "shortDesc");
                writer.endElement("legend");
            }
        }
        this.encodeSelectItems(context, rc, component, bean, selectItems, selectedIndex, converter, valuePassThru);
        if (applyFieldSet) {
            writer.endElement("fieldset");
        }
        writer.endElement("span");
    }

    protected void encodeSelectItems(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean, List<SelectItem> selectItems, int selectedIndex, Converter converter, boolean valuePassThru) throws IOException {
        int size = selectItems == null ? 0 : selectItems.size();
        boolean disabled = this.getDisabled(component, bean);
        boolean isVertical = !"horizontal".equals(this.getLayout(component, bean));
        Object accessKey = SimpleSelectOneRadioRenderer.supportsAccessKeys(rc) ? this.getAccessKey(component, bean) : null;
        String itemOnclick = this.getItemOnclick(rc, component, bean);
        boolean renderedOne = false;
        String unselectedLabel = this.getUnselectedLabel(component, bean);
        if (unselectedLabel != null) {
            SelectItem item = new SelectItem((Object)"", unselectedLabel, "", false);
            this.encodeSelectItem(context, rc, component, item, null, true, accessKey, -1, selectedIndex < 0, disabled, false, itemOnclick);
            renderedOne = true;
        }
        for (int i = 0; i < size; ++i) {
            SelectItem item = selectItems.get(i);
            if (!this.encodeSelectItem(context, rc, component, item, converter, valuePassThru, accessKey, i, selectedIndex == i, disabled, renderedOne && isVertical, itemOnclick)) continue;
            renderedOne = true;
        }
    }

    protected boolean encodeSelectItem(FacesContext context, RenderingContext rc, UIComponent component, SelectItem item, Converter converter, boolean valuePassThru, Object accessKey, int index, boolean isSelected, boolean isDisabled, boolean renderBreak, String itemOnclick) throws IOException {
        if (item == null) {
            return false;
        }
        String id = rc.getCurrentClientId();
        if (id == null) {
            return false;
        }
        StringBuffer subidBuffer = new StringBuffer(id.length() + 4);
        subidBuffer.append(id);
        subidBuffer.append(":_");
        subidBuffer.append(IntegerUtils.getString((int)index));
        String subid = subidBuffer.toString();
        Object itemValue = SimpleSelectOneRadioRenderer.getItemValue(context, component, item, converter, valuePassThru, index);
        FacesBean bean = this.getFacesBean(component);
        ResponseWriter rw = context.getResponseWriter();
        if (renderBreak) {
            rw.startElement("br", null);
            rw.endElement("br");
        }
        rw.startElement("input", null);
        rw.writeAttribute("type", (Object)"radio", null);
        rw.writeAttribute("name", (Object)id, null);
        rw.writeAttribute("id", (Object)subid, null);
        rw.writeAttribute("value", itemValue, null);
        rw.writeAttribute("accesskey", accessKey, null);
        if (isSelected) {
            rw.writeAttribute("checked", (Object)Boolean.TRUE, null);
        }
        if (isDisabled || item.isDisabled()) {
            rw.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (SimpleSelectOneRadioRenderer.supportsScripting(rc)) {
            rw.writeAttribute("onclick", (Object)itemOnclick, null);
            this.renderItemFormEventHandlers(context, component, bean);
        }
        rw.endElement("input");
        rw.startElement("label", null);
        rw.writeAttribute("for", (Object)subid, null);
        String description = item.getDescription();
        if (description != null && !"".equals(description)) {
            rw.writeAttribute("title", (Object)description, null);
        }
        rw.writeText((Object)item.getLabel(), null);
        rw.endElement("label");
        return true;
    }

    @Override
    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderId(context, component)) {
            String clientId = this.getClientId(context, component);
            context.getResponseWriter().writeAttribute("id", (Object)clientId, "id");
        }
    }

    @Override
    protected void renderFormEventHandlers(FacesContext context, UIComponent component, FacesBean bean) throws IOException {
    }

    @Override
    protected String getOnclick(UIComponent component, FacesBean bean) {
        return null;
    }

    protected void renderItemFormEventHandlers(FacesContext context, UIComponent component, FacesBean bean) throws IOException {
        super.renderFormEventHandlers(context, component, bean);
    }

    protected String getItemOnclick(RenderingContext rc, UIComponent component, FacesBean bean) {
        String onclick = super.getOnclick(component, bean);
        if (this.isAutoSubmit(component, bean)) {
            String source = LabelAndMessageRenderer.__getCachedClientId(rc);
            boolean immediate = this.isImmediate(component, bean);
            String auto = AutoSubmitUtils.getSubmitScript(rc, source, "autosub", immediate);
            onclick = XhtmlUtils.getChainedJS(onclick, auto, true);
        }
        return onclick;
    }

    protected Object getAccessKey(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._accessKeyKey);
    }

    protected String getLayout(UIComponent component, FacesBean bean) {
        return SimpleSelectOneRadioRenderer.toString((Object)bean.getProperty(this._layoutKey));
    }

    @Override
    protected String getUnselectedLabel(UIComponent component, FacesBean bean) {
        return SimpleSelectOneRadioRenderer.toString((Object)bean.getProperty(this._unselectedLabelKey));
    }

    @Override
    protected boolean isHiddenLabelRequired(RenderingContext rc) {
        return false;
    }

    @Override
    protected String getContentStyleClass(UIComponent component, FacesBean bean) {
        return "af|selectOneRadio::content";
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|selectOneRadio";
    }

    private static boolean _applyFieldSetWrapper(RenderingContext rc) {
        if (SimpleSelectOneRadioRenderer.isInaccessibleMode((RenderingContext)rc)) {
            return false;
        }
        if (!HiddenLabelUtils.supportsHiddenLabels(rc)) {
            return true;
        }
        return Boolean.TRUE.equals(rc.getAgent().getCapabilities().get(TrinidadAgent.CAP_FIELDSET));
    }
}

