/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.laf.browser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import org.apache.myfaces.trinidadinternal.image.ImageConstants;
import org.apache.myfaces.trinidadinternal.image.ImageContext;
import org.apache.myfaces.trinidadinternal.image.laf.browser.BlafImageUtils;
import org.apache.myfaces.trinidadinternal.image.painter.AbstractBorderPainter;
import org.apache.myfaces.trinidadinternal.image.painter.AdjustableBorderPainter;
import org.apache.myfaces.trinidadinternal.image.painter.ColorChange;
import org.apache.myfaces.trinidadinternal.image.painter.ImmInsets;
import org.apache.myfaces.trinidadinternal.image.painter.OffscreenWrappingPainter;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContext;
import org.apache.myfaces.trinidadinternal.image.painter.Painter;
import org.apache.myfaces.trinidadinternal.image.painter.TextPainter;
import org.apache.myfaces.trinidadinternal.style.util.FontProxy;

public class CompositeButtonPainter
extends AbstractBorderPainter
implements ImageConstants {
    private static final String _STYLE_NAME = "AFButtonServerText";
    private static final String _DISABLED_STYLE_NAME = "AFButtonServerTextDisabled";
    private static final FontProxy _DEFAULT_FONT_PROXY = new FontProxy("Dialog", 0, 12);
    private static final Color _DEFAULT_FOREGROUND = BlafImageUtils.__TEXT_FOREGROUND_COLOR;
    private static final Color _DEFAULT_DISABLED_FOREGROUND = BlafImageUtils.__VERY_DARK_ACCENT_COLOR;
    private static final Color _DEFAULT_BACKGROUND = BlafImageUtils.__LIGHT_ACCENT_COLOR;
    private static final int _TEXT_START_MARGIN = 2;
    private static final int _TEXT_END_MARGIN = 3;
    private Object _START_IMAGE_KEY = PaintContext.BUTTON_START_IMAGE_KEY;
    private Object _END_IMAGE_KEY = PaintContext.BUTTON_END_IMAGE_KEY;
    private Object _TOP_BACKGROUND_IMAGE_KEY = PaintContext.BUTTON_TOP_BACKGROUND_IMAGE_KEY;
    private Object _BOTTOM_BACKGROUND_IMAGE_KEY = PaintContext.BUTTON_BOTTOM_BACKGROUND_IMAGE_KEY;

    public CompositeButtonPainter() {
        super(new AdjustableBorderPainter(new DisabledColorChange(new OffscreenWrappingPainter(new TextPainter(TEXT_KEY))), 0, 2, 0, 3, "ButtonServerPadding"));
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        boolean isRTL = this._isRightToLeft(context);
        Object leftKey = isRTL ? this._END_IMAGE_KEY : this._START_IMAGE_KEY;
        Object rightKey = isRTL ? this._START_IMAGE_KEY : this._END_IMAGE_KEY;
        Dimension leftSize = this._getImageSize(context, leftKey);
        Dimension rightSize = this._getImageSize(context, rightKey);
        Dimension topSize = this._getImageSize(context, this._TOP_BACKGROUND_IMAGE_KEY);
        Dimension bottomSize = this._getImageSize(context, this._BOTTOM_BACKGROUND_IMAGE_KEY);
        Painter wrappedPainter = this.getWrappedPainter(context);
        Dimension innerSize = wrappedPainter.getPreferredSize(context);
        int topInset = topSize.height;
        int bottomInset = bottomSize.height;
        int innerHeight = innerSize.height + topInset + bottomInset;
        int maxHeight = this._getMaxHeight(leftSize, rightSize, innerHeight);
        if (maxHeight > innerHeight) {
            int vertInsets = maxHeight - innerHeight;
            int halfInsets = vertInsets / 2;
            topInset += halfInsets;
            bottomInset += halfInsets;
            if (vertInsets % 2 != 0) {
                ++topInset;
            }
        }
        return new ImmInsets(topInset, leftSize.width, bottomInset, rightSize.width);
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        int x0;
        boolean isRTL = this._isRightToLeft(context);
        Object leftKey = isRTL ? this._END_IMAGE_KEY : this._START_IMAGE_KEY;
        Object rightKey = isRTL ? this._START_IMAGE_KEY : this._END_IMAGE_KEY;
        Image leftImage = CompositeButtonPainter._getImage(context, leftKey);
        Image rightImage = CompositeButtonPainter._getImage(context, rightKey);
        Image topBackgroundImage = CompositeButtonPainter._getImage(context, this._TOP_BACKGROUND_IMAGE_KEY);
        Image bottomBackgroundImage = CompositeButtonPainter._getImage(context, this._BOTTOM_BACKGROUND_IMAGE_KEY);
        int leftWidth = 0;
        int rightWidth = 0;
        int topHeight = 0;
        int bottomHeight = 0;
        if (leftImage != null) {
            Dimension leftSize = this._getImageSize(context, leftImage);
            leftWidth = leftSize.width;
            g.drawImage(leftImage, x, y, leftWidth, height, context.getImageObserver());
        }
        if (rightImage != null) {
            Dimension rightSize = this._getImageSize(context, rightImage);
            rightWidth = rightSize.width;
            int rightX = x + width - rightWidth;
            g.drawImage(rightImage, rightX, y, rightWidth, height, context.getImageObserver());
        }
        int x1 = x + leftWidth;
        int x2 = x + width - rightWidth;
        if (topBackgroundImage != null) {
            topHeight = this._getImageSize((PaintContext)context, (Image)topBackgroundImage).height;
            for (x0 = x1; x0 < x2; ++x0) {
                g.drawImage(topBackgroundImage, x0, y, context.getImageObserver());
            }
        }
        if (bottomBackgroundImage != null) {
            bottomHeight = this._getImageSize((PaintContext)context, (Image)bottomBackgroundImage).height;
            for (x0 = x1; x0 < x2; ++x0) {
                Dimension bottomSize = this._getImageSize(context, bottomBackgroundImage);
                g.drawImage(bottomBackgroundImage, x0, y + height - bottomSize.height, context.getImageObserver());
            }
        }
        this._fillBackground(context, g, x, y, width, height, leftWidth, rightWidth, topHeight, bottomHeight);
    }

    public static Color getDefaultForeground(ImageContext context, boolean disabled) {
        String styleName = disabled ? _DISABLED_STYLE_NAME : _STYLE_NAME;
        Color color = BlafImageUtils.__getNamedForeground(context, styleName);
        if (color == null) {
            color = disabled ? _DEFAULT_DISABLED_FOREGROUND : _DEFAULT_FOREGROUND;
        }
        return color;
    }

    public static Color getDefaultBackground(ImageContext context, boolean disabled) {
        String styleName = disabled ? _DISABLED_STYLE_NAME : _STYLE_NAME;
        Color color = BlafImageUtils.__getNamedBackground(context, styleName);
        if (color == null) {
            color = _DEFAULT_BACKGROUND;
        }
        return color;
    }

    public static FontProxy getDefaultFont() {
        return _DEFAULT_FONT_PROXY;
    }

    static boolean _isDisabled(PaintContext context) {
        return (context.getPaintState() & 1) != 0;
    }

    private boolean _isRightToLeft(PaintContext context) {
        return context.getReadingDirection() == 2;
    }

    private static Image _getImage(PaintContext context, Object key) {
        return (Image)context.getPaintData(key);
    }

    private Dimension _getImageSize(PaintContext context, Object key) {
        Object data = context.getPaintData(key);
        if (!(data instanceof Image)) {
            return new Dimension(0, 0);
        }
        return this._getImageSize(context, (Image)data);
    }

    private Dimension _getImageSize(PaintContext context, Image image) {
        if (image == null) {
            return new Dimension(0, 0);
        }
        ImageObserver observer = context.getImageObserver();
        return new Dimension(image.getWidth(observer), image.getHeight(observer));
    }

    private int _getMaxHeight(Dimension startSize, Dimension endSize, int innerHeight) {
        int maxHeight = innerHeight;
        if (startSize.height > maxHeight) {
            maxHeight = startSize.height;
        }
        if (endSize.height > maxHeight) {
            maxHeight = endSize.height;
        }
        return maxHeight;
    }

    private void _fillBackground(PaintContext context, Graphics g, int x, int y, int width, int height, int startWidth, int endWidth, int topHeight, int bottomHeight) {
        Color oldBackground = g.getColor();
        Color background = context.getPaintBackground();
        g.setColor(background);
        g.fillRect(x + startWidth, y + topHeight, width - (startWidth + endWidth), height - (topHeight + bottomHeight));
        g.setColor(oldBackground);
    }

    private static class DisabledColorChange
    extends ColorChange {
        public DisabledColorChange(Painter wrappedPainter) {
            super(wrappedPainter);
        }

        @Override
        protected Color getColor(PaintContext context) {
            Object foreground = context.getPaintData(ImageConstants.FOREGROUND_KEY);
            if (foreground != null) {
                return (Color)foreground;
            }
            return CompositeButtonPainter.getDefaultForeground(context.getImageContext(), CompositeButtonPainter._isDisabled(context));
        }
    }
}

