/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;

class TrinidadLogRecord
extends LogRecord {
    private transient boolean _needToInferCaller = true;
    private static final String _JDK_LOG_CLASS = "java.util.logging.Logger";
    private static final String _TRINIDAD_LOG_CLASS = "org.apache.myfaces.trinidad.logging.TrinidadLogger";
    private static final long serialVersionUID = 1L;

    public TrinidadLogRecord(Level level, String msg) {
        super(level, msg == null ? "" : msg);
    }

    @Override
    public String getSourceClassName() {
        if (this._needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceClassName();
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this._needToInferCaller = false;
        super.setSourceClassName(sourceClassName);
    }

    @Override
    public String getSourceMethodName() {
        if (this._needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this._needToInferCaller = false;
        super.setSourceMethodName(sourceMethodName);
    }

    private void _inferCaller() {
        StackTraceElement frame;
        String cname;
        int i;
        this._needToInferCaller = false;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (i = 0; i < stack.length && !(cname = (frame = stack[i]).getClassName()).equals(_JDK_LOG_CLASS) && !cname.equals(_TRINIDAD_LOG_CLASS); ++i) {
        }
        while (i < stack.length) {
            frame = stack[i];
            cname = frame.getClassName();
            if (cname.equals(_JDK_LOG_CLASS) || cname.equals(_TRINIDAD_LOG_CLASS)) {
                ++i;
                continue;
            }
            String mname = frame.getMethodName();
            if ("log".equals(mname) || "_log".equals(mname)) {
                ++i;
                continue;
            }
            this.setSourceClassName(cname);
            this.setSourceMethodName(mname);
            return;
        }
        this.setSourceClassName(null);
        this.setSourceMethodName(null);
    }
}

