/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlTableLayout;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class TableLayoutRenderer
extends XhtmlRenderer {
    private PropertyKey _widthKey;
    private PropertyKey _halignKey;
    private PropertyKey _cellSpacingKey;
    private PropertyKey _cellPaddingKey;
    private PropertyKey _borderWidthKey;
    private PropertyKey _summaryKey;

    public TableLayoutRenderer() {
        super(HtmlTableLayout.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._widthKey = type.findKey("width");
        this._halignKey = type.findKey("halign");
        this._cellSpacingKey = type.findKey("cellSpacing");
        this._cellPaddingKey = type.findKey("cellPadding");
        this._borderWidthKey = type.findKey("borderWidth");
        this._summaryKey = type.findKey("summary");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("table", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean);
        TableLayoutRenderer.renderHAlign(context, rc, this.getHalign(component, bean));
        Object summary = this.getSummary(component, bean);
        if (summary.equals("")) {
            OutputUtils.renderLayoutTableAttributes(context, rc, this.getCellPadding(component, bean), this.getCellSpacing(component, bean), this.getBorderWidth(component, bean), this.getWidth(component, bean));
        } else {
            OutputUtils.renderDataTableAttributes(context, rc, this.getCellPadding(component, bean), this.getCellSpacing(component, bean), this.getBorderWidth(component, bean), this.getWidth(component, bean), this.getSummary(component, bean));
        }
        this.encodeAllChildren(context, component);
        rw.endElement("table");
    }

    protected Object getWidth(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._widthKey);
    }

    protected Object getHalign(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._halignKey);
    }

    protected Object getCellSpacing(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._cellSpacingKey);
        if (o == null) {
            o = 0;
        }
        return o;
    }

    protected Object getCellPadding(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._cellPaddingKey);
        if (o == null) {
            o = 0;
        }
        return o;
    }

    protected Object getBorderWidth(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._borderWidthKey);
        if (o == null) {
            o = 0;
        }
        return o;
    }

    protected Object getSummary(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._summaryKey);
        if (o == null) {
            o = "";
        }
        return o;
    }
}

