/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXPanel;
import org.apache.myfaces.trinidad.component.UIXSelectItem;
import org.apache.myfaces.trinidad.component.UIXSelectRange;
import org.apache.myfaces.trinidad.component.core.data.CoreSelectRangeChoiceBar;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.RangeChangeEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ProcessUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlConstants;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.util.Range;

public class SelectRangeChoiceBarRenderer
extends XhtmlRenderer {
    private PropertyKey _rowsKey;
    private PropertyKey _firstKey;
    private PropertyKey _showAllKey;
    private PropertyKey _immediateKey;
    private PropertyKey _varKey;
    private static final String _PREVIOUS_DESC_KEY = "af_selectRangeChoiceBar.PREVIOUS_TIP";
    private static final String _NEXT_DESC_KEY = "af_selectRangeChoiceBar.NEXT_TIP";
    private static final String _DISABLED_PREVIOUS_DESC_KEY = "af_selectRangeChoiceBar.PREV_DISABLED_TIP";
    private static final String _DISABLED_NEXT_DESC_KEY = "af_selectRangeChoiceBar.NEXT_DISABLED_TIP";
    private static final String _CHOICE_TIP_KEY = "af_selectRangeChoiceBar.CHOICE_TIP";
    private static final String _MULTI_RANGE_NO_TOTAL_FORMAT_STRING = "af_selectRangeChoiceBar.CHOICE_FORMAT_NO_TOTAL";
    private static final String _MULTI_RANGE_TOTAL_FORMAT_STRING = "af_selectRangeChoiceBar.CHOICE_FORMAT_TOTAL";
    private static final String _PREVIOUS_TEXT_KEY = "af_selectRangeChoiceBar.PREVIOUS_OPTION";
    private static final String _MORE_TEXT_KEY = "af_selectRangeChoiceBar.MORE_OPTION";
    private static final String _SHOW_ALL_KEY = "af_selectRangeChoiceBar.SHOW_ALL";
    private static final long _MAX_VISIBLE_OPTIONS = 30L;
    private static final String _CHOICE_FORM_ON_FOCUS = "this._lastValue = this.selectedIndex";
    private static final String _CHOICE_ID_SUFFIX = "c";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SelectRangeChoiceBarRenderer.class);

    public SelectRangeChoiceBarRenderer() {
        this(CoreSelectRangeChoiceBar.TYPE);
    }

    public SelectRangeChoiceBarRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._rowsKey = type.findKey("rows");
        this._firstKey = type.findKey("first");
        this._immediateKey = type.findKey("immediate");
        this._showAllKey = type.findKey("showAll");
        this._varKey = type.findKey("var");
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        Object event = parameters.get("event");
        if ("goto".equals(event)) {
            String id;
            Object source = parameters.get("source");
            String string = id = clientId == null ? component.getClientId(facesContext) : clientId;
            if (id.equals(source)) {
                UIXSelectRange choiceBar = (UIXSelectRange)component;
                Object valueParam = parameters.get("value");
                RangeChangeEvent rce = this._createRangeChangeEvent(choiceBar, valueParam);
                rce.queue();
                if (choiceBar.isImmediate()) {
                    facesContext.renderResponse();
                }
                RequestContext.getCurrentInstance().addPartialTarget(component);
            }
        }
    }

    private RangeChangeEvent _createRangeChangeEvent(UIXSelectRange choiceBar, Object valueParam) {
        int rowCount = choiceBar.getRowCount();
        int rows = choiceBar.getRows();
        FacesBean bean = this.getFacesBean((UIComponent)choiceBar);
        boolean isShowAll = this.getShowAll((UIComponent)choiceBar, bean);
        int increment = isShowAll && rowCount > -1 ? rowCount : rows;
        int oldStart = choiceBar.getFirst();
        int oldEnd = oldStart + increment;
        if (isShowAll) {
            bean.setProperty(this._showAllKey, (Object)Boolean.FALSE);
        }
        int newStart = -1;
        int newEnd = -1;
        if (valueParam != null) {
            String newStartString = valueParam.toString();
            if (newStartString.equals("all")) {
                bean.setProperty(this._showAllKey, (Object)Boolean.TRUE);
                newStart = 0;
                newEnd = rowCount;
            } else {
                try {
                    newStart = Integer.parseInt(newStartString) - 1;
                    newEnd = newStart + rows;
                }
                catch (NumberFormatException nfe) {
                    _LOG.severe((Throwable)nfe);
                }
            }
        }
        return new RangeChangeEvent((UIComponent)choiceBar, oldStart, oldEnd, newStart, newEnd);
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    protected int getRows(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._rowsKey);
        if (o == null) {
            o = this._rowsKey.getDefault();
        }
        return SelectRangeChoiceBarRenderer.toInt((Object)o);
    }

    protected int getFirst(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._firstKey);
        if (o == null) {
            o = this._firstKey.getDefault();
        }
        return SelectRangeChoiceBarRenderer.toInt((Object)o);
    }

    protected boolean getShowAll(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._showAllKey);
        if (o == null) {
            o = this._showAllKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean getImmediate(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._immediateKey);
        if (o == null) {
            o = this._immediateKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected String getVar(UIComponent component, FacesBean bean) {
        return SelectRangeChoiceBarRenderer.toString((Object)bean.getProperty(this._varKey));
    }

    protected UIComponent getRangeLabel(UIComponent component) {
        return SelectRangeChoiceBarRenderer.getFacet((UIComponent)component, (String)"rangeLabel");
    }

    protected int getRowCount(UIComponent component) {
        return ((UIXSelectRange)component).getRowCount();
    }

    protected int getRowIndex(UIComponent component) {
        return ((UIXSelectRange)component).getRowIndex();
    }

    protected void setRowIndex(UIComponent component, int index) {
        ((UIXSelectRange)component).setRowIndex(index);
    }

    protected boolean isRowAvailable(UIComponent component) {
        return ((UIXSelectRange)component).isRowAvailable();
    }

    protected boolean isRowAvailable(UIComponent component, int rowIndex) {
        return ((UIXSelectRange)component).isRowAvailable(rowIndex);
    }

    protected Object getRowData(UIComponent component) {
        return ((UIXSelectRange)component).getRowData();
    }

    protected String getSource() {
        return null;
    }

    protected boolean showAllSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        int rowIndex = this.getRowIndex(component);
        try {
            boolean showAllActive;
            boolean showNextButton;
            boolean hasNextRecords;
            long currentValue;
            int blockSize = this.getRows(component, bean);
            if (blockSize < 0) {
                blockSize = SelectRangeChoiceBarRenderer.toInt((Object)this._rowsKey.getDefault());
            }
            if ((currentValue = (long)(this.getFirst(component, bean) + 1)) < 1L) {
                currentValue = 1L;
            }
            long minValue = 1L;
            long maxValue = this.getRowCount(component);
            if (maxValue <= 0L) {
                maxValue = -1L;
            }
            String id = this.getClientId(context, component);
            String source = this.getSource();
            if (source == null) {
                source = id;
            }
            if (rc.getFormData() == null) {
                return;
            }
            String formName = rc.getFormData().getName();
            if (formName == null) {
                return;
            }
            int nextRecords = 0;
            int prevRecords = 0;
            long backValue = 0L;
            long nextValue = 0L;
            if (blockSize > 0) {
                long lNextRecords = blockSize;
                if (maxValue != -1L) {
                    lNextRecords = maxValue - (currentValue + (long)blockSize - 1L);
                }
                long lPrevRecords = currentValue - minValue;
                nextRecords = lNextRecords > (long)blockSize ? blockSize : (int)lNextRecords;
                prevRecords = lPrevRecords > (long)blockSize ? blockSize : (int)lPrevRecords;
                backValue = currentValue - (long)prevRecords;
                nextValue = currentValue + (long)blockSize;
            }
            boolean validate = !this.getImmediate(component, bean);
            boolean showDisabledNavigation = this.disabledNavigationShown();
            boolean hasBackRecords = prevRecords > 0;
            boolean bl = hasNextRecords = nextRecords > 0;
            if (hasNextRecords && maxValue == -1L) {
                hasNextRecords = this.isRowAvailable(component, (int)nextValue - 1);
            }
            if (!hasNextRecords) {
                nextRecords = 0;
            }
            boolean showBackButton = hasBackRecords || showDisabledNavigation;
            boolean bl2 = showNextButton = hasNextRecords || showDisabledNavigation;
            if (!SelectRangeChoiceBarRenderer.supportsNavigation(rc)) {
                showBackButton = false;
                showNextButton = false;
            }
            if (showAllActive = this.getShowAll(component, bean)) {
                prevRecords = 0;
                nextRecords = 0;
            }
            String prevOnClick = null;
            String nextOnClick = null;
            if (hasBackRecords || hasNextRecords) {
                SelectRangeChoiceBarRenderer.addHiddenFields(rc);
                ProcessUtils.renderNavSubmitScript(context, rc);
                ProcessUtils.renderNavChoiceSubmitScript(context, rc);
            }
            if (SelectRangeChoiceBarRenderer.supportsScripting(rc)) {
                if (hasBackRecords && !showAllActive) {
                    prevOnClick = ProcessUtils.getSubmitScriptCall(formName, source, backValue, validate);
                }
                if (hasNextRecords && !showAllActive) {
                    nextOnClick = ProcessUtils.getSubmitScriptCall(formName, source, nextValue, validate);
                }
            }
            ResponseWriter writer = context.getResponseWriter();
            boolean renderAsTable = SelectRangeChoiceBarRenderer.__renderAsTable(component);
            String iconID = null;
            if (PartialPageUtils.isPPRActive(context) && SelectRangeChoiceBarRenderer.isIE((RenderingContext)rc)) {
                iconID = id + "-i";
            }
            boolean renderedId = false;
            boolean isDesktop = false;
            if (renderAsTable) {
                isDesktop = rc.getAgent().getType().equals(Agent.TYPE_DESKTOP);
                if (!isDesktop) {
                    writer.startElement("div", component);
                    writer.writeAttribute("id", (Object)id, "id");
                }
                writer.startElement("table", component);
                OutputUtils.renderLayoutTableAttributes(context, rc, "0", null);
                this.renderAllAttributes(context, rc, component, bean);
                if (isDesktop) {
                    writer.writeAttribute("id", (Object)id, "id");
                }
                renderedId = true;
                writer.startElement("tr", null);
            }
            boolean narrowScreen = SelectRangeChoiceBarRenderer.supportsNarrowScreen(rc);
            if (showBackButton && !narrowScreen) {
                Icon prevIcon = this.getIcon(rc, false, prevOnClick != null);
                if (!prevIcon.isNull()) {
                    if (iconID != null) {
                        writer.startElement("td", component);
                        writer.writeAttribute("id", (Object)iconID, null);
                        PartialPageContext pprContext = rc.getPartialPageContext();
                        if (pprContext != null && pprContext.isInsidePartialTarget()) {
                            pprContext.addRenderedPartialTarget(iconID);
                        }
                    } else {
                        this._renderStartTableCell(writer, id, renderedId);
                        renderedId = true;
                    }
                    writer.writeAttribute("valign", (Object)"middle", null);
                    this._renderArrow(context, rc, prevIcon, false, prevOnClick);
                    writer.endElement("td");
                    this._renderSpacerCell(context, rc);
                }
                this._renderStartTableCell(writer, id, renderedId);
                renderedId = true;
                writer.writeAttribute("valign", (Object)"middle", null);
                writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
                this._renderLink(context, rc, false, prevOnClick, prevRecords, id, source, backValue);
                writer.endElement("td");
                this._renderSpacerCell(context, rc);
            }
            this._renderStartTableCell(writer, id, renderedId);
            renderedId = true;
            writer.writeAttribute("valign", (Object)"middle", null);
            writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
            this._renderChoice(context, rc, component, id, source, formName, minValue, currentValue, blockSize, maxValue, validate);
            writer.endElement("td");
            if (showNextButton && !narrowScreen) {
                this._renderSpacerCell(context, rc);
                this._renderStartTableCell(writer, id, true);
                writer.writeAttribute("valign", (Object)"middle", null);
                writer.writeAttribute("nowrap", (Object)Boolean.TRUE, null);
                this._renderLink(context, rc, true, nextOnClick, nextRecords, id, source, nextValue);
                writer.endElement("td");
                Icon nextIcon = this.getIcon(rc, true, nextOnClick != null);
                if (!nextIcon.isNull()) {
                    this._renderSpacerCell(context, rc);
                    this._renderStartTableCell(writer, id, true);
                    writer.writeAttribute("valign", (Object)"middle", null);
                    this._renderArrow(context, rc, nextIcon, true, nextOnClick);
                    writer.endElement("td");
                }
            }
            if (renderAsTable) {
                writer.endElement("tr");
                writer.endElement("table");
            }
            if (renderAsTable && !isDesktop) {
                writer.endElement("div");
            }
        }
        finally {
            this.setRowIndex(component, rowIndex);
        }
    }

    public static void addHiddenFields(RenderingContext rc) {
        FormData fData = rc.getFormData();
        fData.addNeededValue("event");
        fData.addNeededValue("source");
        fData.addNeededValue("partial");
        fData.addNeededValue("value");
    }

    private void _renderChoice(FacesContext context, RenderingContext rc, UIComponent component, String id, String source, String form, long minValue, long currentValue, int blockSize, long maxValue, boolean validate) throws IOException {
        UIComponent rangeLabel = this.getRangeLabel(component);
        boolean firstRowAvailable = this.isRowAvailable(component, 0);
        ResponseWriter writer = context.getResponseWriter();
        if (blockSize <= 0 || !firstRowAvailable || maxValue < minValue && maxValue != -1L) {
            writer.writeText((Object)XhtmlConstants.NBSP_STRING, null);
        } else {
            ArrayList<SelectItem> items = new ArrayList<SelectItem>(30);
            int selectedIndex = this._getItems(context, rc, component, items, minValue, maxValue, currentValue, blockSize, rangeLabel);
            int count = items.size();
            if (count > 1) {
                String choiceTip = rc.getTranslatedString(_CHOICE_TIP_KEY);
                String choiceId = XhtmlUtils.getCompositeId(id, _CHOICE_ID_SUFFIX);
                String onChange = ProcessUtils.getChoiceOnChangeFormSubmitted(form, source, validate);
                boolean javaScriptSupport = SelectRangeChoiceBarRenderer.supportsScripting(rc);
                writer.startElement("select", null);
                writer.writeAttribute("title", (Object)choiceTip, null);
                SelectRangeChoiceBarRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"AFFieldText");
                if (onChange != null && javaScriptSupport) {
                    writer.writeAttribute("onchange", (Object)onChange, null);
                    writer.writeAttribute("onfocus", (Object)_CHOICE_FORM_ON_FOCUS, null);
                }
                writer.writeAttribute("id", (Object)choiceId, null);
                if (!javaScriptSupport) {
                    writer.writeAttribute("name", (Object)choiceId, null);
                }
                this._writeSelectItems(context, items, selectedIndex);
                writer.endElement("select");
                if (HiddenLabelUtils.supportsHiddenLabels(rc)) {
                    HiddenLabelUtils.outputHiddenLabelIfNeeded(context, rc, choiceId, choiceTip, null);
                }
                if (!javaScriptSupport) {
                    String nameAttri = XhtmlUtils.getEncodedParameter("multipleValueParam") + XhtmlUtils.getEncodedParameter(choiceId) + XhtmlUtils.getEncodedParameter("source") + XhtmlUtils.getEncodedParameter(source) + XhtmlUtils.getEncodedParameter("event") + "goto";
                    SelectRangeChoiceBarRenderer.renderSubmitButtonNonJSBrowser(context, rc, "Go", nameAttri);
                } else {
                    writer.startElement("script", null);
                    SelectRangeChoiceBarRenderer.renderScriptDeferAttribute(context, rc);
                    SelectRangeChoiceBarRenderer.renderScriptTypeAttribute(context, rc);
                    writer.writeText((Object)"_setSelectIndexById(\"", null);
                    writer.writeText((Object)choiceId, null);
                    writer.writeText((Object)"\",", null);
                    writer.writeText((Object)IntegerUtils.getString((int)selectedIndex), null);
                    writer.writeText((Object)")", null);
                    writer.endElement("script");
                }
            } else if (count == 1) {
                writer.startElement("span", null);
                SelectRangeChoiceBarRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"AFFieldText");
                writer.writeText((Object)((SelectItem)items.get(0)).getLabel(), null);
                writer.endElement("span");
            }
        }
    }

    private void _writeSelectItems(FacesContext context, List<SelectItem> items, int selectedIndex) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        int count = items.size();
        for (int i = 0; i < count; ++i) {
            SelectItem item = items.get(i);
            writer.startElement("option", null);
            writer.writeAttribute("value", item.getValue(), null);
            if (i == selectedIndex) {
                writer.writeAttribute("selected", (Object)Boolean.TRUE, null);
            }
            writer.writeText((Object)item.getLabel(), null);
            writer.endElement("option");
        }
    }

    private int _getItems(FacesContext context, RenderingContext rc, UIComponent component, List<SelectItem> items, long minValue, long maxValue, long value, int blockSize, UIComponent rangeLabel) {
        boolean showAllActive;
        long maxBlockIndex;
        int selectedIndex = -1;
        boolean maxUnknown = maxValue == -1L;
        long blockIndex = (value - minValue + (long)blockSize - 1L) / (long)blockSize;
        int offset = (int)(value - (minValue + blockIndex * (long)blockSize));
        if (offset < 0) {
            offset += blockSize;
        }
        if (maxUnknown) {
            maxBlockIndex = blockIndex + 1L;
        } else {
            maxBlockIndex = (maxValue - minValue - (long)offset) / (long)blockSize;
            if (offset > 0) {
                ++maxBlockIndex;
            }
        }
        long firstBlockIndex = maxBlockIndex <= 29L || blockIndex <= 28L ? 0L : (blockIndex - 1L) / 28L * 28L;
        long lastBlockIndex = firstBlockIndex + 29L;
        if (lastBlockIndex > maxBlockIndex) {
            lastBlockIndex = maxBlockIndex;
        }
        if (((showAllActive = this.getShowAll(component, this.getFacesBean(component))) || !maxUnknown && lastBlockIndex > firstBlockIndex && maxBlockIndex <= 29L) && this.showAllSupported()) {
            items.add(this._createShowAllSelectItem(rc, maxValue));
            if (showAllActive) {
                selectedIndex = 0;
            }
        }
        for (blockIndex = firstBlockIndex; blockIndex <= lastBlockIndex; ++blockIndex) {
            int currentRecordSize;
            long blockStart = minValue + blockIndex * (long)blockSize;
            if (offset > 0) {
                blockStart += (long)(offset - blockSize);
            }
            if (blockStart < minValue) {
                blockStart = minValue;
                currentRecordSize = offset;
            } else {
                currentRecordSize = blockSize;
            }
            if (maxUnknown && !this.isRowAvailable(component, (int)blockStart - 1)) {
                return selectedIndex;
            }
            String text = blockIndex == firstBlockIndex && blockIndex != 0L ? rc.getTranslatedString(_PREVIOUS_TEXT_KEY) : (blockIndex == lastBlockIndex && (maxUnknown || lastBlockIndex < maxBlockIndex) ? rc.getTranslatedString(_MORE_TEXT_KEY) : null);
            long currValue = showAllActive ? minValue - 1L : value;
            SelectItem item = this._createNavigationItem(context, rc, component, blockStart, currentRecordSize, maxValue, text, rangeLabel);
            if (currValue >= blockStart && currValue < blockStart + (long)currentRecordSize) {
                selectedIndex = items.size();
            }
            items.add(item);
        }
        return selectedIndex;
    }

    private SelectItem _createShowAllSelectItem(RenderingContext arc, long maxValue) {
        String[] parameters = new String[]{IntegerUtils.getString((long)maxValue)};
        String showAllText = XhtmlUtils.getFormattedString(arc.getTranslatedString(_SHOW_ALL_KEY), parameters);
        return new SelectItem((Object)"all", showAllText);
    }

    private SelectItem _createNavigationItem(FacesContext context, RenderingContext rc, UIComponent component, long blockStart, int blockSize, long maxValue, String text, UIComponent rangeLabel) {
        if (text == null) {
            text = this._getRangeString(context, rc, component, blockStart, blockSize, maxValue, rangeLabel);
        }
        return new SelectItem((Object)IntegerUtils.getString((long)blockStart), text);
    }

    protected boolean disabledNavigationShown() {
        return true;
    }

    private void _renderLink(FacesContext context, RenderingContext rc, boolean isNext, String onclick, int records, String id, String source, long value) throws IOException {
        String text = this.getBlockString(rc, isNext, records);
        boolean isEnabled = onclick != null && records > 0;
        ResponseWriter writer = context.getResponseWriter();
        if (isEnabled) {
            writer.startElement("a", null);
            writer.writeURIAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)onclick, null);
            if (isNext) {
                String linkID = this._getIDForFocus(rc, id);
                writer.writeAttribute("id", (Object)linkID, null);
            }
            SelectRangeChoiceBarRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"OraNavBarActiveLink");
            writer.writeText((Object)text, null);
            writer.endElement("a");
        } else if (records < 1) {
            writer.startElement("span", null);
            SelectRangeChoiceBarRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"OraNavBarInactiveLink");
            writer.writeText((Object)text, null);
            writer.endElement("span");
        } else {
            String nameAttri = XhtmlUtils.getEncodedParameter("source") + XhtmlUtils.getEncodedParameter(source) + XhtmlUtils.getEncodedParameter("event") + XhtmlUtils.getEncodedParameter("goto") + XhtmlUtils.getEncodedParameter("value") + IntegerUtils.getString((long)value);
            writer.startElement("input", null);
            writer.writeAttribute("type", (Object)"submit", null);
            writer.writeAttribute("name", (Object)nameAttri, null);
            writer.writeAttribute("value", (Object)text, "text");
            SelectRangeChoiceBarRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|commandButton");
            writer.writeAttribute("style", (Object)"border:none;background:inherit;text-decoration:underline;", null);
            writer.endElement("input");
        }
    }

    protected Icon getIcon(RenderingContext rc, boolean isNext, boolean isEnabled) {
        String iconName = isNext ? (isEnabled ? "af|selectRangeChoiceBar::next-icon" : "af|selectRangeChoiceBar::next-disabled-icon") : (isEnabled ? "af|selectRangeChoiceBar::prev-icon" : "af|selectRangeChoiceBar::prev-disabled-icon");
        return rc.getIcon(iconName);
    }

    protected String getIconTitleKey(boolean isNext, boolean isEnabled) {
        if (isNext) {
            return isEnabled ? _NEXT_DESC_KEY : _DISABLED_NEXT_DESC_KEY;
        }
        return isEnabled ? _PREVIOUS_DESC_KEY : _DISABLED_PREVIOUS_DESC_KEY;
    }

    private void _renderArrow(FacesContext context, RenderingContext rc, Icon icon, boolean isNext, String onclick) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (onclick != null) {
            writer.startElement("a", null);
            writer.writeURIAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)onclick, null);
        }
        boolean isEnabled = onclick != null;
        String titleKey = this.getIconTitleKey(isNext, isEnabled);
        String title = rc.getTranslatedString(titleKey);
        OutputUtils.renderIcon(context, rc, icon, title, null);
        if (onclick != null) {
            writer.endElement("a");
        }
    }

    protected String getBlockString(RenderingContext rc, boolean isNext, int numRecords) {
        if (numRecords > 0) {
            String pattern = isNext ? rc.getTranslatedString("af_selectRangeChoiceBar.NEXT") : rc.getTranslatedString("af_selectRangeChoiceBar.PREVIOUS");
            String value = IntegerUtils.getString((int)numRecords);
            return XhtmlUtils.getFormattedString(pattern, new String[]{value});
        }
        String text = isNext ? rc.getTranslatedString("af_selectRangeChoiceBar.DISABLED_NEXT") : rc.getTranslatedString("af_selectRangeChoiceBar.DISABLED_PREVIOUS");
        return text;
    }

    private String _getRangeString(FacesContext context, RenderingContext rc, UIComponent component, long start, int visibleItemCount, long total, UIComponent rangeLabel) {
        long currVisible;
        long l = currVisible = total == -1L ? (long)visibleItemCount : total - start + 1L;
        if (currVisible > (long)visibleItemCount) {
            currVisible = visibleItemCount;
        }
        if (rangeLabel != null && (rangeLabel instanceof UISelectItem || rangeLabel instanceof UIXSelectItem)) {
            String label;
            Range range = new Range();
            this.setRowIndex(component, (int)start - 1);
            Object startRow = this.getRowData(component);
            range.setStart(startRow);
            int endIndex = (int)(start + currVisible - 2L);
            endIndex = this._setToExistingEndRow(component, (int)start - 1, endIndex);
            this.setRowIndex(component, endIndex);
            range.setEnd(this.getRowData(component));
            Range old = null;
            String var = this.getVar(component, this.getFacesBean(component));
            if (var != null) {
                Map requestMap = context.getExternalContext().getRequestMap();
                old = requestMap.put(var, range);
            }
            String string = label = rangeLabel instanceof UISelectItem ? ((UISelectItem)rangeLabel).getItemLabel() : SelectRangeChoiceBarRenderer.toString(((UIXSelectItem)rangeLabel).getAttributes().get("label"));
            if (var != null) {
                Map requestMap = context.getExternalContext().getRequestMap();
                if (old == null) {
                    requestMap.remove(var);
                } else {
                    requestMap.put(var, old);
                }
            }
            return label;
        }
        String startParam = IntegerUtils.getString((long)start);
        int endIndex = (int)(start + currVisible - 2L);
        endIndex = this._setToExistingEndRow(component, (int)start - 1, endIndex);
        String endParam = IntegerUtils.getString((int)(endIndex + 1));
        String pattern = null;
        String[] parameters = null;
        if (total == -1L) {
            pattern = rc.getTranslatedString(_MULTI_RANGE_NO_TOTAL_FORMAT_STRING);
            parameters = new String[]{startParam, endParam};
        } else {
            pattern = rc.getTranslatedString(_MULTI_RANGE_TOTAL_FORMAT_STRING);
            parameters = new String[]{startParam, endParam, IntegerUtils.getString((long)total)};
        }
        return XhtmlUtils.getFormattedString(pattern, parameters);
    }

    private int _setToExistingEndRow(UIComponent component, int startRowIndex, int endRowIndex) {
        boolean rowAvailable = this.isRowAvailable(component, endRowIndex);
        while (!rowAvailable && endRowIndex >= startRowIndex) {
            rowAvailable = this.isRowAvailable(component, --endRowIndex);
        }
        return endRowIndex;
    }

    static boolean __renderAsTable(UIComponent component) {
        UIComponent parent = XhtmlUtils.getStructuralParent(component);
        return !(parent instanceof UIXPanel) || !"org.apache.myfaces.trinidad.ButtonBar".equals(parent.getRendererType()) && !"org.apache.myfaces.trinidad.rich.ButtonBar".equals(parent.getRendererType());
    }

    protected void renderItemSpacer(FacesContext context, RenderingContext rc) throws IOException {
        if (SelectRangeChoiceBarRenderer.isPDA((RenderingContext)rc)) {
            context.getResponseWriter().writeText((Object)XhtmlConstants.NBSP_STRING, null);
        } else {
            this.renderSpacer(context, rc, "5", "1");
        }
    }

    private void _renderSpacerCell(FacesContext context, RenderingContext rc) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("td", null);
        this.renderItemSpacer(context, rc);
        writer.endElement("td");
    }

    private void _renderStartTableCell(ResponseWriter writer, String id, boolean alreadyRenderedId) throws IOException {
        writer.startElement("td", null);
        if (!alreadyRenderedId) {
            writer.writeAttribute("id", (Object)id, null);
        }
    }

    private String _getIDForFocus(RenderingContext rc, String baseId) {
        Object initialFocusID = rc.getProperties().get(XhtmlConstants.INITIAL_FOCUS_CONTEXT_PROPERTY);
        String id = null;
        if (initialFocusID != null && initialFocusID.equals(baseId)) {
            String focus = "-focus";
            StringBuilder buffer = new StringBuilder(baseId.length() + focus.length());
            buffer.append(baseId);
            buffer.append(focus);
            id = buffer.toString();
            rc.getProperties().put(XhtmlConstants.INITIAL_FOCUS_CONTEXT_PROPERTY, id);
        }
        return id;
    }
}

