/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.convert;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.convert.ClientConverter;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.text.RGBColorFormat;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;
import org.apache.myfaces.trinidadinternal.util.JsonUtils;

public class ColorConverter
extends org.apache.myfaces.trinidad.convert.ColorConverter
implements ClientConverter {
    private static final Collection<String> _IMPORT_NAMES = Collections.singletonList("ColorFormat()");
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ColorConverter.class);
    private static final String _PATTERN_WRITTEN_KEY = "org.apache.myfaces.trinidadinternal.convert.ColorConverter._PATTERN_WRITTEN";

    public String getClientLibrarySource(FacesContext context) {
        return null;
    }

    public Collection<String> getClientImportNames() {
        return _IMPORT_NAMES;
    }

    public String getClientScript(FacesContext context, UIComponent component) {
        if (component == null) {
            _LOG.severe("NEEDED_COMPONENT_NULL_NO_SCRIPT_WRITTEN");
            return null;
        }
        String clientId = component.getClientId(context);
        if (clientId != null) {
            StringBuilder buff = new StringBuilder();
            Map requestMap = context.getExternalContext().getRequestMap();
            if (requestMap.get(_PATTERN_WRITTEN_KEY) == null) {
                requestMap.put(_PATTERN_WRITTEN_KEY, Boolean.TRUE);
                buff.append("_cfTrans=");
                try {
                    JsonUtils.writeString(buff, this.getTransparentString(context), true);
                }
                catch (IOException e) {
                    _LOG.severe((Throwable)e);
                }
                buff.append(";");
                buff.append("if(window['_cfs']==undefined){window['_cfs']=new Object();window['_cfts']=new Object();}");
            }
            String[] patterns = this.getPatterns();
            buff.append("_cfs[\"");
            buff.append(clientId);
            buff.append("\"]=");
            if (patterns.length == 1) {
                buff.append("\"");
                buff.append(patterns[0]);
                buff.append("\"");
            } else {
                buff.append("new Array(");
                for (int i = 0; i < patterns.length; ++i) {
                    buff.append("\"");
                    buff.append(patterns[i]);
                    buff.append("\"");
                    if (i >= patterns.length - 1) continue;
                    buff.append(",");
                }
                buff.append(")");
            }
            buff.append(";");
            if (this.isTransparentAllowed()) {
                buff.append("_cfts[\"");
                buff.append(clientId);
                buff.append("\"]=true;");
            }
            return buff.toString();
        }
        _LOG.severe("NULL_CLIENT_ID_NO_SCRIPT_RENDERED");
        return null;
    }

    public String getClientConversion(FacesContext context, UIComponent component) {
        String hint;
        StringBuilder sb = new StringBuilder();
        StringBuilder patterns = new StringBuilder();
        String[] setPatterns = this.getPatterns();
        for (int i = 0; i < setPatterns.length; ++i) {
            patterns.append(setPatterns[i]);
            patterns.append(' ');
        }
        String patternsString = patterns.toString();
        sb.append("new TrColorConverter(");
        this._appendPatternsArg(sb);
        if (this.isTransparentAllowed()) {
            sb.append(",true,'");
        } else {
            sb.append(",false,'");
        }
        sb.append(XhtmlLafUtils.escapeJS(patternsString));
        HashMap<String, String> messages = new HashMap<String, String>();
        String convMsgDet = this.getMessageDetailConvert();
        if (convMsgDet != null) {
            messages.put("detail", convMsgDet);
        }
        if ((hint = this.getHint()) != null) {
            messages.put("hint", hint);
        }
        sb.append("',");
        try {
            JsonUtils.writeMap(sb, messages, false);
        }
        catch (IOException e) {
            sb.append("null");
        }
        sb.append(')');
        return sb.toString();
    }

    public int getColumns(FacesContext context) {
        int columns = 0;
        if (this.isTransparentAllowed()) {
            columns = this.getTransparentString(context).length();
        }
        String[] patterns = this.getPatterns();
        for (int i = 0; i < patterns.length; ++i) {
            columns = Math.max(columns, new RGBColorFormat(patterns[i]).length());
        }
        return columns;
    }

    private void _appendPatternsArg(StringBuilder buffer) {
        String[] patterns = this.getPatterns();
        int count = patterns.length;
        if (count == 1) {
            buffer.append("'");
            buffer.append(patterns[0]);
            buffer.append("'");
        } else {
            buffer.append("new Array(");
            for (int i = 0; i < count; ++i) {
                buffer.append("'");
                buffer.append(patterns[i]);
                buffer.append("'");
                if (i >= count - 1) continue;
                buffer.append(",");
            }
            buffer.append(")");
        }
    }
}

