/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.pda;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.component.UIXProcess;
import org.apache.myfaces.trinidad.component.core.nav.CoreTrain;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class TrainRenderer
extends XhtmlRenderer {
    private static final String _STEP_TEXT_KEY = "af_train.STEP";
    private static final String _SINGLE_RANGE_FORMAT_TOTAL_STRING = "af_train.FORMAT_TOTAL";
    private static final String _SINGLE_RANGE_FORMAT_NO_TOTAL_STRING = "af_train.FORMAT_NO_TOTAL";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(TrainRenderer.class);

    public TrainRenderer() {
        super(CoreTrain.TYPE);
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        if (rc.getFormData() == null) {
            _LOG.warning("TRAIN_MUST_INSIDE_FORM");
            return;
        }
        UIXProcess process = (UIXProcess)component;
        UIComponent stamp = process.getNodeStamp();
        if (stamp != null) {
            Object oldPath = process.getRowKey();
            boolean isNewPath = this._setNewPath(process);
            if (isNewPath) {
                String[] parameters;
                String pattern;
                int selectedIndex = process.getRowIndex();
                int length = process.getRowCount();
                ++selectedIndex;
                if (length == -1) {
                    pattern = rc.getTranslatedString(_SINGLE_RANGE_FORMAT_NO_TOTAL_STRING);
                    parameters = new String[]{rc.getTranslatedString(_STEP_TEXT_KEY), IntegerUtils.getString((int)selectedIndex)};
                } else {
                    pattern = rc.getTranslatedString(_SINGLE_RANGE_FORMAT_TOTAL_STRING);
                    parameters = new String[]{rc.getTranslatedString(_STEP_TEXT_KEY), IntegerUtils.getString((int)selectedIndex), IntegerUtils.getString((int)length)};
                }
                ResponseWriter writer = context.getResponseWriter();
                writer.startElement("span", component);
                this.renderInlineStyle(context, rc, component, bean);
                String outputText = XhtmlUtils.getFormattedString(pattern, parameters);
                writer.writeText((Object)outputText, null);
                writer.endElement("span");
                process.setRowKey(oldPath);
            }
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    private boolean _setNewPath(UIXProcess component) {
        Object focusPath = component.getFocusRowKey();
        component.setRowKey(focusPath);
        return true;
    }
}

