/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.render;

import java.io.IOException;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.component.UIXForm;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.render.CoreRenderer;
import org.apache.myfaces.trinidad.util.ComponentUtils;

public class RenderUtils {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RenderUtils.class);

    private RenderUtils() {
    }

    public static void encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        if (component.isRendered()) {
            component.encodeBegin(context);
            if (component.getRendersChildren()) {
                component.encodeChildren(context);
            } else if (component.getChildCount() > 0) {
                for (UIComponent child : component.getChildren()) {
                    RenderUtils.encodeRecursive(context, child);
                }
            }
            component.encodeEnd(context);
        }
    }

    public static String getFormId(FacesContext context, UIComponent component) {
        UIComponent form = null;
        while (component != null) {
            if (component instanceof UIForm || component instanceof UIXForm) {
                form = component;
                break;
            }
            component = component.getParent();
        }
        if (form == null) {
            return null;
        }
        return form.getClientId(context);
    }

    public static String getRelativeId(FacesContext context, UIComponent from, String scopedId) {
        if (from == null) {
            return null;
        }
        if (scopedId == null || scopedId.length() == 0) {
            return null;
        }
        int colonCount = RenderUtils._getColonCount(scopedId);
        if (colonCount == 1) {
            return scopedId.substring(1);
        }
        if (colonCount == 0 && !(from instanceof NamingContainer)) {
            return RenderUtils._getRelativeId(context, from, scopedId, colonCount);
        }
        UIComponent component = ComponentUtils.findRelativeComponent(from, scopedId);
        if (component == null && from instanceof NamingContainer && (component = ComponentUtils.findRelativeComponent(from.getParent(), scopedId)) != null) {
            _LOG.warning("DEPRECATED_RELATIVE_ID_SYNTAX", new Object[]{scopedId, from});
        }
        if (component == null) {
            return RenderUtils._getRelativeId(context, from, scopedId, colonCount);
        }
        return component.getClientId(context);
    }

    public static String getRendererClientId(FacesContext context, UIComponent component) {
        Renderer renderer;
        String clientId = component.getClientId(context);
        String family = component.getFamily();
        String rendererType = component.getRendererType();
        if (rendererType != null && (renderer = context.getRenderKit().getRenderer(family, rendererType)) instanceof CoreRenderer) {
            CoreRenderer coreRenderer = (CoreRenderer)renderer;
            String rendererClientId = coreRenderer.getClientId(context, component);
            return rendererClientId == null ? clientId : rendererClientId;
        }
        return clientId;
    }

    private static String _getRelativeId(FacesContext context, UIComponent from, String relativeId, int colonCount) {
        if (colonCount == 1) {
            return relativeId.substring(1);
        }
        if (colonCount > 1) {
            relativeId = relativeId.substring(colonCount);
        }
        if (!(from instanceof NamingContainer)) {
            from = RenderUtils._getParentNamingContainer(from);
        }
        for (int j = 1; j < colonCount; ++j) {
            from = RenderUtils._getParentNamingContainer(from);
        }
        if (from == null) {
            return relativeId;
        }
        return from.getClientId(context) + ':' + relativeId;
    }

    private static UIComponent _getParentNamingContainer(UIComponent from) {
        while (from != null && from.getParent() != null) {
            if (!((from = from.getParent()) instanceof NamingContainer)) continue;
            return from;
        }
        return null;
    }

    private static int _getColonCount(String relativeId) {
        int colonCount;
        int idLength = relativeId.length();
        for (colonCount = 0; colonCount < idLength && relativeId.charAt(colonCount) == ':'; ++colonCount) {
        }
        return colonCount;
    }
}

