/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.xml;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.share.xml.XMLProvider;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class JaxpXMLProvider
implements XMLProvider {
    private static final SAXParserFactory _SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
    private static final TrinidadLogger _LOG;

    public XMLReader getXMLReader() {
        try {
            return _SAX_PARSER_FACTORY.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException pce) {
            _LOG.severe((Throwable)pce);
        }
        catch (SAXException saxe) {
            throw new UndeclaredThrowableException(saxe);
        }
        catch (Error e) {
            _LOG.severe((Throwable)e);
        }
        return null;
    }

    public Document parseDocument(InputSource source) throws IOException, SAXException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(source);
        }
        catch (ParserConfigurationException pce) {
            _LOG.severe((Throwable)pce);
        }
        catch (Error e) {
            _LOG.severe((Throwable)e);
        }
        return null;
    }

    static {
        _SAX_PARSER_FACTORY.setNamespaceAware(true);
        _LOG = TrinidadLogger.createTrinidadLogger(JaxpXMLProvider.class);
    }
}

