/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.tag.MetaRule;
import com.sun.facelets.tag.Metadata;
import com.sun.facelets.tag.MetadataTarget;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagAttributeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

class LocalePropertyTagRule
extends MetaRule {
    static LocalePropertyTagRule Instance = new LocalePropertyTagRule();
    private static final Class<? extends Locale> _LOCALE_TYPE = Locale.class;

    LocalePropertyTagRule() {
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method m;
        if (meta.getPropertyType(name) == _LOCALE_TYPE && attribute.isLiteral() && (m = meta.getWriteMethod(name)) != null) {
            return new LiteralPropertyMetadata(m, attribute);
        }
        return null;
    }

    private static class LiteralPropertyMetadata
    extends Metadata {
        private final Method _method;
        private final TagAttribute _attribute;
        private Object[] _params;

        public LiteralPropertyMetadata(Method method, TagAttribute attribute) {
            this._method = method;
            this._attribute = attribute;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            if (this._params == null) {
                Locale loc = new Locale(this._attribute.getValue(ctx));
                this._params = new Object[]{loc};
            }
            try {
                this._method.invoke(instance, this._params);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this._attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this._attribute, (Throwable)e);
            }
        }
    }
}

