/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.component;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.ContextCallback;
import javax.faces.component.NamingContainer;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRemoveFromViewEvent;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.render.RenderKit;
import javax.faces.render.Renderer;
import org.apache.myfaces.trinidad.bean.AttachedObjects;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.FacesBeanFactory;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.bean.util.StateUtils;
import org.apache.myfaces.trinidad.bean.util.ValueMap;
import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.RowKeySetAttributeChange;
import org.apache.myfaces.trinidad.component.ChildArrayList;
import org.apache.myfaces.trinidad.component.ComponentProcessingContext;
import org.apache.myfaces.trinidad.component.CompositeIterator;
import org.apache.myfaces.trinidad.component.FacesBeanWrapper;
import org.apache.myfaces.trinidad.component.FacetHashMap;
import org.apache.myfaces.trinidad.component.MethodBindingMethodExpression;
import org.apache.myfaces.trinidad.component.TreeState;
import org.apache.myfaces.trinidad.component.UIXComponent;
import org.apache.myfaces.trinidad.component.UIXFacesBean;
import org.apache.myfaces.trinidad.component.UIXFacesBeanImpl;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.AttributeChangeEvent;
import org.apache.myfaces.trinidad.event.AttributeChangeListener;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.render.ExtendedRenderer;
import org.apache.myfaces.trinidad.render.LifecycleRenderer;
import org.apache.myfaces.trinidad.util.CollectionUtils;
import org.apache.myfaces.trinidad.util.ThreadLocalUtils;

public abstract class UIXComponentBase
extends UIXComponent {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(UIXComponentBase.class);
    public static final FacesBean.Type TYPE = UIXComponentBase._createType();
    public static final PropertyKey ID_KEY = TYPE.registerKey("id", String.class, 1);
    public static final PropertyKey RENDERED_KEY = TYPE.registerKey("rendered", Boolean.class, Boolean.TRUE);
    public static final PropertyKey BINDING_KEY = TYPE.registerKey("binding");
    public static final PropertyKey TRANSIENT_KEY = TYPE.registerKey("transient", Boolean.class, 3);
    public static final PropertyKey RENDERER_TYPE_KEY = TYPE.registerKey("rendererType", String.class, 1);
    private static final PropertyKey _LISTENERS_KEY = TYPE.registerKey("listeners", FacesListener[].class, 4);
    private static final PropertyKey _ATTRIBUTE_CHANGE_LISTENER_KEY = TYPE.registerKey("attributeChangeListener", MethodExpression.class);
    private static final PropertyKey _CLIENT_BEHAVIORS_KEY = TYPE.registerKey("clientBehaviors", AttachedObjects.class, 25);
    private static final PropertyKey _SYSTEM_EVENT_LISTENERS_KEY = TYPE.registerKey("systemEventListeners", AttachedObjects.class, 25);
    private FacesBean _facesBean;
    private List<UIComponent> _children;
    private Map<String, Object> _attributes;
    private Map<String, UIComponent> _facets;
    private UIComponent _parent;
    private String _id;
    private String _clientId;
    private boolean _usesFacesBeanImpl;
    private transient Renderer _cachedRenderer = _UNDEFINED_RENDERER;
    private transient LifecycleRenderer _cachedLifecycleRenderer = _UNDEFINED_LIFECYCLE_RENDERER;
    private static final Iterator<String> _EMPTY_STRING_ITERATOR;
    private static final Iterator<UIComponent> _EMPTY_UICOMPONENT_ITERATOR;
    private static final ThreadLocal<StringBuilder> _STRING_BUILDER;
    private static final String _NO_SUBTREE_CHANGE_ATTR = "_trinNoSubtreeChange";
    private static final ClientIdCaching _CLIENT_ID_CACHING;
    private static final String _SYSTEM_PROP_CLIENT_ID_CACHING = "org.apache.myfaces.trinidad.CLIENT_ID_CACHING";
    private static final String _WARNED_CLIENT_ID_CACHING_KEY = "org.apache.myfaces.trinidad.WARNED_CLIENT_ID_CACHING";
    private static final LifecycleRenderer _UNDEFINED_LIFECYCLE_RENDERER;
    private static final Renderer _UNDEFINED_RENDERER;

    public UIXComponentBase() {
    }

    public UIXComponentBase(String rendererType) {
        this.setRendererType(rendererType);
    }

    protected FacesBean createFacesBean(String rendererType) {
        FacesBean bean = FacesBeanFactory.createFacesBean(((Object)((Object)this)).getClass(), rendererType);
        UIXFacesBean uixBean = (UIXFacesBean)bean;
        uixBean.init(this, this.getBeanType());
        return uixBean;
    }

    protected PropertyKey getPropertyKey(String name) {
        PropertyKey key = this.getBeanType().findKey(name);
        if (key == null) {
            key = PropertyKey.createPropertyKey(name);
        }
        return key;
    }

    protected FacesBean.Type getBeanType() {
        return TYPE;
    }

    @Override
    public FacesBean getFacesBean() {
        if (this._facesBean == null) {
            this._init(null);
        }
        return this._facesBean;
    }

    @Override
    public String getContainerClientId(FacesContext context, UIComponent child) {
        return this.getContainerClientId(context);
    }

    @Override
    public void addAttributeChangeListener(AttributeChangeListener acl) {
        this.addFacesListener(acl);
    }

    @Override
    public void removeAttributeChangeListener(AttributeChangeListener acl) {
        this.removeFacesListener(acl);
    }

    @Override
    public AttributeChangeListener[] getAttributeChangeListeners() {
        return (AttributeChangeListener[])this.getFacesListeners(AttributeChangeListener.class);
    }

    @Override
    public void setAttributeChangeListener(MethodExpression mb) {
        this.setProperty(_ATTRIBUTE_CHANGE_LISTENER_KEY, mb);
    }

    @Deprecated
    public void setAttributeChangeListener(MethodBinding mb) {
        this.setAttributeChangeListener(UIXComponentBase.adaptMethodBinding(mb));
    }

    @Override
    public MethodExpression getAttributeChangeListener() {
        return (MethodExpression)this.getProperty(_ATTRIBUTE_CHANGE_LISTENER_KEY);
    }

    public ValueExpression getValueExpression(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        PropertyKey key = this.getPropertyKey(name);
        if (!key.getSupportsBinding()) {
            return null;
        }
        return this.getFacesBean().getValueExpression(key);
    }

    public void setValueExpression(String name, ValueExpression expression) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (expression != null && expression.isLiteralText()) {
            ELContext context = FacesContext.getCurrentInstance().getELContext();
            this.getAttributes().put(name, expression.getValue(context));
        } else {
            PropertyKey key = this.getPropertyKey(name);
            this.getFacesBean().setValueExpression(key, expression);
        }
    }

    public ValueBinding getValueBinding(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        PropertyKey key = this.getPropertyKey(name);
        if (!key.getSupportsBinding()) {
            return null;
        }
        return this.getFacesBean().getValueBinding(key);
    }

    public void setValueBinding(String name, ValueBinding binding) {
        if (name == null) {
            throw new NullPointerException();
        }
        PropertyKey key = this.getPropertyKey(name);
        this.getFacesBean().setValueBinding(key, binding);
    }

    public Map<String, Object> getAttributes() {
        if (this._attributes == null) {
            this._init(null);
        }
        return this._attributes;
    }

    @Override
    protected Iterator<UIComponent> getRenderedFacetsAndChildren(FacesContext facesContext) {
        this._cacheRenderer(facesContext);
        return super.getRenderedFacetsAndChildren(facesContext);
    }

    protected void setupFlattenedContext(FacesContext facesContext, ComponentProcessingContext cpContext) {
        if (cpContext.getHints().contains((Object)ComponentProcessingContext.ProcessingHint.PROCESS_FOR_ENCODING)) {
            this.setupEncodingContext(facesContext, RenderingContext.getCurrentInstance());
        } else {
            this.setupVisitingContext(facesContext);
        }
    }

    protected void setupFlattenedChildrenContext(FacesContext facesContext, ComponentProcessingContext cpContext) {
        if (cpContext.getHints().contains((Object)ComponentProcessingContext.ProcessingHint.PROCESS_FOR_ENCODING)) {
            this.setupChildrenEncodingContext(facesContext, RenderingContext.getCurrentInstance());
        } else {
            this.setupChildrenVisitingContext(facesContext);
        }
    }

    protected void tearDownFlattenedContext(FacesContext facesContext, ComponentProcessingContext cpContext) {
        if (cpContext.getHints().contains((Object)ComponentProcessingContext.ProcessingHint.PROCESS_FOR_ENCODING)) {
            this.tearDownEncodingContext(facesContext, RenderingContext.getCurrentInstance());
        } else {
            this.tearDownVisitingContext(facesContext);
        }
    }

    protected void tearDownFlattenedChildrenContext(FacesContext facesContext, ComponentProcessingContext cpContext) {
        if (cpContext.getHints().contains((Object)ComponentProcessingContext.ProcessingHint.PROCESS_FOR_ENCODING)) {
            this.tearDownChildrenEncodingContext(facesContext, RenderingContext.getCurrentInstance());
        } else {
            this.tearDownChildrenVisitingContext(facesContext);
        }
    }

    private String _calculateClientId(FacesContext context) {
        Renderer renderer;
        String clientId = this.getId();
        for (UIComponent containerComponent = this.getParent(); null != containerComponent; containerComponent = containerComponent.getParent()) {
            if (!(containerComponent instanceof NamingContainer)) continue;
            String contClientId = containerComponent instanceof UIXComponent ? ((UIXComponent)containerComponent).getContainerClientId(context, this) : containerComponent.getContainerClientId(context);
            StringBuilder bld = UIXComponentBase.__getSharedStringBuilder();
            bld.append(contClientId).append(':').append(clientId);
            clientId = bld.toString();
            break;
        }
        if (null != (renderer = this.getRenderer(context))) {
            clientId = renderer.convertClientId(context, clientId);
        }
        return clientId;
    }

    public String getClientId(FacesContext context) {
        if (UIXComponentBase._isClientIdCachingEnabled()) {
            String clientId = this._clientId;
            if (clientId == null) {
                if (this._parent == null) {
                    _LOG.warning("INVALID_CALL_TO_GETCLIENTID", this.getId());
                    return this._calculateClientId(context);
                }
                clientId = this._calculateClientId(context);
                if (this._usesFacesBeanImpl) {
                    this._clientId = clientId;
                }
            } else if (UIXComponentBase._isClientIdDebuggingEnabled()) {
                UIXComponentBase._warnClientIdCachingConfig(context);
                String realID = this._calculateClientId(context);
                if (!clientId.equals(realID)) {
                    throw new IllegalStateException(String.format("Cached client id %s for %s doesn't match client id: %s", new Object[]{clientId, this, realID}));
                }
            }
            return clientId;
        }
        UIXComponentBase._warnClientIdCachingConfig(context);
        return this._calculateClientId(context);
    }

    public String getId() {
        if (this._usesFacesBeanImpl) {
            if (this._id == null) {
                this._id = FacesContext.getCurrentInstance().getViewRoot().createUniqueId();
            }
            return this._id;
        }
        FacesBean facesBean = this.getFacesBean();
        String id = (String)facesBean.getProperty(ID_KEY);
        if (id == null) {
            id = FacesContext.getCurrentInstance().getViewRoot().createUniqueId();
            facesBean.setProperty(ID_KEY, id);
        }
        return id;
    }

    public void setId(String id) {
        FacesBean facesBean = this.getFacesBean();
        if (this._usesFacesBeanImpl) {
            if (this._id == null || !this._id.equals(id)) {
                this._validateId(id);
                this._id = id;
                if (this._clientId != null && this instanceof NamingContainer) {
                    UIXComponentBase.clearCachedClientIds(this);
                }
            }
        } else {
            this._validateId(id);
            facesBean.setProperty(ID_KEY, id);
        }
        this._clientId = null;
    }

    public abstract String getFamily();

    public UIComponent getParent() {
        return this._parent;
    }

    public void setParent(UIComponent parent) {
        if (parent != this._parent) {
            if (parent != null) {
                this._parent = parent;
                this._resetClientId();
                if (parent.isInView()) {
                    this._publishPostAddToViewEvent(this.getFacesContext(), this);
                }
            } else {
                if (this._parent != null && this._parent.isInView()) {
                    this._publishPreRemoveFromViewEvent(this.getFacesContext(), this);
                }
                this._parent = parent;
                this._resetClientId();
            }
        }
    }

    private void _resetClientId() {
        String newClientId;
        if (this._clientId != null && !this._clientId.equals(newClientId = this._calculateClientId(FacesContext.getCurrentInstance()))) {
            this.clearCachedClientIds();
            this._clientId = newClientId;
        }
    }

    public boolean isRendered() {
        return this.getBooleanProperty(RENDERED_KEY, true);
    }

    public void setRendered(boolean rendered) {
        this.setBooleanProperty(RENDERED_KEY, rendered);
    }

    public boolean isTransient() {
        return this.getBooleanProperty(TRANSIENT_KEY, false);
    }

    public void setTransient(boolean newTransient) {
        this.setBooleanProperty(TRANSIENT_KEY, newTransient);
    }

    public String getRendererType() {
        if (this._facesBean == null) {
            return null;
        }
        return (String)this.getProperty(RENDERER_TYPE_KEY);
    }

    public void setRendererType(String rendererType) {
        String oldRendererType = this.getRendererType();
        if (oldRendererType == null ? rendererType == null : oldRendererType.equals(rendererType)) {
            return;
        }
        this._init(rendererType);
        this.setProperty(RENDERER_TYPE_KEY, rendererType);
    }

    public boolean getRendersChildren() {
        Renderer renderer = this.getRenderer(this.getFacesContext());
        if (renderer == null) {
            return false;
        }
        return renderer.getRendersChildren();
    }

    public UIComponent findComponent(String id) {
        int separatorIndex;
        String searchId;
        if (id == null) {
            throw new NullPointerException();
        }
        if ("".equals(id)) {
            throw new IllegalArgumentException();
        }
        UIXComponentBase from = this;
        if (id.charAt(0) == ':') {
            id = id.substring(1);
            while (from.getParent() != null) {
                from = from.getParent();
            }
        } else if (!(this instanceof NamingContainer)) {
            while (from.getParent() != null && !((from = from.getParent()) instanceof NamingContainer)) {
            }
        }
        if (!(searchId = (separatorIndex = id.indexOf(58)) < 0 ? id : id.substring(0, separatorIndex)).equals(from.getId())) {
            from = UIXComponentBase._findInsideOf(from, searchId);
        }
        if (separatorIndex < 0) {
            return from;
        }
        if (from == null) {
            return null;
        }
        if (!(from instanceof NamingContainer)) {
            throw new IllegalArgumentException();
        }
        return from.findComponent(id.substring(separatorIndex + 1));
    }

    public List<UIComponent> getChildren() {
        if (this._children == null) {
            this._children = new ChildArrayList(this);
        }
        return this._children;
    }

    public int getChildCount() {
        if (this._children == null) {
            return 0;
        }
        return this.getChildren().size();
    }

    public Map<String, UIComponent> getFacets() {
        if (this._facets == null) {
            this._facets = new FacetHashMap(this);
        }
        return this._facets;
    }

    public UIComponent getFacet(String facetName) {
        if (facetName == null) {
            throw new NullPointerException();
        }
        if (this._facets == null) {
            return null;
        }
        return this.getFacets().get(facetName);
    }

    public Iterator<String> getFacetNames() {
        if (this._facets == null) {
            return _EMPTY_STRING_ITERATOR;
        }
        return this._facets.keySet().iterator();
    }

    public Iterator<UIComponent> getFacetsAndChildren() {
        if (this._facets == null) {
            if (this._children == null) {
                return _EMPTY_UICOMPONENT_ITERATOR;
            }
            return this._children.iterator();
        }
        if (this._children == null) {
            return this._facets.values().iterator();
        }
        return new CompositeIterator<UIComponent>(this._children.iterator(), this._facets.values().iterator());
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        RequestContext adfContext;
        UIComponent component;
        if (event == null) {
            throw new NullPointerException();
        }
        if (_LOG.isFine()) {
            _LOG.fine("Broadcasting event " + event + " to " + (Object)((Object)this));
        }
        if ((component = event.getComponent()) != null && this.satisfiesPartialTrigger(event) && (adfContext = RequestContext.getCurrentInstance()) != null) {
            adfContext.partialUpdateNotify(component);
        }
        Iterator<? extends Object> iter = this.getFacesBean().entries(_LISTENERS_KEY);
        while (iter.hasNext()) {
            FacesListener listener = (FacesListener)iter.next();
            if (!event.isAppropriateListener(listener)) continue;
            event.processListener(listener);
        }
        if (event instanceof AttributeChangeEvent) {
            this.broadcastToMethodExpression(event, this.getAttributeChangeListener());
        }
    }

    protected boolean satisfiesPartialTrigger(FacesEvent event) {
        return true;
    }

    public void decode(FacesContext context) {
        RequestContext adfContext;
        if (context == null) {
            throw new NullPointerException();
        }
        Map<String, Object> attrs = this.getAttributes();
        Object triggers = attrs.get("partialTriggers");
        if (triggers instanceof String[] && (adfContext = RequestContext.getCurrentInstance()) != null) {
            adfContext.addPartialTriggerListeners(this, (String[])triggers);
        }
        this.__rendererDecode(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.pushComponentToEL(context, this);
        if (!this.isRendered()) {
            return;
        }
        context.getApplication().publishEvent(context, PreRenderComponentEvent.class, UIComponent.class, (Object)this);
        this._cacheRenderer(context);
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.encodeBegin(context, (UIComponent)this);
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.encodeChildren(context, (UIComponent)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeEnd(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        try {
            Renderer renderer;
            if (this.isRendered() && (renderer = this.getRenderer(context)) != null) {
                renderer.encodeEnd(context, (UIComponent)this);
            }
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException();
        }
        UIComponent parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        parent.queueEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, this);
        try {
            this.decodeChildren(context);
            this.decode(context);
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, this);
        try {
            this.validateChildren(context);
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(context, this);
        try {
            this.updateChildren(context);
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    public Object processSaveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (_LOG.isFiner()) {
            _LOG.finer("processSaveState() on " + (Object)((Object)this));
        }
        this.pushComponentToEL(context, this);
        Object state = null;
        try {
            if ((this._children == null || this._children.isEmpty()) && (this._facets == null || this._facets.isEmpty())) {
                state = this.saveState(context);
            } else {
                TreeState treeState = new TreeState();
                treeState.saveState(context, this);
                if (treeState.isEmpty()) {
                    state = null;
                }
                state = treeState;
            }
        }
        catch (RuntimeException e) {
            _LOG.warning(_LOG.getMessage("COMPONENT_CHILDREN_SAVED_STATE_FAILED", (Object)this));
            throw e;
        }
        finally {
            this.popComponentFromEL(context);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRestoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (_LOG.isFiner()) {
            _LOG.finer("processRestoreState() on " + (Object)((Object)this));
        }
        this.pushComponentToEL(context, this);
        try {
            if (state instanceof TreeState) {
                ((TreeState)state).restoreState(context, this);
            } else {
                this.restoreState(context, state);
            }
        }
        finally {
            this.popComponentFromEL(context);
        }
    }

    @Override
    public void markInitialState() {
        this.getFacesBean().markInitialState();
    }

    public void clearInitialState() {
        this.getFacesBean().clearInitialState();
    }

    public boolean initialStateMarked() {
        return this.getFacesBean().initialStateMarked();
    }

    public Object saveState(FacesContext facesContext) {
        Object state = this.getFacesBean().saveState(facesContext);
        if (StateUtils.checkComponentStateSerialization(facesContext)) {
            try {
                new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(state);
            }
            catch (IOException e) {
                throw new RuntimeException(_LOG.getMessage("COMPONENT_SAVED_STATE_FAILED", (Object)this), e);
            }
        }
        return state;
    }

    public void restoreState(FacesContext facesContext, Object stateObj) {
        this.getFacesBean().restoreState(facesContext, stateObj);
    }

    public String toString() {
        String className = ((Object)((Object)this)).getClass().getName();
        int periodIndex = className.lastIndexOf(46);
        if (periodIndex >= 0) {
            className = className.substring(periodIndex + 1);
        }
        return className + "[" + this.getFacesBean().toString() + ", id=" + this.getId() + "]";
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected final void decodeChildren(FacesContext context) {
        LifecycleRenderer renderer = this.getLifecycleRenderer(context);
        if (renderer != null && renderer.decodeChildren(context, this)) {
            return;
        }
        this.decodeChildrenImpl(context);
    }

    protected void decodeChildrenImpl(FacesContext context) {
        Iterator<UIComponent> kids = this.getRenderedFacetsAndChildren(context);
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            kid.processDecodes(context);
        }
    }

    protected final void validateChildren(FacesContext context) {
        LifecycleRenderer renderer = this.getLifecycleRenderer(context);
        if (renderer != null && renderer.validateChildren(context, this)) {
            return;
        }
        this.validateChildrenImpl(context);
    }

    protected void validateChildrenImpl(FacesContext context) {
        Iterator<UIComponent> kids = this.getRenderedFacetsAndChildren(context);
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            kid.processValidators(context);
        }
    }

    protected final void updateChildren(FacesContext context) {
        LifecycleRenderer renderer = this.getLifecycleRenderer(context);
        if (renderer != null && renderer.updateChildren(context, this)) {
            return;
        }
        this.updateChildrenImpl(context);
    }

    protected void updateChildrenImpl(FacesContext context) {
        Iterator<UIComponent> kids = this.getRenderedFacetsAndChildren(context);
        while (kids.hasNext()) {
            UIComponent kid = kids.next();
            kid.processUpdates(context);
        }
    }

    protected void addFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.getFacesBean().addEntry(_LISTENERS_KEY, listener);
    }

    protected void removeFacesListener(FacesListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.getFacesBean().removeEntry(_LISTENERS_KEY, listener);
    }

    protected FacesListener[] getFacesListeners(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (!FacesListener.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        return (FacesListener[])this.getFacesBean().getEntries(_LISTENERS_KEY, clazz);
    }

    public final ComponentChange addComponentChange(ComponentChange change) {
        return this.addComponentChange(this, change);
    }

    private UIXComponentBase _getNextUIXComponentBaseAnxcestor() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof UIXComponentBase)) continue;
            return (UIXComponentBase)parent;
        }
        return null;
    }

    protected ComponentChange addComponentChange(UIComponent component, ComponentChange change) {
        AttributeComponentChange aa;
        Object attributeValue;
        if (component == this && change instanceof AttributeComponentChange && (attributeValue = (aa = (AttributeComponentChange)change).getAttributeValue()) instanceof RowKeySet) {
            change = new RowKeySetAttributeChange(this.getClientId(this.getFacesContext()), aa.getAttributeName(), attributeValue);
        }
        if (!Boolean.TRUE.equals(this.getAttributes().get(_NO_SUBTREE_CHANGE_ATTR))) {
            UIXComponentBase nextUIXParent = this._getNextUIXComponentBaseAnxcestor();
            if (nextUIXParent != null) {
                return nextUIXParent.addComponentChange(component, change);
            }
            RequestContext trinContext = RequestContext.getCurrentInstance();
            trinContext.getChangeManager().addComponentChange(this.getFacesContext(), component, change);
            return change;
        }
        return null;
    }

    protected void addAttributeChange(String attributeName, Object attributeValue) {
        this.addComponentChange(new AttributeComponentChange(attributeName, attributeValue));
    }

    void __rendererDecode(FacesContext context) {
        this._cacheRenderer(context);
        Renderer renderer = this.getRenderer(context);
        if (renderer != null) {
            renderer.decode(context, (UIComponent)this);
        }
    }

    private void _publishPostAddToViewEvent(FacesContext context, UIComponent component) {
        component.setInView(true);
        context.getApplication().publishEvent(context, PostAddToViewEvent.class, UIComponent.class, (Object)component);
        if (component.getChildCount() > 0) {
            List children = component.getChildren();
            UIComponent child = null;
            UIComponent currentChild = null;
            for (int i = 0; i < children.size(); ++i) {
                child = (UIComponent)children.get(i);
                do {
                    this._publishPostAddToViewEvent(context, child);
                    currentChild = child;
                } while (i < children.size() && (child = (UIComponent)children.get(i)) != currentChild);
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent child : component.getFacets().values()) {
                this._publishPostAddToViewEvent(context, child);
            }
        }
    }

    private void _publishPreRemoveFromViewEvent(FacesContext context, UIComponent component) {
        component.setInView(false);
        context.getApplication().publishEvent(context, PreRemoveFromViewEvent.class, UIComponent.class, (Object)component);
        if (component.getChildCount() > 0) {
            for (UIComponent child : component.getChildren()) {
                this._publishPreRemoveFromViewEvent(context, child);
            }
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent child : component.getFacets().values()) {
                this._publishPreRemoveFromViewEvent(context, child);
            }
        }
    }

    private void _cacheRenderer(FacesContext context) {
        Renderer renderer;
        this._cachedRenderer = renderer = this._getRendererImpl(context);
        this._cachedLifecycleRenderer = renderer instanceof LifecycleRenderer ? (LifecycleRenderer)renderer : null;
    }

    private Renderer _getRendererImpl(FacesContext context) {
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            RenderKit renderKit = context.getRenderKit();
            Renderer renderer = renderKit.getRenderer(this.getFamily(), rendererType);
            if (renderer == null) {
                _LOG.warning("CANNOT_FIND_RENDERER", new Object[]{this, rendererType});
            }
            return renderer;
        }
        return null;
    }

    private LifecycleRenderer _getLifecycleRendererImpl(FacesContext context) {
        Renderer renderer = this._getRendererImpl(context);
        if (renderer instanceof LifecycleRenderer) {
            return (LifecycleRenderer)renderer;
        }
        return null;
    }

    protected Renderer getRenderer(FacesContext context) {
        Renderer renderer = this._cachedRenderer;
        if (renderer != _UNDEFINED_RENDERER) {
            return renderer;
        }
        return this._getRendererImpl(context);
    }

    protected LifecycleRenderer getLifecycleRenderer(FacesContext context) {
        LifecycleRenderer renderer = this._cachedLifecycleRenderer;
        if (renderer != _UNDEFINED_LIFECYCLE_RENDERER) {
            return renderer;
        }
        return this._getLifecycleRendererImpl(context);
    }

    protected void setProperty(PropertyKey key, Object value) {
        this.getFacesBean().setProperty(key, value);
    }

    protected Object getProperty(PropertyKey key) {
        return this.getFacesBean().getProperty(key);
    }

    protected void setBooleanProperty(PropertyKey key, boolean value) {
        this.getFacesBean().setProperty(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    protected boolean getBooleanProperty(PropertyKey key, boolean defaultValue) {
        Object o = this.getFacesBean().getProperty(key);
        if (defaultValue) {
            return !Boolean.FALSE.equals(o);
        }
        return Boolean.TRUE.equals(o);
    }

    protected void setIntProperty(PropertyKey key, int value) {
        this.getFacesBean().setProperty(key, value);
    }

    protected int getIntProperty(PropertyKey key, int defaultValue) {
        Number n = (Number)this.getFacesBean().getProperty(key);
        if (n == null) {
            return defaultValue;
        }
        return n.intValue();
    }

    public int getFacetCount() {
        if (this._facets == null) {
            return 0;
        }
        return this._facets.size();
    }

    protected final void broadcastToMethodBinding(FacesEvent event, MethodBinding method) throws AbortProcessingException {
        if (method != null) {
            try {
                FacesContext context = this.getFacesContext();
                method.invoke(context, new Object[]{event});
            }
            catch (EvaluationException ee) {
                for (Throwable currentThrowable = ee.getCause(); currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
                    if (!(currentThrowable instanceof AbortProcessingException)) continue;
                    throw (AbortProcessingException)currentThrowable;
                }
                throw ee;
            }
        }
    }

    public static MethodExpression adaptMethodBinding(MethodBinding binding) {
        return new MethodBindingMethodExpression(binding);
    }

    protected final void broadcastToMethodExpression(FacesEvent event, MethodExpression method) throws AbortProcessingException {
        if (method != null) {
            try {
                FacesContext context = this.getFacesContext();
                method.invoke(context.getELContext(), new Object[]{event});
            }
            catch (ELException ee) {
                Throwable t = ee.getCause();
                if (t instanceof AbortProcessingException) {
                    throw (AbortProcessingException)t;
                }
                throw ee;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean invokeOnChildrenComponents(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        this.setupChildrenVisitingContext(context);
        boolean found = false;
        try {
            Iterator<UIComponent> children = this.getFacetsAndChildren();
            while (children.hasNext() && !found) {
                found = children.next().invokeOnComponent(context, clientId, callback);
            }
        }
        finally {
            this.tearDownChildrenVisitingContext(context);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean invokeOnNamingContainerComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        boolean invokedComponent;
        block9: {
            assert (this instanceof NamingContainer) : "Only use invokeOnNamingContainerComponent on NamingContainers";
            this.setupVisitingContext(context);
            try {
                String thisClientId = this.getClientId(context);
                if (clientId.equals(thisClientId)) {
                    this.pushComponentToEL(context, null);
                    try {
                        callback.invokeContextCallback(context, (UIComponent)this);
                    }
                    finally {
                        this.popComponentFromEL(context);
                    }
                    invokedComponent = true;
                    break block9;
                }
                invokedComponent = !clientId.startsWith(thisClientId) || clientId.charAt(thisClientId.length()) != ':' ? false : this.invokeOnChildrenComponents(context, clientId, callback);
            }
            finally {
                this.tearDownVisitingContext(context);
            }
        }
        return invokedComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invokeOnComponent(FacesContext context, String clientId, ContextCallback callback) throws FacesException {
        boolean invokedComponent;
        block8: {
            this.setupVisitingContext(context);
            try {
                String thisClientId = this.getClientId(context);
                if (clientId.equals(thisClientId)) {
                    this.pushComponentToEL(context, null);
                    try {
                        callback.invokeContextCallback(context, (UIComponent)this);
                    }
                    finally {
                        this.popComponentFromEL(context);
                    }
                    invokedComponent = true;
                    break block8;
                }
                invokedComponent = this.invokeOnChildrenComponents(context, clientId, callback);
            }
            finally {
                this.tearDownVisitingContext(context);
            }
        }
        return invokedComponent;
    }

    public void subscribeToEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        if (eventClass == null) {
            throw new NullPointerException("eventClass required");
        }
        if (componentListener == null) {
            throw new NullPointerException("componentListener required");
        }
        FacesBean bean = this.getFacesBean();
        AttachedObjects<Class<? extends SystemEvent>, ComponentSystemEventListenerWrapper> eventStorage = (AttachedObjects<Class<? extends SystemEvent>, ComponentSystemEventListenerWrapper>)bean.getProperty(_SYSTEM_EVENT_LISTENERS_KEY);
        if (eventStorage == null) {
            eventStorage = new AttachedObjects<Class<? extends SystemEvent>, ComponentSystemEventListenerWrapper>();
            bean.setProperty(_SYSTEM_EVENT_LISTENERS_KEY, eventStorage);
        }
        eventStorage.addAttachedObject(eventClass, new ComponentSystemEventListenerWrapper(componentListener, this));
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> eventClass, ComponentSystemEventListener componentListener) {
        if (eventClass == null) {
            throw new NullPointerException("eventClass required");
        }
        if (componentListener == null) {
            throw new NullPointerException("componentListener required");
        }
        FacesBean bean = this.getFacesBean();
        AttachedObjects eventStorage = (AttachedObjects)bean.getProperty(_SYSTEM_EVENT_LISTENERS_KEY);
        if (eventStorage == null) {
            return;
        }
        eventStorage.removeAttachedObject(eventClass, new ComponentSystemEventListenerWrapper(componentListener, this));
    }

    public List<SystemEventListener> getListenersForEventClass(Class<? extends SystemEvent> eventClass) {
        FacesBean bean = this.getFacesBean();
        AttachedObjects eventStorage = (AttachedObjects)bean.getProperty(_SYSTEM_EVENT_LISTENERS_KEY);
        if (eventStorage == null) {
            return Collections.emptyList();
        }
        return eventStorage.getAttachedObjectList(eventClass);
    }

    protected void addClientBehavior(String eventName, ClientBehavior behavior) {
        Collection events = ((ClientBehaviorHolder)this).getEventNames();
        if (!events.contains(eventName)) {
            return;
        }
        FacesBean bean = this.getFacesBean();
        AttachedObjects<String, ClientBehavior> behaviors = (AttachedObjects<String, ClientBehavior>)bean.getProperty(_CLIENT_BEHAVIORS_KEY);
        if (behaviors == null) {
            behaviors = new AttachedObjects<String, ClientBehavior>();
            bean.setProperty(_CLIENT_BEHAVIORS_KEY, behaviors);
        }
        behaviors.addAttachedObject(eventName, behavior);
    }

    protected Map<String, List<ClientBehavior>> getClientBehaviors() {
        AttachedObjects behaviors = (AttachedObjects)this.getFacesBean().getProperty(_CLIENT_BEHAVIORS_KEY);
        if (behaviors == null) {
            return Collections.emptyMap();
        }
        return behaviors.getAttachedObjectMap();
    }

    protected String getDefaultEventName() {
        this._ensureClientBehaviorHolder();
        return null;
    }

    private void _ensureClientBehaviorHolder() {
        if (!(this instanceof ClientBehaviorHolder)) {
            throw new IllegalStateException("Component must implement ClientBehaviorHolder in order to make use of this method.");
        }
    }

    static StringBuilder __getSharedStringBuilder() {
        StringBuilder sb = _STRING_BUILDER.get();
        if (sb == null) {
            sb = new StringBuilder();
            _STRING_BUILDER.set(sb);
        }
        sb.setLength(0);
        return sb;
    }

    @Deprecated
    void __encodeRecursive(FacesContext context, UIComponent component) throws IOException {
        component.encodeAll(context);
    }

    private static UIComponent _findInsideOf(UIComponent from, String id) {
        Iterator kids = from.getFacetsAndChildren();
        while (kids.hasNext()) {
            UIComponent returned;
            UIComponent kid = (UIComponent)kids.next();
            if (id.equals(kid.getId())) {
                return kid;
            }
            if (kid instanceof NamingContainer || (returned = UIXComponentBase._findInsideOf(kid, id)) == null) continue;
            return returned;
        }
        return null;
    }

    private void _validateId(String id) {
        if (id == null) {
            return;
        }
        int n = id.length();
        if (0 == n || ':' == id.charAt(0)) {
            this._throwBadId(id);
        }
        for (int i = 0; i < n; ++i) {
            char c = id.charAt(i);
            if (i == 0) {
                if (Character.isLetter(c) || c == '_') continue;
                this._throwBadId(id);
                continue;
            }
            if (Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '_') continue;
            this._throwBadId(id);
        }
    }

    private void _throwBadId(String id) {
        throw new IllegalArgumentException(_LOG.getMessage("ILLEGAL_ID", id));
    }

    private void _init(String rendererType) {
        FacesBean oldBean = this._facesBean;
        FacesBean newBean = this.createFacesBean(rendererType);
        if (oldBean != null) {
            newBean.addAll(oldBean);
        }
        this._attributes = new ValueMap(newBean);
        this._facesBean = newBean;
        boolean usesFacesBeanImpl = false;
        if (newBean instanceof UIXFacesBeanImpl) {
            usesFacesBeanImpl = true;
        } else {
            FacesBean currImpl = newBean;
            while (currImpl instanceof FacesBeanWrapper) {
                if (!((currImpl = ((FacesBeanWrapper)currImpl).getWrappedBean()) instanceof UIXFacesBeanImpl)) continue;
                usesFacesBeanImpl = true;
                break;
            }
        }
        this._usesFacesBeanImpl = usesFacesBeanImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FacesBean.Type _createType() {
        block5: {
            FacesBean.Type type;
            ClassLoader cl = UIXComponentBase._getClassLoader();
            URL url = cl.getResource("META-INF/faces-bean-type.properties");
            if (url == null) break block5;
            Properties properties = new Properties();
            InputStream is = url.openStream();
            try {
                properties.load(is);
                String className = (String)properties.get(UIXComponentBase.class.getName());
                type = (FacesBean.Type)cl.loadClass(className).newInstance();
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception e) {
                    _LOG.severe("CANNOT_LOAD_TYPE_PROPERTIES", e);
                }
            }
            is.close();
            return type;
        }
        return new FacesBean.Type();
    }

    private static ClassLoader _getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = FacesBeanFactory.class.getClassLoader();
        }
        return loader;
    }

    private static boolean _isClientIdCachingEnabled() {
        return _CLIENT_ID_CACHING != ClientIdCaching.OFF;
    }

    private static boolean _isClientIdDebuggingEnabled() {
        return _CLIENT_ID_CACHING == ClientIdCaching.DEBUG;
    }

    private static void _warnClientIdCachingConfig(FacesContext context) {
        if (_CLIENT_ID_CACHING != ClientIdCaching.ON && context.isProjectStage(ProjectStage.Production) && !UIXComponentBase._warnedClientIdCachingConfig(context)) {
            _LOG.warning("The org.apache.myfaces.trinidad.CLIENT_ID_CACHING system property is set to: " + (Object)((Object)_CLIENT_ID_CACHING) + ".  For best performance, client id caching should be ON in production environments.");
            UIXComponentBase._clientIdCachingConfigWarned(context);
        }
    }

    private static boolean _warnedClientIdCachingConfig(FacesContext context) {
        ExternalContext external = context.getExternalContext();
        Map appMap = external.getApplicationMap();
        return Boolean.TRUE.equals(appMap.get(_WARNED_CLIENT_ID_CACHING_KEY));
    }

    private static void _clientIdCachingConfigWarned(FacesContext context) {
        ExternalContext external = context.getExternalContext();
        Map appMap = external.getApplicationMap();
        appMap.put(_WARNED_CLIENT_ID_CACHING_KEY, Boolean.TRUE);
    }

    private static ClientIdCaching _initClientIdCaching() {
        String cachingProperty = UIXComponentBase._getClientIdCachingSystemProperty();
        ClientIdCaching caching = UIXComponentBase._toClientIdCachingEnum(cachingProperty);
        _LOG.config("Client id caching configuration: " + (Object)((Object)caching));
        return caching;
    }

    private static String _getClientIdCachingSystemProperty() {
        try {
            return System.getProperty(_SYSTEM_PROP_CLIENT_ID_CACHING);
        }
        catch (Throwable t) {
            _LOG.warning(t);
            return null;
        }
    }

    private static ClientIdCaching _toClientIdCachingEnum(String cachingProperty) {
        try {
            return Enum.valueOf(ClientIdCaching.class, cachingProperty == null ? "ON" : cachingProperty.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            _LOG.warning("Invalid value specified for org.apache.myfaces.trinidad.CLIENT_ID_CACHING system property: " + cachingProperty + ". Valid values are: on | off | debug.");
            return ClientIdCaching.ON;
        }
    }

    static {
        TYPE.registerKey("javax.faces.webapp.COMPONENT_IDS", List.class, 1);
        TYPE.registerKey("javax.faces.webapp.FACET_NAMES", List.class, 1);
        TYPE.lock();
        _EMPTY_STRING_ITERATOR = CollectionUtils.emptyIterator();
        _EMPTY_UICOMPONENT_ITERATOR = CollectionUtils.emptyIterator();
        _STRING_BUILDER = ThreadLocalUtils.newRequestThreadLocal();
        _CLIENT_ID_CACHING = UIXComponentBase._initClientIdCaching();
        _UNDEFINED_LIFECYCLE_RENDERER = new ExtendedRendererImpl();
        _UNDEFINED_RENDERER = new RendererImpl();
    }

    private static class ComponentSystemEventListenerWrapper
    implements SystemEventListener,
    StateHolder {
        private ComponentSystemEventListener _delegate;
        private Class<?> _componentClass;

        ComponentSystemEventListenerWrapper(ComponentSystemEventListener listener, UIComponent component) {
            this._delegate = listener;
            this._componentClass = component.getClass();
        }

        public ComponentSystemEventListenerWrapper() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ComponentSystemEventListenerWrapper) {
                ComponentSystemEventListenerWrapper other = (ComponentSystemEventListenerWrapper)o;
                return this._componentClass.equals(other._componentClass) && this._delegate.equals(other._delegate);
            }
            return false;
        }

        public int hashCode() {
            return this._componentClass.hashCode() + this._delegate.hashCode();
        }

        public void processEvent(SystemEvent event) throws AbortProcessingException {
            assert (event instanceof ComponentSystemEvent);
            this._delegate.processEvent((ComponentSystemEvent)event);
        }

        public boolean isListenerForSource(Object source) {
            if (this._delegate instanceof SystemEventListener) {
                return ((SystemEventListener)this._delegate).isListenerForSource(source);
            }
            return this._componentClass.isAssignableFrom(source.getClass());
        }

        public Object saveState(FacesContext context) {
            if (this._delegate instanceof UIComponent) {
                return null;
            }
            Object[] state = new Object[]{StateUtils.saveStateHolder(context, this._delegate), this._componentClass};
            return state;
        }

        public void restoreState(FacesContext context, Object state) {
            if (state == null) {
                return;
            }
            Object[] stateArr = (Object[])state;
            Object saved = stateArr[0];
            this._delegate = (ComponentSystemEventListener)(saved == null ? UIComponent.getCurrentComponent((FacesContext)context) : StateUtils.restoreStateHolder(context, saved));
            this._componentClass = (Class)stateArr[1];
        }

        public boolean isTransient() {
            if (this._delegate instanceof StateHolder) {
                return ((StateHolder)this._delegate).isTransient();
            }
            return false;
        }

        public void setTransient(boolean isTransient) {
            if (this._delegate instanceof StateHolder) {
                ((StateHolder)this._delegate).setTransient(isTransient);
            }
        }
    }

    private static enum ClientIdCaching {
        ON,
        OFF,
        DEBUG;

    }

    private static class ExtendedRendererImpl
    extends ExtendedRenderer {
        private ExtendedRendererImpl() {
        }
    }

    private static class RendererImpl
    extends Renderer {
        private RendererImpl() {
        }
    }
}

