/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config;

import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyValueExpression
extends ValueExpression {
    private ValueExpression _valueExpression;
    private final String _expression;
    private final Class<?> _expectedType;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(LazyValueExpression.class);

    public static ValueExpression createValueExpression(String expression, Class<?> expectedType) {
        ValueExpression valueExpression = LazyValueExpression._createValueExpressionFromApplication(expression, expectedType);
        if (valueExpression != null) {
            return valueExpression;
        }
        return new LazyValueExpression(expression, expectedType);
    }

    public Object getValue(ELContext context) {
        return this._getValueExpression().getValue(context);
    }

    public void setValue(ELContext context, Object value) {
        this._getValueExpression().setValue(context, value);
    }

    public boolean isReadOnly(ELContext context) {
        return this._getValueExpression().isReadOnly(context);
    }

    public Class<?> getType(ELContext context) {
        return this._getValueExpression().getType(context);
    }

    public Class<?> getExpectedType() {
        return this._expectedType;
    }

    public String getExpressionString() {
        return this._expression;
    }

    public boolean isLiteralText() {
        return this._getValueExpression().isLiteralText();
    }

    public boolean equals(Object o) {
        return this._getValueExpression().equals(o);
    }

    public int hashCode() {
        return this._getValueExpression().hashCode();
    }

    private LazyValueExpression(String expression, Class<?> expectedType) {
        this._expression = expression;
        this._expectedType = expectedType;
    }

    private static ELContext _getELContext(Application application) {
        FacesContext fContext = FacesContext.getCurrentInstance();
        if (fContext != null) {
            return fContext.getELContext();
        }
        return new MockELContext(application);
    }

    private ValueExpression _getValueExpression() {
        if (this._valueExpression == null) {
            this._valueExpression = LazyValueExpression._createValueExpressionFromApplication(this._expression, this._expectedType);
        }
        return this._valueExpression;
    }

    private static ValueExpression _createValueExpressionFromApplication(String expression, Class<?> expectedType) {
        Application application;
        ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        if (factory != null && (application = factory.getApplication()) != null) {
            ELContext elContext = LazyValueExpression._getELContext(application);
            return application.getExpressionFactory().createValueExpression(elContext, expression, expectedType);
        }
        return null;
    }

    private static class MockELContext
    extends ELContext {
        private final ELResolver _resolver;

        public MockELContext(Application application) {
            this._resolver = application.getELResolver();
        }

        public ELResolver getELResolver() {
            return this._resolver;
        }

        public FunctionMapper getFunctionMapper() {
            return null;
        }

        public VariableMapper getVariableMapper() {
            return null;
        }
    }
}

