/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.context;

import java.util.Map;
import java.util.MissingResourceException;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.context.PartialPageContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.skin.Skin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RenderingContext {
    private String _currentClientId;
    private static final ThreadLocal<RenderingContext> _CURRENT_CONTEXT = new ThreadLocal();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(RenderingContext.class);

    public static RenderingContext getCurrentInstance() {
        return _CURRENT_CONTEXT.get();
    }

    public RenderingContext() {
        this.attach();
    }

    public abstract Map<Object, Object> getProperties();

    public abstract Agent getAgent();

    public abstract LocaleContext getLocaleContext();

    public abstract FormData getFormData();

    public abstract void setFormData(FormData var1);

    public abstract void clearFormData();

    public abstract Skin getSkin();

    public String getTranslatedString(String key) {
        if (key == null) {
            return null;
        }
        try {
            return this.getSkin().getTranslatedString(this.getLocaleContext(), key);
        }
        catch (MissingResourceException mre) {
            _LOG.severe("CANNOT_GET_RESOURCE_KEY", new String[]{key, this.getSkin().getId()});
            return "???" + key + "???";
        }
    }

    public abstract Icon getIcon(String var1);

    public abstract String getStyleClass(String var1);

    public abstract void setSkinResourceKeyMap(Map<String, String> var1);

    public abstract Map<String, String> getSkinResourceKeyMap();

    public abstract boolean isRightToLeft();

    public abstract String getOutputMode();

    public abstract RequestContext.Accessibility getAccessibilityMode();

    public abstract AccessibilityProfile getAccessibilityProfile();

    public abstract boolean isAnimationEnabled();

    public String getCurrentClientId() {
        return this._currentClientId;
    }

    public void setCurrentClientId(String currentClientId) {
        this._currentClientId = currentClientId;
    }

    public abstract PartialPageContext getPartialPageContext();

    public void release() {
        RenderingContext o = _CURRENT_CONTEXT.get();
        _CURRENT_CONTEXT.remove();
        if (o == null) {
            throw new IllegalStateException(_LOG.getMessage("RENDERINGCONTEXT_ALREADY_RELEASED_OR_NEVER_ATTACHED"));
        }
        if (o != this) {
            throw new IllegalStateException(_LOG.getMessage("TRY_RELEASING_DIFFERENT_RENDERINGCONTEXT"));
        }
    }

    protected void attach() {
        RenderingContext o = _CURRENT_CONTEXT.get();
        if (o != null) {
            _LOG.warning("TRYING_ATTACH_RENDERERINGCONTEXT");
        }
        _CURRENT_CONTEXT.set(this);
    }
}

