/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.context.Version;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.skin.SkinCSSParser;
import org.apache.myfaces.trinidadinternal.skin.SkinSelectorPropertiesNode;
import org.apache.myfaces.trinidadinternal.skin.SkinStyleSheetNode;
import org.apache.myfaces.trinidadinternal.skin.SkinStyleSheetParserUtils;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinCSSDocumentHandler {
    private static String _AT_AGENT = "@agent";
    private static String _AT_PLATFORM = "@platform";
    private static String _AT_ACC_PROFILE = "@accessibility-profile";
    private boolean _inStyleRule = false;
    private List<PropertyNode> _propertyNodeList = null;
    private List<CompleteSelectorNode> _completeSelectorNodeList = new ArrayList<CompleteSelectorNode>();
    private int[] _selectorPlatforms = null;
    private Map<Integer, Set<Version>> _selectorAgents = null;
    private LinkedList<Set<String>> _selectorAccPropertiesStack = new LinkedList();
    private Map<String, String> _namespaceMap = new HashMap<String, String>();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SkinCSSDocumentHandler.class);
    private static final Pattern _WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern _AND_MEDIA_PROPERTY_SPLITTER = Pattern.compile("\\band\\s+\\((\\w+)\\s*:\\s*(\\S+)\\s*\\)");

    public List<SkinStyleSheetNode> getSkinStyleSheetNodes() {
        return this._createSkinStyleSheetNodes(this._completeSelectorNodeList, this._namespaceMap);
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void comment(String text) {
    }

    public void startSelector() {
        this._inStyleRule = true;
        this._propertyNodeList = new ArrayList<PropertyNode>();
    }

    public void endSelector(List<String> selectors) {
        if (selectors == null) {
            return;
        }
        int selectorNum = selectors.size();
        for (int i = 0; i < selectorNum; ++i) {
            String selector = selectors.get(i);
            CompleteSelectorNode node = this._createCompleteSelectorNode(selector, this._propertyNodeList, this._selectorAgents, this._selectorPlatforms, this._getSelectorAccProperties());
            this._completeSelectorNodeList.add(node);
        }
        this._inStyleRule = false;
        this._propertyNodeList = null;
    }

    public void property(String name, String value) {
        if (this._inStyleRule && this._propertyNodeList != null) {
            if (name == null || "".equals(name)) {
                _LOG.severe("ERR_PARSING_SKIN_CSS_FILE", new Object[]{name, value});
            } else {
                this._propertyNodeList.add(new PropertyNode(name, value));
            }
        }
    }

    public void atRule(String atRule) {
        if (atRule != null) {
            if (atRule.startsWith("@namespace")) {
                String[] namespaceParts = atRule.split("\\s+");
                if (namespaceParts.length > 2) {
                    String url = namespaceParts[2];
                    if (url.startsWith("url(")) {
                        url = url.substring(4);
                    }
                    if (url.endsWith(");")) {
                        url = url.substring(0, url.length() - 2);
                    } else if (url.endsWith(";")) {
                        url = url.substring(0, url.length() - 1);
                    }
                    url = SkinStyleSheetParserUtils.trimQuotes(url);
                    this._namespaceMap.put(namespaceParts[1], url);
                }
            } else if (atRule.startsWith(_AT_AGENT)) {
                this._parseCustomAtRule(_AT_AGENT, atRule);
            } else if (atRule.startsWith(_AT_PLATFORM)) {
                this._parseCustomAtRule(_AT_PLATFORM, atRule);
            } else if (atRule.startsWith(_AT_ACC_PROFILE)) {
                this._parseCustomAtRule(_AT_ACC_PROFILE, atRule);
            }
        }
    }

    private void _parseCustomAtRule(String type, String atRule) {
        String content = this._getAtRuleContent(atRule);
        this._initAtRuleTargetTypes(type, atRule);
        SkinCSSParser parser = new SkinCSSParser();
        parser.parseCSSDocument(new StringReader(content), this);
        this._resetAtRuleTargetTypes(type);
    }

    private void _resetAtRuleTargetTypes(String type) {
        if (_AT_AGENT.equals(type)) {
            this._selectorAgents = null;
        } else if (_AT_PLATFORM.equals(type)) {
            this._selectorPlatforms = null;
        } else if (_AT_ACC_PROFILE.equals(type)) {
            assert (!this._selectorAccPropertiesStack.isEmpty());
            if (!this._selectorAccPropertiesStack.isEmpty()) {
                this._selectorAccPropertiesStack.removeLast();
            }
        }
    }

    private CompleteSelectorNode _createCompleteSelectorNode(String selector, List<PropertyNode> propertyNodeList, Map<Integer, Set<Version>> selectorAgentVersions, int[] selectorPlatforms, Set<String> selectorAccProperties) {
        int direction = 0;
        if (selector.endsWith(":rtl")) {
            int length = ":rtl".length();
            selector = selector.substring(0, selector.length() - length);
            direction = 2;
        } else if (selector.endsWith(":ltr")) {
            int length = ":ltr".length();
            selector = selector.substring(0, selector.length() - length);
            direction = 1;
        }
        return new CompleteSelectorNode(selector, propertyNodeList, direction, selectorAgentVersions, selectorPlatforms, selectorAccProperties);
    }

    private List<SkinStyleSheetNode> _createSkinStyleSheetNodes(List<CompleteSelectorNode> selectorList, Map<String, String> namespaceMap) {
        ArrayList<SkinStyleSheetNode> skinStyleSheetNodes = new ArrayList<SkinStyleSheetNode>();
        for (CompleteSelectorNode completeSelectorNode : selectorList) {
            int direction = completeSelectorNode.getDirection();
            Map<Integer, Set<Version>> agentVersions = completeSelectorNode.getAgentVersions();
            int[] platforms = completeSelectorNode.getPlatforms();
            Set<String> accProperties = completeSelectorNode.getAccessibilityProperties();
            boolean match = false;
            for (int i = skinStyleSheetNodes.size() - 1; i >= 0 && !match; --i) {
                SkinStyleSheetNode ssNode = (SkinStyleSheetNode)skinStyleSheetNodes.get(i);
                match = ssNode.matches(direction, agentVersions, platforms, accProperties);
                if (!match) continue;
                ssNode.add(completeSelectorNode.getSkinSelectorPropertiesNode());
            }
            if (match) continue;
            SkinStyleSheetNode ssNode = new SkinStyleSheetNode(namespaceMap, direction, agentVersions, platforms, accProperties);
            ssNode.add(completeSelectorNode.getSkinSelectorPropertiesNode());
            skinStyleSheetNodes.add(ssNode);
        }
        return skinStyleSheetNodes;
    }

    private void _initAtRuleTargetTypes(String type, String atRule) {
        int firstSpace = atRule.indexOf(32);
        int openBrace = atRule.indexOf(123);
        if (firstSpace != -1 && openBrace != -1) {
            String types = atRule.substring(firstSpace, openBrace);
            String[] typeArray = types.split(",");
            if (_AT_AGENT.equals(type)) {
                this._selectorAgents = new HashMap<Integer, Set<Version>>();
                for (int i = 0; i < typeArray.length; ++i) {
                    String[] sections = _WHITESPACE_PATTERN.split(typeArray[i].trim(), 2);
                    if (sections.length == 0) {
                        throw new IllegalArgumentException("Invalid @agent string: " + typeArray[i]);
                    }
                    int agentInt = NameUtils.getBrowser(sections[0]);
                    if (agentInt == 0) continue;
                    HashSet<Version> versions = new HashSet<Version>();
                    this._selectorAgents.put(agentInt, versions);
                    if (sections.length != 2) continue;
                    Matcher m = _AND_MEDIA_PROPERTY_SPLITTER.matcher(sections[1]);
                    while (m.find()) {
                        String propName = m.group(1);
                        String version = m.group(2);
                        if (!"version".equals(propName)) {
                            throw new IllegalArgumentException("Invalid @agent property name: " + propName);
                        }
                        versions.add(new Version(version, "*"));
                    }
                }
            } else if (_AT_PLATFORM.equals(type)) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i = 0; i < typeArray.length; ++i) {
                    int platformInt = NameUtils.getPlatform(typeArray[i].trim());
                    if (platformInt == 0) continue;
                    list.add(platformInt);
                }
                this._selectorPlatforms = this._getIntArray(list);
            } else if (_AT_ACC_PROFILE.equals(type)) {
                Set<String> set = new HashSet<String>(typeArray.length * 2);
                for (int i = 0; i < typeArray.length; ++i) {
                    String accProp = typeArray[i].trim();
                    if (NameUtils.isAccessibilityPropertyName(accProp)) {
                        set.add(accProp);
                        continue;
                    }
                    _LOG.warning("INVALID_ACC_PROFILE", new Object[]{accProp});
                }
                if (!this._selectorAccPropertiesStack.isEmpty()) {
                    set = this._mergeAccProperties(this._selectorAccPropertiesStack.getLast(), set);
                }
                this._selectorAccPropertiesStack.add(set);
            }
        }
    }

    private int[] _getIntArray(List<Integer> integerList) {
        int count = integerList.size();
        if (count == 0) {
            return null;
        }
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = integerList.get(i);
        }
        return array;
    }

    private String _getAtRuleContent(String atRule) {
        int openBraceIndex = atRule.indexOf(123);
        int endBraceIndex = atRule.lastIndexOf(125);
        if (endBraceIndex == -1) {
            endBraceIndex = atRule.length();
        }
        if (openBraceIndex == -1) {
            return null;
        }
        return atRule.substring(openBraceIndex + 1, endBraceIndex);
    }

    private Set<String> _getSelectorAccProperties() {
        return this._selectorAccPropertiesStack.isEmpty() ? null : this._selectorAccPropertiesStack.getLast();
    }

    private Set<String> _mergeAccProperties(Set<String> oldProperties, Set<String> newProperties) {
        if (oldProperties == null || oldProperties.isEmpty()) {
            return newProperties;
        }
        if (newProperties == null || newProperties.isEmpty()) {
            return new HashSet<String>(oldProperties);
        }
        int mergedSize = oldProperties.size() + newProperties.size();
        HashSet<String> mergedProperties = new HashSet<String>(mergedSize * 2);
        for (String oldProperty : oldProperties) {
            for (String newProperty : newProperties) {
                mergedProperties.add(oldProperty + "&" + newProperty);
            }
        }
        return mergedProperties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompleteSelectorNode {
        private SkinSelectorPropertiesNode _node;
        private int _direction;
        private Map<Integer, Set<Version>> _agentVersions;
        private int[] _platforms;
        private Set<String> _accProperties;

        public CompleteSelectorNode(String selectorName, List<PropertyNode> propertyNodes, int direction, Map<Integer, Set<Version>> agentVersions, int[] platforms, Set<String> accProperties) {
            this._node = new SkinSelectorPropertiesNode(selectorName, propertyNodes);
            this._direction = direction;
            this._agentVersions = agentVersions != null ? new HashMap<Integer, Set<Version>>(agentVersions) : new HashMap();
            this._platforms = CompleteSelectorNode._copyIntArray(platforms);
            if (accProperties != null) {
                this._accProperties = new HashSet<String>(accProperties);
            }
        }

        public SkinSelectorPropertiesNode getSkinSelectorPropertiesNode() {
            return this._node;
        }

        public int getDirection() {
            return this._direction;
        }

        public Map<Integer, Set<Version>> getAgentVersions() {
            return this._agentVersions;
        }

        public int[] getPlatforms() {
            return this._platforms;
        }

        public Set<String> getAccessibilityProperties() {
            return this._accProperties;
        }

        private static int[] _copyIntArray(int[] array) {
            if (array == null) {
                return null;
            }
            int[] copy = new int[array.length];
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
    }
}

