/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.share.io;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.myfaces.trinidadinternal.share.io.DefaultNameResolver;

public class ServletNameResolver
extends DefaultNameResolver {
    private final ServletRequest _request;
    private final ServletContext _context;

    public ServletNameResolver(ServletRequest request, ServletContext context) {
        super(null, null);
        this._request = request;
        this._context = context;
    }

    protected File getFile(String name) {
        String rootName = name.startsWith("/") ? name : "/" + name;
        File file = this._context != null ? ServletNameResolver._getFile(this._context.getRealPath(rootName)) : null;
        if (this._request != null && file == null) {
            file = ServletNameResolver._getFile(this._request.getRealPath(rootName));
        }
        if (file != null) {
            return file;
        }
        return super.getFile(name);
    }

    protected URL getURL(String name) {
        if (this._context == null) {
            return null;
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        try {
            URL resource = this._context.getResource(name);
            return resource;
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private static File _getFile(String path) {
        File file;
        if (path != null && (file = new File(path)).exists()) {
            return file;
        }
        return null;
    }
}

