/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.schedule;

import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.apache.myfaces.custom.schedule.HtmlSchedule;
import org.apache.myfaces.custom.schedule.ScheduleMouseListener;
import org.apache.myfaces.custom.schedule.model.Interval;
import org.apache.myfaces.custom.schedule.model.ScheduleDay;

public class ScheduleMouseEvent
extends FacesEvent
implements Serializable {
    public static final int SCHEDULE_NOTHING_CLICKED = 0;
    public static final int SCHEDULE_BODY_CLICKED = 1;
    public static final int SCHEDULE_HEADER_CLICKED = 2;
    public static final int SCHEDULE_ENTRY_CLICKED = 3;
    private static final long serialVersionUID = -2810582008938303475L;
    private final int eventType;

    public ScheduleMouseEvent(HtmlSchedule source, int eventType) {
        super((UIComponent)source);
        this.eventType = eventType;
    }

    public Date getClickedDate() {
        return this.getSchedule().getLastClickedDateAndTime();
    }

    public Date getClickedTime() {
        return this.getSchedule().getLastClickedDateAndTime();
    }

    public Interval getClickedInterval() {
        Date clickedDate = this.getClickedDate();
        Iterator intervalIt = this.getSchedule().getModel().iterator();
        while (intervalIt.hasNext()) {
            ScheduleDay day = (ScheduleDay)intervalIt.next();
            if (!day.equalsDate(clickedDate)) continue;
            return day.getInterval(clickedDate);
        }
        return null;
    }

    public int getEventType() {
        return this.eventType;
    }

    public HtmlSchedule getSchedule() {
        return (HtmlSchedule)this.getSource();
    }

    public boolean isAppropriateListener(FacesListener listener) {
        return listener instanceof ScheduleMouseListener;
    }

    public void processListener(FacesListener listener) {
        if (listener instanceof ScheduleMouseListener) {
            ScheduleMouseListener mouseListener = (ScheduleMouseListener)listener;
            mouseListener.processMouseEvent(this);
        }
    }
}

