/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.MyFacesResourceHandler;
import org.apache.myfaces.renderkit.html.util.ResourceHandler;
import org.apache.myfaces.renderkit.html.util.ResourceLoader;
import org.apache.myfaces.renderkit.html.util.ResourcePosition;
import org.apache.myfaces.shared_tomahawk.config.MyfacesConfig;
import org.apache.myfaces.shared_tomahawk.util.ClassUtils;

public class NonBufferingAddResource
implements AddResource {
    protected static final String PATH_SEPARATOR = "/";
    protected String _contextPath;
    private static final String RESOURCES_CACHE_KEY = AddResource.class.getName() + ".CACHE_KEY";
    private String resourceVirtualPath;
    protected Log log = LogFactory.getLog((Class)NonBufferingAddResource.class);

    public void setContextPath(String contextPath) {
        if (this._contextPath != null) {
            throw new SecurityException("context path already set");
        }
        this._contextPath = contextPath;
    }

    public void addJavaScriptHere(FacesContext context, Class myfacesCustomComponent, String resourceName) throws IOException {
        this.addJavaScriptHere(context, new MyFacesResourceHandler(myfacesCustomComponent, resourceName));
    }

    public void addJavaScriptHere(FacesContext context, String uri) throws IOException {
        NonBufferingAddResource.writeJavaScriptReference(context, this.getResourceUri(context, uri), true, false);
    }

    protected static void writeJavaScriptReference(FacesContext context, String resourceUri, boolean encoding, boolean defer) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String src = null;
        src = encoding ? context.getExternalContext().encodeResourceURL(resourceUri) : resourceUri;
        NonBufferingAddResource.writeJavaScriptReference(defer, writer, src);
    }

    protected static void writeJavaScriptReference(HttpServletResponse response, ResponseWriter writer, String resourceUri, boolean encoding, boolean defer) throws IOException {
        String src = null;
        src = encoding ? response.encodeURL(resourceUri) : resourceUri;
        NonBufferingAddResource.writeJavaScriptReference(defer, writer, src);
    }

    private static void writeJavaScriptReference(boolean defer, ResponseWriter writer, String src) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        if (defer) {
            writer.writeAttribute("defer", (Object)"true", null);
        }
        writer.writeURIAttribute("src", (Object)src, null);
        writer.endElement("script");
    }

    protected static void writeStyleReference(FacesContext context, String resourceUri) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("link", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("href", (Object)context.getExternalContext().encodeResourceURL(resourceUri), null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.endElement("link");
    }

    protected static void writeStyleReference(HttpServletResponse response, ResponseWriter writer, String resourceUri) throws IOException {
        writer.startElement("link", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("href", (Object)response.encodeURL(resourceUri), null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.endElement("link");
    }

    protected static void writeInlineScript(ResponseWriter writer, String inlineScript) throws IOException {
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeText((Object)inlineScript, null);
        writer.endElement("script");
    }

    protected static void writeInlineStylesheet(ResponseWriter writer, String inlineStyle) throws IOException {
        writer.startElement("style", null);
        writer.writeAttribute("rel", (Object)"stylesheet", null);
        writer.writeAttribute("type", (Object)"text/css", null);
        writer.writeText((Object)inlineStyle, null);
        writer.endElement("style");
    }

    public void addJavaScriptHerePlain(FacesContext context, String uri) throws IOException {
        NonBufferingAddResource.writeJavaScriptReference(context, this.getResourceUri(context, uri), false, false);
    }

    public void addJavaScriptHere(FacesContext context, ResourceHandler resourceHandler) throws IOException {
        this.validateResourceHandler(resourceHandler);
        NonBufferingAddResource.writeJavaScriptReference(context, this.getResourceUri(context, resourceHandler), true, false);
    }

    public void addResourceHere(FacesContext context, ResourceHandler resourceHandler) throws IOException {
        this.validateResourceHandler(resourceHandler);
        String path = this.getResourceUri(context, resourceHandler);
        ResponseWriter writer = context.getResponseWriter();
        writer.write(context.getExternalContext().encodeResourceURL(path));
    }

    protected void validateResourceHandler(ResourceHandler resourceHandler) {
        if (resourceHandler == null) {
            throw new IllegalArgumentException("ResourceHandler is null");
        }
        this.validateResourceLoader(resourceHandler.getResourceLoaderClass());
    }

    protected void validateResourceLoader(Class resourceloader) {
        if (!ResourceLoader.class.isAssignableFrom(resourceloader)) {
            throw new FacesException("Class " + resourceloader.getName() + " must implement " + ResourceLoader.class.getName());
        }
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler) {
        try {
            NonBufferingAddResource.writeJavaScriptReference(context, this.getResourceUri(context, resourceHandler), true, false);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        try {
            NonBufferingAddResource.writeJavaScriptReference(context, this.getResourceUri(context, new MyFacesResourceHandler(myfacesCustomComponent, resourceName)), true, false);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName, boolean defer) {
        try {
            NonBufferingAddResource.writeJavaScriptReference(context, this.getResourceUri(context, new MyFacesResourceHandler(myfacesCustomComponent, resourceName)), true, true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, String uri) {
        try {
            NonBufferingAddResource.writeJavaScriptReference(context, this.getResourceUri(context, uri), true, false);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, String uri, boolean defer) {
        try {
            NonBufferingAddResource.writeJavaScriptReference(context, this.getResourceUri(context, uri), true, true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addJavaScriptToBodyTag(FacesContext context, String javascriptEventName, String addedJavaScript) {
        throw new UnsupportedOperationException("not supported anymore - use javascript to register your body-event-handler directly");
    }

    public void addJavaScriptAtPosition(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler, boolean defer) {
        try {
            NonBufferingAddResource.writeJavaScriptReference(context, this.getResourceUri(context, resourceHandler), true, defer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addJavaScriptAtPositionPlain(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        try {
            NonBufferingAddResource.writeJavaScriptReference(context, this.getResourceUri(context, new MyFacesResourceHandler(myfacesCustomComponent, resourceName)), false, false);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, Class myfacesCustomComponent, String resourceName) {
        try {
            NonBufferingAddResource.writeStyleReference(context, this.getResourceUri(context, new MyFacesResourceHandler(myfacesCustomComponent, resourceName)));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, String uri) {
        try {
            NonBufferingAddResource.writeStyleReference(context, this.getResourceUri(context, uri));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addStyleSheet(FacesContext context, ResourcePosition position, ResourceHandler resourceHandler) {
        try {
            NonBufferingAddResource.writeStyleReference(context, this.getResourceUri(context, resourceHandler));
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addInlineStyleAtPosition(FacesContext context, ResourcePosition position, String inlineStyle) {
        try {
            NonBufferingAddResource.writeInlineStylesheet(context.getResponseWriter(), inlineStyle);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void addInlineScriptAtPosition(FacesContext context, ResourcePosition position, String inlineScript) {
        try {
            NonBufferingAddResource.writeInlineScript(context.getResponseWriter(), inlineScript);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String getResourceUri(FacesContext context, Class myfacesCustomComponent, String resource, boolean withContextPath) {
        return this.getResourceUri(context, new MyFacesResourceHandler(myfacesCustomComponent, resource), withContextPath);
    }

    public String getResourceUri(FacesContext context, Class myfacesCustomComponent, String resource) {
        return this.getResourceUri(context, new MyFacesResourceHandler(myfacesCustomComponent, resource));
    }

    public String getResourceUri(FacesContext context, ResourceHandler resourceHandler) {
        String uri = resourceHandler.getResourceUri(context);
        if (uri == null) {
            return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), true);
        }
        return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), true) + uri;
    }

    public String getResourceUri(FacesContext context, ResourceHandler resourceHandler, boolean withContextPath) {
        String uri = resourceHandler.getResourceUri(context);
        if (uri == null) {
            return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), withContextPath);
        }
        return this.getResourceUri(context, resourceHandler.getResourceLoaderClass(), withContextPath) + uri;
    }

    public String getResourceUri(FacesContext context, String uri) {
        return this.getResourceUri(context, uri, true);
    }

    public String getResourceUri(FacesContext context, String uri, boolean withContextPath) {
        if (withContextPath) {
            return context.getApplication().getViewHandler().getResourceURL(context, uri);
        }
        return uri;
    }

    protected String getResourceUri(FacesContext context, Class resourceLoader, boolean withContextPath) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(MyfacesConfig.getCurrentInstance(context.getExternalContext()).getResourceVirtualPath());
        sb.append(PATH_SEPARATOR);
        sb.append(resourceLoader.getName());
        sb.append(PATH_SEPARATOR);
        sb.append(this.getCacheKey(context));
        sb.append(PATH_SEPARATOR);
        return this.getResourceUri(context, sb.toString(), withContextPath);
    }

    protected long getCacheKey(FacesContext context) {
        Map applicationMap = context.getExternalContext().getApplicationMap();
        Long cacheKey = (Long)applicationMap.get(RESOURCES_CACHE_KEY);
        if (cacheKey == null) {
            cacheKey = new Long(System.currentTimeMillis() / 100000L);
            applicationMap.put(RESOURCES_CACHE_KEY, cacheKey);
        }
        return cacheKey;
    }

    public boolean isResourceUri(ServletContext servletContext, HttpServletRequest request) {
        String path = this._contextPath != null ? this._contextPath + this.getResourceVirtualPath(servletContext) : this.getResourceVirtualPath(servletContext);
        try {
            if (request.getRequestURI().startsWith(URLEncoder.encode(path, "UTF-8"))) {
                return true;
            }
        }
        catch (UnsupportedEncodingException e) {
            this.log.error((Object)"Unsupported encoding UTF-8 used", (Throwable)e);
        }
        return request.getRequestURI().startsWith(path);
    }

    private String getResourceVirtualPath(ServletContext servletContext) {
        if (this.resourceVirtualPath == null) {
            this.resourceVirtualPath = servletContext.getInitParameter("org.apache.myfaces.RESOURCE_VIRTUAL_PATH");
            if (this.resourceVirtualPath == null) {
                this.resourceVirtualPath = "/faces/myFacesExtensionResource";
            }
        }
        return this.resourceVirtualPath;
    }

    private Class getClass(String className) throws ClassNotFoundException {
        Class clazz = ClassUtils.classForName(className);
        this.validateResourceLoader(clazz);
        return clazz;
    }

    public void serveResource(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathInfo = request.getPathInfo();
        String uri = request.getContextPath() + request.getServletPath() + (pathInfo == null ? "" : pathInfo);
        String classNameStartsAfter = this.getResourceVirtualPath(context) + '/';
        int posStartClassName = uri.indexOf(classNameStartsAfter) + classNameStartsAfter.length();
        int posEndClassName = uri.indexOf(PATH_SEPARATOR, posStartClassName);
        String className = uri.substring(posStartClassName, posEndClassName);
        int posEndCacheKey = uri.indexOf(PATH_SEPARATOR, posEndClassName + 1);
        String resourceUri = null;
        if (posEndCacheKey + 1 < uri.length()) {
            resourceUri = uri.substring(posEndCacheKey + 1);
        }
        try {
            Class resourceLoader = this.getClass(className);
            this.validateResourceLoader(resourceLoader);
            ((ResourceLoader)resourceLoader.newInstance()).serveResource(context, request, response, resourceUri);
        }
        catch (ResourceLoader.ClosedSocketException e) {
        }
        catch (ClassNotFoundException e) {
            this.log.error((Object)("Could not find class for name: " + className), (Throwable)e);
            response.sendError(404, "Could not find resourceloader class for name: " + className);
        }
        catch (InstantiationException e) {
            this.log.error((Object)("Could not instantiate class for name: " + className), (Throwable)e);
            response.sendError(500, "Could not instantiate resourceloader class for name: " + className);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)("Could not access class for name: " + className), (Throwable)e);
            response.sendError(403, "Could not access resourceloader class for name: " + className);
        }
        catch (Throwable e) {
            this.log.error((Object)("Error while serving resource: " + resourceUri + ", message : " + e.getMessage()), e);
            response.sendError(500);
        }
    }

    public void parseResponse(HttpServletRequest request, String bufferedResponse, HttpServletResponse response) throws IOException {
        throw new UnsupportedOperationException("non-buffering add resource is not buffering.");
    }

    public void writeMyFacesJavascriptBeforeBodyEnd(HttpServletRequest request, HttpServletResponse response) throws IOException {
        throw new UnsupportedOperationException("non-buffering add resource is not buffering.");
    }

    public void writeWithFullHeader(HttpServletRequest request, HttpServletResponse response) throws IOException {
        throw new UnsupportedOperationException("non-buffering add resource is not buffering.");
    }

    public void writeResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        throw new UnsupportedOperationException("non-buffering add resource is not buffering.");
    }

    public boolean requiresBuffer() {
        return false;
    }

    public void responseStarted() {
    }

    public void responseFinished() {
    }

    public boolean hasHeaderBeginInfos() {
        return false;
    }
}

