/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.util;

import java.lang.invoke.MethodHandles;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import javax.naming.InitialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthorizationHelperCdi {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private BeanManager beanManager;

    AuthorizationHelperCdi() {
        try {
            InitialContext context = new InitialContext();
            this.beanManager = (BeanManager)context.lookup("java:comp/BeanManager");
        }
        catch (Exception exception) {
            LOG.warn("Can't obtain 'java:comp/BeanManager'");
        }
        if (this.beanManager == null) {
            this.beanManager = (BeanManager)FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().get(BeanManager.class.getName());
        }
        LOG.info("Using bean manager: '{}'", (Object)this.beanManager);
    }

    Object getObject(String beanString) {
        Bean bean = null;
        for (Bean entry : this.beanManager.getBeans(beanString)) {
            if (bean == null) {
                bean = entry;
                continue;
            }
            LOG.warn("Bean name ambiguous: '{}'", (Object)beanString);
        }
        return bean;
    }

    Class getBeanClass(Object bean) {
        return ((Bean)bean).getBeanClass();
    }

    boolean hasBeanManager() {
        return this.beanManager != null;
    }
}

