/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.lib;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/**
 * Compose two filter objects together, as if filter2 is nested within filter1.
 */
public abstract class CompoundFilter implements Filter
{
    private final Filter filter1;
    private final Filter filter2;

    public CompoundFilter(Filter filter1, Filter filter2)
    {
        this.filter1 = filter1;
        this.filter2 = filter2;
    }

    public void init(FilterConfig filterConfig) throws ServletException
    {
        filter1.init(filterConfig);
        filter2.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse,
        final FilterChain filterChain) throws IOException, ServletException
    {
        FilterChain chain = new FilterChain()
        {
            public void doFilter(ServletRequest req, ServletResponse rsp) throws IOException, ServletException
            {
                filter2.doFilter(req, rsp, filterChain);
            }
            
        };
        
        filter1.doFilter(servletRequest, servletResponse, chain);
    }

    public void destroy()
    {
        filter2.destroy();
        filter1.destroy();
    }
}
