/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.conversation.spring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.Conversation;
import org.apache.myfaces.orchestra.conversation.spring.AbstractSpringOrchestraScope;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.autoproxy.AbstractAutoProxyCreator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ConfigurableApplicationContext;

class OrchestraAdvisorBeanPostProcessor
extends AbstractAutoProxyCreator {
    private static final long serialVersionUID = 1L;
    private final Log log = LogFactory.getLog(OrchestraAdvisorBeanPostProcessor.class);
    private ConfigurableApplicationContext appContext;

    public OrchestraAdvisorBeanPostProcessor(ConfigurableApplicationContext appContext) {
        this.appContext = appContext;
        this.setProxyTargetClass(true);
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource customTargetSource) throws BeansException {
        Scope scopeObj;
        BeanDefinition bd;
        try {
            bd = this.appContext.getBeanFactory().getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Bean has no definition:" + beanName));
            }
            return null;
        }
        String scopeName = bd.getScope();
        if (scopeName == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("no scope associated with bean " + beanName));
            }
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing scope [" + scopeName + "]"));
        }
        if ((scopeObj = this.appContext.getBeanFactory().getRegisteredScope(scopeName)) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No scope object for scope [" + scopeName + "]"));
            }
            return null;
        }
        if (!(scopeObj instanceof AbstractSpringOrchestraScope)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("scope associated with bean " + beanName + " is not orchestra:" + scopeObj.getClass().getName()));
            }
            return null;
        }
        AbstractSpringOrchestraScope scopeForThisBean = (AbstractSpringOrchestraScope)scopeObj;
        Conversation conversation = scopeForThisBean.getConversationForBean(beanName);
        if (conversation == null) {
            throw new IllegalStateException("Internal error: null conversation for bean " + beanName);
        }
        Object[] advisors = scopeForThisBean.getAdvisors(conversation, beanName);
        return advisors;
    }
}

