/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.myfaces.orchestra.conversation.spring;

/**
 * Interface which will be used by the {@link PersistenceContextConversationInterceptor}
 * to configure the spring persistence framework.
 * <p>
 * Implementations of this interface are expected to hold a reference to a real
 * ORM-specific object (eg a JPA EntityManager or a Hibernate Session).
 */
public interface PersistenceContext
{
    /**
     * Make the underlying object available via the standard APIs for the underlying
     * real ORM implementation. Typically this involves doing something like binding
     * the object to the current thread.
     */
    public void bind();

    /**
     * Unbind the underlying object, so it is no longer available via the standard
     * APIs for the underlying ORM implementation.
     */
    public void unbind();

    /**
     * Close the underlying persistence context.
     */
    public void close();
}
